/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.admin;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;

@ParentPackage(value="admin")
@InterceptorRefs(value={@InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="defaultStack")})
@Result(name="success", type="redirect", location="list-projects")
public class DeleteProjectsAction
extends CoserAction {
    private static final long serialVersionUID = 6024588562104111883L;
    private static final Log log = LogFactory.getLog(DeleteProjectsAction.class);
    protected List<String> indicatorsZonesId;
    protected List<String> mapsZonesId;

    public void setIndicatorsZonesId(List<String> indicatorsZonesId) {
        this.indicatorsZonesId = indicatorsZonesId;
    }

    public void setMapsZonesId(List<String> mapsZonesId) {
        this.mapsZonesId = mapsZonesId;
    }

    public String execute() {
        WebService webService = ServiceFactory.getWebService();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete indicators zone : " + this.indicatorsZonesId));
            }
            if (CollectionUtils.isNotEmpty((Collection)this.indicatorsZonesId)) {
                webService.deleteIndicatorsResult(this.indicatorsZonesId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete maps zone : " + this.mapsZonesId));
            }
            if (CollectionUtils.isNotEmpty((Collection)this.mapsZonesId)) {
                webService.deleteMapsResult(this.mapsZonesId);
            }
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get data from web service", (Throwable)ex);
        }
        return "success";
    }
}

