/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebConfig;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.io.File;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.nuiton.util.StringUtil;

public class UploadResultAction
extends CoserAction {
    private static final long serialVersionUID = 3887268253160622587L;
    private static final Log log = LogFactory.getLog(UploadResultAction.class);
    protected File resultFile;
    protected String login;
    protected String sha1Password;

    public File getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setSha1Password(String sha1Password) {
        this.sha1Password = sha1Password;
    }

    public String getSha1Password() {
        return this.sha1Password;
    }

    public String execute() {
        CoserWebConfig config;
        if (log.isInfoEnabled()) {
            log.info((Object)"Result action called");
        }
        if ((config = ServiceFactory.getCoserConfig()).getAdminPassword() == null || config.getAdminLogin() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No admin password set, cannot enable result upload");
            }
        } else if (config.getAdminLogin().equals(this.login) && this.equalsSHA1Password(config, this.sha1Password)) {
            if (this.resultFile != null) {
                WebService webService = ServiceFactory.getWebService();
                try {
                    webService.registerNewUploadedResults(this.resultFile);
                }
                catch (CoserBusinessException ex) {
                    throw new CoserWebException("Can't register new result file", (Throwable)ex);
                }
                return "success";
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)"File is null");
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Wrong login/password : login = " + this.login));
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            response.setStatus(403);
        }
        return "input";
    }

    protected boolean equalsSHA1Password(CoserWebConfig config, String sha1Password) {
        String configSha1Password = config.getAdminPassword();
        boolean result = configSha1Password.equals(sha1Password);
        if (!result) {
            configSha1Password = StringUtil.encodeSHA1((String)configSha1Password);
            result = configSha1Password.equals(sha1Password);
        }
        return result;
    }
}

