/*
 * #%L
 * $Id: ZoneAction.java 573 2011-01-25 16:01:34Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0.2/coser-web/src/main/java/fr/ifremer/coser/web/actions/source/ZoneAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.source;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CommonZone;

/**
 * Affiche la liste des sous zones (zone).
 * 
 * @author chatellier
 * @version $Revision: 573 $
 * 
 * Last update : $Date: 2011-01-25 17:01:34 +0100 (mar., 25 janv. 2011) $
 * By : $Author: chatellier $
 */
public class ZoneAction extends CommonZone {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        try {
            // renvoi la liste des id subzone-survey et leurs label associé
            zones = webService.getZoneForFacade(facade, true);
            zonesPictures = webService.getZonePictures();
            zonesMetaInfo = webService.getZoneMetaInfo();
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", ex);
        }

        return SUCCESS;
    }
}
