/*
 * #%L
 * $Id: MapDataAction.java 558 2011-01-24 17:11:31Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0.2/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/MapDataAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Appelé par le navigateur pour récuperer le contenu de l'image.
 * 
 * @author chatellier
 * @version $Revision: 558 $
 * 
 * Last update : $Date: 2011-01-24 18:11:31 +0100 (lun., 24 janv. 2011) $
 * By : $Author: chatellier $
 */
public class MapDataAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    protected String survey;

    protected String species;

    public String getSurvey() {
        return survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }

    public String getSpecies() {
        return species;
    }
    
    public void setSpecies(String species) {
        this.species = species;
    }
    
    @Action(results= {@Result(type="stream", params={"contentType", "image/png", "inputName", "inputStream"})})
    public String execute() {
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();

        InputStream input = null;
        try {
            // work with null species (get Repartition-stations map)
            File mapImage = webService.getMapFile(survey, species);
            input = new FileInputStream(mapImage);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get map file", ex);
        } catch (FileNotFoundException ex) {
            throw new CoserWebException("Can't get map file", ex);
        }
        
        return input;
    }
}
