package fr.ifremer.coselmar.beans;

/*
 * #%L
 * Coselmar :: Rest Services
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Locale;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.nuiton.i18n.I18n;

/**
 * @author ymartel <martel@codelutin.com>
 */
public class UserAccountCreatedMail {

    protected Locale locale;

    protected String to;

    private UserBean user;

    private String coselmarUrl;
    private String password;

    public UserAccountCreatedMail(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return locale;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String mail) {
        this.to = mail;
    }

    public String getSubject() {
        String fullname = Strings.nullToEmpty(user.getFirstName()) + " " + Strings.nullToEmpty(user.getName());
        if (StringUtils.isBlank(fullname)) {
            return I18n.l(locale, "coselmar.service.mail.UserAccountCreatedMail.subject", user.getMail());
        }
        return I18n.l(locale, "coselmar.service.mail.UserAccountCreatedMail.subject", fullname);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public boolean isRecipientProvided() {
        boolean isRecipientProvided = StringUtils.isNotBlank(this.to);
        return isRecipientProvided;
    }

    public UserBean getUser() {
        return user;
    }

    public void setUser(UserBean user) {
        this.user = user;
    }

    public String getCoselmarUrl() {
        return coselmarUrl;
    }

    public void setCoselmarUrl(String coselmarUrl) {
        this.coselmarUrl = coselmarUrl;
    }

    public String getPassword () {
        return password;
    }

    public void setPassword (String password) {
        this.password = password;
    }
}
