package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coselmar.persistence.AbstractCoselmarTopiaDao;
import fr.ifremer.coselmar.persistence.CoselmarEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Tue Mar 03 15:18:20 UTC 2015")
public abstract class GeneratedDocumentTopiaDao<E extends Document> extends AbstractCoselmarTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Document.class;
    }

    @Override
    public CoselmarEntityEnum getTopiaEntityEnum() {
        return CoselmarEntityEnum.Document;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM question main, relateddocuments_relatedquestion secondary " +
                    " WHERE main.topiaId=secondary.relatedQuestion " +
                    " AND secondary.relatedDocuments='" + entity.getTopiaId() + "'";
            List<Question> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", CoselmarEntityEnum.Question.getImplementation())
                    .list();

            for (Question item : list) {
                item.removeRelatedDocuments(entity);
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepositDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_DEPOSIT_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepositDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_DEPOSIT_DATE, v);
        return result;
    }

    @Deprecated
    public E findByDepositDate(Date v) {
        return forDepositDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDepositDate(Date v) {
        return forDepositDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forKeywordsContains(String v) {
        return forContains(Document.PROPERTY_KEYWORDS, v);
    }

    @Deprecated
    public E findContainsKeywords(String v) {
        return forKeywordsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsKeywords(String v) {
        return forKeywordsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMimeTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_MIME_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMimeTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_MIME_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByMimeType(String v) {
        return forMimeTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMimeType(String v) {
        return forMimeTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCopyrightIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_COPYRIGHT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCopyrightEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_COPYRIGHT, v);
        return result;
    }

    @Deprecated
    public E findByCopyright(String v) {
        return forCopyrightEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCopyright(String v) {
        return forCopyrightEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_AUTHORS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_AUTHORS, v);
        return result;
    }

    @Deprecated
    public E findByAuthors(String v) {
        return forAuthorsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAuthors(String v) {
        return forAuthorsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLicenseIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_LICENSE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLicenseEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_LICENSE, v);
        return result;
    }

    @Deprecated
    public E findByLicense(String v) {
        return forLicenseEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLicense(String v) {
        return forLicenseEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLanguageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_LANGUAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLanguageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_LANGUAGE, v);
        return result;
    }

    @Deprecated
    public E findByLanguage(String v) {
        return forLanguageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLanguage(String v) {
        return forLanguageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(String v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(String v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPublicationDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_PUBLICATION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPublicationDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_PUBLICATION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByPublicationDate(Date v) {
        return forPublicationDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPublicationDate(Date v) {
        return forPublicationDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSummaryIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_SUMMARY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSummaryEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_SUMMARY, v);
        return result;
    }

    @Deprecated
    public E findBySummary(String v) {
        return forSummaryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySummary(String v) {
        return forSummaryEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWithFileIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_WITH_FILE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWithFileEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_WITH_FILE, v);
        return result;
    }

    @Deprecated
    public E findByWithFile(boolean v) {
        return forWithFileEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWithFile(boolean v) {
        return forWithFileEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalUrlIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_EXTERNAL_URL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalUrlEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_EXTERNAL_URL, v);
        return result;
    }

    @Deprecated
    public E findByExternalUrl(String v) {
        return forExternalUrlEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExternalUrl(String v) {
        return forExternalUrlEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilePathIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_FILE_PATH, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilePathEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_FILE_PATH, v);
        return result;
    }

    @Deprecated
    public E findByFilePath(String v) {
        return forFilePathEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFilePath(String v) {
        return forFilePathEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFileNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_FILE_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFileNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_FILE_NAME, v);
        return result;
    }

    @Deprecated
    public E findByFileName(String v) {
        return forFileNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFileName(String v) {
        return forFileNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyIn(Collection<Privacy> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_PRIVACY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyEquals(Privacy v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_PRIVACY, v);
        return result;
    }

    @Deprecated
    public E findByPrivacy(Privacy v) {
        return forPrivacyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPrivacy(Privacy v) {
        return forPrivacyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerIn(Collection<CoselmarUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_OWNER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerEquals(CoselmarUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_OWNER, v);
        return result;
    }

    @Deprecated
    public E findByOwner(CoselmarUser v) {
        return forOwnerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOwner(CoselmarUser v) {
        return forOwnerEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRestrictedListContains(CoselmarUserGroup v) {
        return forContains(Document.PROPERTY_RESTRICTED_LIST, v);
    }

    @Deprecated
    public E findContainsRestrictedList(CoselmarUserGroup v) {
        return forRestrictedListContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsRestrictedList(CoselmarUserGroup v) {
        return forRestrictedListContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forClosingDocumentsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forRelatedDocumentsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Question.class, entity);
        if (!list.isEmpty()) {
            result.put(Question.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedDocumentTopiaDao<E extends Document>
