package fr.ifremer.coselmar.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.User;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityEnumTransformer", date = "Mon Nov 17 13:28:35 UTC 2014")

public enum CoselmarEntityEnum implements TopiaEntityEnum {
    Document(Document.class, null, "document", ArrayUtils.EMPTY_STRING_ARRAY),
    User(User.class, null, "user", ArrayUtils.EMPTY_STRING_ARRAY);

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The optional name of database schema of the entity (if none was filled, will be {@code null}).
     */
    protected String dbSchemaName;

    /**
     * The name of the database table for the entity.
     */
    protected String dbTableName;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    CoselmarEntityEnum(Class<? extends TopiaEntity> contract, String dbSchemaName, String dbTableName, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String dbSchemaName() {
        return dbSchemaName;
    }

    @Override
    public String dbTableName() {
        return dbTableName;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        CoselmarEntityEnum constant = valueOf(klass);
        boolean result = constant.getContract() == contract;
        return result;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
            try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static CoselmarEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static CoselmarEntityEnum valueOf(final Class<?> klass) {
        if (klass.isInterface()) {
            return valueOf(klass.getSimpleName());
        }

        Class<?> contractClass = TopiaEntityHelper.getContractClass(CoselmarEntityEnum.values(), (Class) klass);

        if (contractClass != null) {

            return valueOf(contractClass.getSimpleName());
        }

        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(CoselmarEntityEnum.values()));
    }

    public static CoselmarEntityEnum[] getContracts() {
        CoselmarEntityEnum[] result = values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        CoselmarEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        CoselmarEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        CoselmarEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        CoselmarEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

} //CoselmarEntityEnum
