/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FileServiceImpl.java 1452 2010-09-20 13:38:19Z chatellier $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-services/src/main/java/com/jurismarches/vradi/services/FileServiceImpl.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

import com.jurismarches.vradi.VradiServiceConfiguration;

/**
 * File service impl.
 * 
 * @author chatellier
 * @version $Revision: 1452 $
 * 
 * Last update : $Date: 2010-09-20 15:38:19 +0200 (lun., 20 sept. 2010) $
 * By : $Author: chatellier $
 */
public class FileServiceImpl implements FileService {

    @Override
    public String uploadTemplate(File file, String extensionName) throws VradiException {
        
        String fileuri = null;

        try {
            File templatesDir = VradiServiceConfiguration.getInstance().getTemplatesDir();
            File templateDir = new File(templatesDir, extensionName);
            templateDir.mkdirs();

            File copyOfTemplate = new File(templateDir, file.getName());
            FileUtils.copyFile(file, copyOfTemplate);
            fileuri = copyOfTemplate.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadTemplate(String extensionName, String templateName) {
        File templateFile = null;
        if (templateName != null){
            File templatesDir = VradiServiceConfiguration.getInstance().getTemplatesDir();
            File templateDir = new File(templatesDir, extensionName);
            templateFile = new File(templateDir, templateName);
        }
        return templateFile;
    }

    @Override
    public String uploadWebHarvestScript(File file) throws VradiException {

        String fileuri = null;

        try {
            File scriptsDir = VradiServiceConfiguration.getInstance().getWebHarvestScriptDir();
            File scriptFile = new File(scriptsDir, file.getName());
            FileUtils.copyFile(file, scriptFile);
            fileuri = scriptFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadWebHarvestScript(String uri) {
        File scriptsDir = VradiServiceConfiguration.getInstance().getWebHarvestScriptDir();
        File scriptFile = new File(scriptsDir, uri);
        return scriptFile;
    }

    @Override
    public File downloadPDF(String uri) {
        File pdfDir = VradiServiceConfiguration.getInstance().getPdfDir();
        File pdfFile = new File(pdfDir, uri);
        return pdfFile;
    }

    @Override
    public String uploadFormAttachment(File file, String formId) throws VradiException {
        
        String fileuri = null;

        try {
            File attachementsDir = VradiServiceConfiguration.getInstance().getAttachmentsDir();
            File attachementDir = new File(attachementsDir, formId);
            attachementDir.mkdirs();

            File copyOfFormAttachement = new File(attachementDir, file.getName());
            FileUtils.copyFile(file, copyOfFormAttachement);
            fileuri = copyOfFormAttachement.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public String uploadTempFile(File file) throws VradiException {

        String fileURI;

        try {
            File tempDir = VradiServiceConfiguration.getInstance().getTempDir();
            tempDir.mkdirs();

            File copyOfTempFile = new File(tempDir, file.getName());
            FileUtils.copyFile(file, copyOfTempFile);
            fileURI = "file://" + copyOfTempFile.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileURI;
    }

    @Override
    public File downloadFormAttachment(String uri) {
        File attachmentDir = VradiServiceConfiguration.getInstance().getAttachmentsDir();
        File attachmentFile = new File(attachmentDir, uri);
        return attachmentFile;
    }

    @Override
    public String uploadFormEmbeddedFile(File file, String formId) throws VradiException {
        
        String fileuri = null;

        try {
            File embeddedsDir = VradiServiceConfiguration.getInstance().getEmbeddedFilesDir();
            File embeddedDir = new File(embeddedsDir, formId);
            embeddedDir.mkdirs();

            File copyOfEmbeddedFile = new File(embeddedDir, file.getName());
            FileUtils.copyFile(file, copyOfEmbeddedFile);
            fileuri = copyOfEmbeddedFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadFormEmbeddedFile(String uri) {
        File parentDir = VradiServiceConfiguration.getInstance().getEmbeddedFilesDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public File downloadRequestHistory(String uri) throws VradiException {
        File parentDir = VradiServiceConfiguration.getInstance().getQueryHistoryDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public String getRequestHistoryURL(String uri) throws VradiException {
        File parentDir = VradiServiceConfiguration.getInstance().getQueryHistoryDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile.toURI().toString();
    }
}
