/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyAuthorisationHelper;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyGroupHelper;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyMetaExtensionUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTokenHelper;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyUserHelper;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Search;

public class WikittyServiceSecurity
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceSecurity.class);
    protected WikittyService ws;
    protected transient String appAdminGroupId = null;

    public WikittyServiceSecurity(WikittyService ws) {
        this.ws = ws;
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        Wikitty user = this.ws.findByCriteria(null, Search.query().eq("WikittyUser.login", login).criteria());
        if (user == null) {
            throw new IllegalArgumentException(String.format("no such account '%s'", login));
        }
        if (WikittyUserHelper.getPassword(user).equals(password)) {
            String tokenId = WikittyUtil.genSecurityTokenId();
            WikittyImpl wikittyToken = new WikittyImpl(tokenId);
            WikittyTokenHelper.addExtension(wikittyToken);
            WikittyTokenHelper.setUser(wikittyToken, user.getId());
            this.ws.store(null, wikittyToken);
            log.debug((Object)String.format("token '%s' is for login '%s'", tokenId, login));
            return tokenId;
        }
        throw new SecurityException("bad password");
    }

    @Override
    public void logout(String securityToken) {
        if (securityToken == null) {
            throw new IllegalArgumentException("security token is null");
        }
        this.getUserId(securityToken);
        this.ws.delete(securityToken, securityToken);
    }

    @Override
    public void clear(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            throw new SecurityException(I18n._((String)"user %s can't clear data", (Object[])new Object[]{userId}));
        }
        this.ws.clear(securityToken);
    }

    protected boolean userIsAnonymousOrAppAdmin(String securityToken, String userId) {
        boolean userIsAnonymousOrAppAdmin = false;
        if (this.getAppAdminGroup(securityToken) == null) {
            if (securityToken == null) {
                userIsAnonymousOrAppAdmin = true;
            }
        } else if (this.isAppAdmin(securityToken, userId)) {
            userIsAnonymousOrAppAdmin = true;
        }
        return userIsAnonymousOrAppAdmin;
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        Collection<Wikitty> wikitties = Arrays.asList(wikitty);
        wikitties = this.checkStore(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikitties);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        Collection<Wikitty> wikittiesToStore = this.checkStore(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikittiesToStore);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        Collection<Wikitty> wikittiesToStore = this.checkStore(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikittiesToStore, force);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        Collection<Wikitty> wikittiesToStore = this.checkStore(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, transaction, wikittiesToStore, force);
        return result;
    }

    protected Collection<Wikitty> checkStore(String securityToken, Collection<Wikitty> wikitties) {
        String userId = this.getUserId(securityToken);
        ArrayList<Wikitty> wikittiesToStore = new ArrayList<Wikitty>();
        for (Wikitty wikitty : wikitties) {
            Wikitty oldVersion = this.ws.restore(securityToken, wikitty.getId());
            ArrayList<String> newExtensions = new ArrayList<String>(wikitty.getExtensionNames());
            if (oldVersion != null) {
                newExtensions.removeAll(oldVersion.getExtensionNames());
            }
            for (String extensionName : newExtensions) {
                Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extensionName);
                boolean canCreate = extensionRights == null || this.canRead(securityToken, userId, null, extensionRights);
                if (canCreate) continue;
                throw new SecurityException(I18n._((String)"user %s can't create instance of extension %s", (Object[])new Object[]{userId, extensionRights}));
            }
            if (oldVersion != null) {
                for (String fqFieldDirtyName : wikitty.getDirty()) {
                    boolean fieldRequireAdminRights;
                    boolean canChange;
                    String concernedExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldDirtyName);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("will update field %s from extension %s", fqFieldDirtyName, concernedExtensionName));
                    }
                    if (canChange = (fieldRequireAdminRights = "WikittyAuthorisation".equals(concernedExtensionName) || "WikittyAuthorisation".equals(WikittyUtil.getMetaExtensionNameFromFQMetaExtensionName(concernedExtensionName))) ? this.canAdmin(securityToken, userId, concernedExtensionName, wikitty) : this.canWrite(securityToken, userId, concernedExtensionName, wikitty)) {
                        Object newValue = wikitty.getFqField(fqFieldDirtyName);
                        oldVersion.setFqField(fqFieldDirtyName, newValue);
                        continue;
                    }
                    throw new SecurityException(I18n._((String)"user %s can't write field %s on wikitty %s", (Object[])new Object[]{userId, fqFieldDirtyName, wikitty}));
                }
            }
            wikittiesToStore.add(wikitty);
        }
        return wikittiesToStore;
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        String userId = this.getUserId(securityToken);
        Wikitty wikitty = this.ws.restore(securityToken, id);
        if (wikitty != null) {
            this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        }
        return wikitty;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        String userId = this.getUserId(securityToken);
        List<Wikitty> wikitties = this.ws.restore(securityToken, ids);
        for (Wikitty wikitty : wikitties) {
            this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        }
        return wikitties;
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        String userId = this.getUserId(securityToken);
        List<Wikitty> wikitties = this.ws.restore(securityToken, transaction, ids);
        for (Wikitty wikitty : wikitties) {
            this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        }
        return wikitties;
    }

    protected void refuseUnauthorizedRead(String securityToken, String userId, Wikitty wikitty) {
        if (wikitty != null) {
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canRead(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(I18n._((String)"user %s can't read extension %s on wikitty %s, it may be due to a global policy on the wikitty", (Object[])new Object[]{userId, extensionName, wikitty}));
            }
        }
    }

    protected boolean canRead(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canRead = false;
        canRead = wikitty.hasMetaExtension("WikittyAuthorisation", extensionName) ? this.isReader(securityToken, userId, wikitty, extensionName) || this.canWrite(securityToken, userId, extensionName, wikitty) : (!canRead && wikitty.hasExtension("WikittyAuthorisation") ? this.isReader(securityToken, userId, wikitty, null) || this.canWrite(securityToken, userId, extensionName, wikitty) : true);
        return canRead;
    }

    protected boolean canWrite(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canWrite = false;
        canWrite = wikitty.hasMetaExtension("WikittyAuthorisation", extensionName) ? this.isWriter(securityToken, userId, wikitty, extensionName) || this.canAdmin(securityToken, userId, extensionName, wikitty) : (!canWrite && wikitty.hasExtension("WikittyAuthorisation") ? this.isWriter(securityToken, userId, wikitty, null) || this.canAdmin(securityToken, userId, extensionName, wikitty) : true);
        return canWrite;
    }

    protected boolean canAdmin(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canAdmin = false;
        if (wikitty.hasMetaExtension("WikittyAuthorisation", extensionName)) {
            canAdmin = this.isAdmin(securityToken, userId, wikitty, extensionName) || this.isOwner(securityToken, userId, wikitty, extensionName);
        } else if (!canAdmin && wikitty.hasExtension("WikittyAuthorisation")) {
            canAdmin = this.isAdmin(securityToken, userId, wikitty, null) || this.isOwner(securityToken, userId, wikitty, null);
        } else if (!canAdmin) {
            canAdmin = this.userIsAnonymousOrAppAdmin(securityToken, userId);
        }
        return canAdmin;
    }

    @Override
    public void delete(String securityToken, String id) {
        List<String> ids = Arrays.asList(id);
        this.delete(securityToken, ids);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        String userId = this.getUserId(securityToken);
        ArrayList<String> idsAsList = new ArrayList<String>(ids);
        List<Wikitty> wikitties = this.ws.restore(securityToken, idsAsList);
        for (Wikitty wikitty : wikitties) {
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canWrite(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(I18n._((String)"user %s doesn't have rights on extension %s on wikitty %s", (Object[])new Object[]{userId, extensionName, wikitty}));
            }
        }
        this.ws.delete(securityToken, ids);
    }

    @Override
    @Deprecated
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean canDelete(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean canRead(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        List<WikittyExtension> exts = Arrays.asList(ext);
        this.checkStoreExtension(securityToken, exts);
        return this.storeExtension(securityToken, exts);
    }

    protected void checkStoreExtension(String securityToken, Collection<WikittyExtension> exts) {
        String userId = this.getUserId(securityToken);
        if (!this.userIsAnonymousOrAppAdmin(securityToken, userId)) {
            for (WikittyExtension extension : exts) {
                boolean canWrite;
                Wikitty extensionAuthorisation = this.restoreExtensionAuthorisation(securityToken, extension.getName());
                if (extensionAuthorisation == null || (canWrite = this.canWrite(securityToken, userId, null, extensionAuthorisation))) continue;
                throw new SecurityException(I18n._((String)"user %s don't have write right for extension %s", (Object[])new Object[]{userId, extension}));
            }
        }
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        this.checkStoreExtension(securityToken, exts);
        return this.ws.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        this.checkStoreExtension(securityToken, exts);
        return this.ws.storeExtension(securityToken, transaction, exts);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, criteria);
        return result;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, transaction, criteria);
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        String userId = this.getUserId(securityToken);
        Wikitty wikitty = this.ws.findByCriteria(securityToken, criteria);
        this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        return wikitty;
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        String userId = this.getUserId(securityToken);
        WikittyTree restoredTree = this.ws.restoreTree(securityToken, wikittyId);
        this.checkRestoreTree(securityToken, userId, restoredTree);
        return restoredTree;
    }

    protected void checkRestoreTree(String securityToken, String userId, WikittyTree tree) {
        this.checkRestoreTreeNode(securityToken, userId, tree.node);
        for (WikittyTree subTree : tree.getChildren()) {
            this.checkRestoreTree(securityToken, userId, subTree);
        }
    }

    protected void checkRestoreTreeNode(String securityToken, String userId, WikittyTreeNode treeNode) {
        this.refuseUnauthorizedRead(securityToken, userId, treeNode.getWikitty());
    }

    @Override
    public Map.Entry<WikittyTreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        String userId = this.getUserId(securityToken);
        Map.Entry<WikittyTreeNode, Integer> entry = this.ws.restoreNode(securityToken, wikittyId, filter);
        this.checkRestoreTreeNode(securityToken, userId, entry.getKey());
        return entry;
    }

    @Override
    public Map<WikittyTreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        String userId = this.getUserId(securityToken);
        Map<WikittyTreeNode, Integer> children = this.ws.restoreChildren(securityToken, wikittyId, filter);
        for (Map.Entry<WikittyTreeNode, Integer> child : children.entrySet()) {
            this.checkRestoreTreeNode(securityToken, userId, child.getKey());
        }
        return children;
    }

    @Override
    public List<String> deleteTree(String securityToken, String treeNodeId) {
        WikittyTreeNode treeNode = this.ws.restoreNode(securityToken, treeNodeId, null).getKey();
        List<Wikitty> wikitties = Arrays.asList(treeNode.getWikitty());
        this.checkStore(securityToken, wikitties);
        return this.ws.deleteTree(securityToken, treeNodeId);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty wikitty = this.ws.restoreVersion(securityToken, wikittyId, version);
        String userId = this.getUserId(securityToken);
        this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        return wikitty;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        Wikitty wikitty = this.ws.findByCriteria(securityToken, transaction, criteria);
        String userId = this.getUserId(securityToken);
        this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        return wikitty;
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            return this.ws.syncEngin(securityToken);
        }
        throw new SecurityException(I18n._((String)"user %s can't sync search engine", (Object[])new Object[]{this.getUserId(securityToken)}));
    }

    protected String getUserId(String securityToken) {
        String result = null;
        if (securityToken != null) {
            Wikitty securityTokenWikitty = this.ws.restore(securityToken, securityToken);
            if (securityTokenWikitty == null) {
                throw new SecurityException("bad (obsolete ?) token");
            }
            result = WikittyTokenHelper.getUser(securityTokenWikitty);
        }
        return result;
    }

    protected boolean isReader(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "reader");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName, true);
        return result;
    }

    protected boolean isWriter(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "writer");
        log.trace((Object)("meta field name " + metaFieldName));
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isAdmin(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "admin");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isOwner(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String fieldName;
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "owner");
        String actualExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(metaFieldName);
        String owner = wikitty.getFieldAsString(actualExtensionName, fieldName = WikittyUtil.getFieldNameFromFQFieldName(metaFieldName));
        boolean isOwner = owner == null ? false : owner.equals(userId);
        return isOwner;
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName) {
        return this.isMember(securityToken, userId, extensionRights, fqFieldName, false);
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName, boolean considerEmptyGroupAsMembership) {
        String parentId;
        String fieldName;
        String extensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldName);
        Set<String> groupOrUser = extensionRights.getFieldAsSet(extensionName, fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqFieldName), String.class);
        boolean isMember = groupOrUser == null || groupOrUser.isEmpty() ? considerEmptyGroupAsMembership : this.isMember(securityToken, userId, groupOrUser);
        if (!isMember && (parentId = WikittyAuthorisationHelper.getParent(extensionRights)) != null) {
            Wikitty parent = this.ws.restore(securityToken, parentId);
            isMember = this.isMember(securityToken, userId, parent, fqFieldName);
        }
        return isMember;
    }

    protected boolean isAppAdmin(String securityToken, String userId) {
        Wikitty group = this.getAppAdminGroup(securityToken);
        Set<String> ids = WikittyGroupHelper.getMembers(group);
        boolean result = this.isMember(securityToken, userId, ids);
        return result;
    }

    protected Wikitty getAppAdminGroup(String securityToken) {
        Wikitty group = this.appAdminGroupId == null ? this.ws.findByCriteria(securityToken, Search.query().eq("WikittyGroup.name", "WikittyAppAdmin").criteria()) : this.ws.restore(securityToken, this.appAdminGroupId);
        return group;
    }

    protected boolean isMember(String securityToken, String userId, Set<String> groupOrUser) {
        if (groupOrUser != null) {
            for (String id : groupOrUser) {
                if (id.equals(userId)) {
                    return true;
                }
                Wikitty groupWikitty = this.ws.restore(securityToken, id);
                if (!WikittyGroupHelper.hasExtension(groupWikitty)) continue;
                Set<String> members = WikittyGroupHelper.getMembers(groupWikitty);
                return this.isMember(securityToken, userId, members);
            }
        }
        return false;
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, WikittyExtension extension) {
        return this.restoreExtensionAuthorisation(securityToken, extension.getName());
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, String extensionName) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extensionName);
        Wikitty wikittyAuthorisation = this.ws.restore(securityToken, wikittyAuthorisationId);
        if (wikittyAuthorisation == null) {
            log.debug((Object)(extensionName + " has no authorization attached"));
        }
        return wikittyAuthorisation;
    }
}

