/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class DocumentSender
implements SaxonLocator {
    private NodeInfo top;

    public DocumentSender(NodeInfo nodeInfo) {
        this.top = nodeInfo;
        int n = nodeInfo.getNodeKind();
        if (n != 9 && n != 1) {
            throw new IllegalArgumentException("DocumentSender can only handle document or element nodes");
        }
    }

    public void send(Receiver receiver) throws XPathException {
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        if (this.top.getNamePool() != pipelineConfiguration.getConfiguration().getNamePool() && !(receiver instanceof NamePoolConverter)) {
            throw new IllegalArgumentException("DocumentSender source and target must use the same NamePool");
        }
        if (pipelineConfiguration.getLocationProvider() == null) {
            receiver.setSystemId(this.top.getSystemId());
            pipelineConfiguration.setLocationProvider(this);
        }
        receiver.open();
        receiver.startDocument(0);
        this.top.copy(receiver, 2, true, 0);
        receiver.endDocument();
        receiver.close();
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.top.getSystemId();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

