package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Tue Sep 08 16:00:54 CEST 2015")
public abstract class GeneratedClientTopiaDao<E extends Client> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Client.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Client;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EmailTopiaDao dao = topiaDaoSupplier
                    .getDao(Email.class, EmailTopiaDao.class);
            List<Email> list = dao
                    .forProperties(Email.PROPERTY_CLIENT, entity)
                    .findAll();
            for (Email item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getClient())) {
                    item.setClient(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM email main, email_matchingclients secondary " +
                    " WHERE main.topiaid=secondary.email " +
                    " AND secondary.matchingClients='" + entity.getTopiaId() + "'";
            List<Email> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.Email.getImplementation())
                    .list();

            for (Email item : list) {
                item.removeMatchingClients(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String code, String company) {
        return forNaturalId(code, company).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String code, String company) {
        return forNaturalId(code, company).exists();
    }

    public E createByNaturalId(String code, String company) {
        return create(Client.PROPERTY_CODE, code, Client.PROPERTY_COMPANY, company);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String code, String company) {
        return forProperties(Client.PROPERTY_CODE, code, Client.PROPERTY_COMPANY, company);
    }

    public E createByNotNull(String code, String company) {
        return create(Client.PROPERTY_CODE, code, Client.PROPERTY_COMPANY, company);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailAddressesJsonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_EMAIL_ADDRESSES_JSON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailAddressesJsonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_EMAIL_ADDRESSES_JSON, v);
        return result;
    }

    @Deprecated
    public E findByEmailAddressesJson(String v) {
        return forEmailAddressesJsonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmailAddressesJson(String v) {
        return forEmailAddressesJsonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxNumbersJsonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_FAX_NUMBERS_JSON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxNumbersJsonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_FAX_NUMBERS_JSON, v);
        return result;
    }

    @Deprecated
    public E findByFaxNumbersJson(String v) {
        return forFaxNumbersJsonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFaxNumbersJson(String v) {
        return forFaxNumbersJsonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic1In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_CARACTERISTIC1, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic1Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_CARACTERISTIC1, v);
        return result;
    }

    @Deprecated
    public E findByCaracteristic1(String v) {
        return forCaracteristic1Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCaracteristic1(String v) {
        return forCaracteristic1Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic2In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_CARACTERISTIC2, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic2Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_CARACTERISTIC2, v);
        return result;
    }

    @Deprecated
    public E findByCaracteristic2(String v) {
        return forCaracteristic2Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCaracteristic2(String v) {
        return forCaracteristic2Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic3In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_CARACTERISTIC3, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCaracteristic3Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_CARACTERISTIC3, v);
        return result;
    }

    @Deprecated
    public E findByCaracteristic3(String v) {
        return forCaracteristic3Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCaracteristic3(String v) {
        return forCaracteristic3Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBrandIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_BRAND, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBrandEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_BRAND, v);
        return result;
    }

    @Deprecated
    public E findByBrand(String v) {
        return forBrandEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBrand(String v) {
        return forBrandEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_COMPANY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_COMPANY, v);
        return result;
    }

    @Deprecated
    public E findByCompany(String v) {
        return forCompanyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCompany(String v) {
        return forCompanyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPersonInChargeIn(Collection<FaxToMailUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Client.PROPERTY_PERSON_IN_CHARGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPersonInChargeEquals(FaxToMailUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Client.PROPERTY_PERSON_IN_CHARGE, v);
        return result;
    }

    @Deprecated
    public E findByPersonInCharge(FaxToMailUser v) {
        return forPersonInChargeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPersonInCharge(FaxToMailUser v) {
        return forPersonInChargeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forClientEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forMatchingClientsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedClientTopiaDao<E extends Client>
