package com.franciaflex.faxtomail;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id: FaxToMailConfigurationProvider.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-persistence/src/main/java/com/franciaflex/faxtomail/FaxToMailConfigurationProvider.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;

import java.util.Locale;

import static org.nuiton.i18n.I18n.l;

/**
 * Tutti config provider (for site generation).
 * Created on 11/24/13.
 *
 * @author Kevin Morin - morin@codelutin.com
 */
public class FaxToMailConfigurationProvider implements ApplicationConfigProvider {

    @Override
    public String getName() {
        return "faxToMail";
    }

    @Override
    public String getDescription(Locale locale) {
        return l(locale, "faxToMail.config");
    }

    @Override
    public ConfigOptionDef[] getOptions() {
        return FaxToMailConfigurationOption.values();
    }

    @Override
    public ConfigActionDef[] getActions() {
        return new ConfigActionDef[0];
    }
}
