/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.util.propertyEditor.FilePropertyEditor;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public class MultiDirectoryPropertyEditor
extends FilePropertyEditor {
    protected char pathSeparator;
    static I18n i18n = Environment.getI18n();

    public MultiDirectoryPropertyEditor() {
        this.setPathSeparator(';');
    }

    public String getButtonTitle() {
        return i18n.get(MultiDirectoryPropertyEditor.class, "Add", "Add");
    }

    public boolean isTextFieldEditable() {
        return true;
    }

    public int getFileSelectionMode() {
        return 1;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public void setPathSeparator(char c) {
        this.pathSeparator = c;
    }

    public char getPathSeparator() {
        return this.pathSeparator;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.getFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            File[] choices;
            for (File element : choices = chooser.getSelectedFiles()) {
                String newFilename = element.getAbsolutePath();
                newFilename = this.cleanUpName(newFilename);
                this.append(newFilename);
            }
            this.firePropertyChange();
        }
    }

    public void append(String addPath) {
        String currentPath = this.textField.getText();
        if (currentPath.length() == 0) {
            this.setValue(addPath);
        } else {
            this.setValue(currentPath.concat(";" + addPath));
        }
    }
}

