/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.util.Debug;

public class OMAction
implements OMGraphicConstants {
    protected int value;

    public OMAction() {
        this.value = 0;
    }

    public OMAction(int value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int setMask(int mask) {
        this.value = OMAction.setMask(this.value, mask);
        return this.value;
    }

    public int unsetMask(int mask) {
        this.value = OMAction.unsetMask(this.value, mask);
        return this.value;
    }

    public boolean isMask(int mask) {
        return OMAction.isMask(this.value, mask);
    }

    public static int setMask(int value, int mask) {
        return value | mask;
    }

    public static int unsetMask(int value, int mask) {
        return value & ~mask;
    }

    public static boolean isMask(int value, int mask) {
        return (value & mask) >= mask;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OMAction (").append(this.value).append(") [ ");
        if (this.value == 0) {
            sb.append("add ");
        } else {
            if (this.isMask(1)) {
                sb.append("raise_to_top ");
            }
            if (this.isMask(2)) {
                sb.append("lower_to_bottom ");
            }
            if (this.isMask(4)) {
                sb.append("delete ");
            }
            if (this.isMask(8)) {
                sb.append("select ");
            }
            if (this.isMask(16)) {
                sb.append("deselect ");
            }
            if (this.isMask(32)) {
                sb.append("deselect_all ");
            }
            if (this.isMask(64)) {
                sb.append("add ");
            }
            if (this.isMask(128)) {
                sb.append("update ");
            }
            if (this.isMask(256)) {
                sb.append("raise ");
            }
            if (this.isMask(512)) {
                sb.append("lower ");
            }
            if (this.isMask(1024)) {
                sb.append("sort ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static final void main(String[] argv) {
        OMAction action = new OMAction();
        Debug.init();
        Debug.output("Setting add mask...");
        action.setMask(64);
        if (action.isMask(64)) {
            Debug.output("ADD mask set.");
        } else {
            Debug.output("ADD mask *NOT* set");
        }
    }
}

