/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.Command;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.DataInputStream;
import java.io.IOException;

public class EllipseElement
extends Command {
    int centerX = this.makeInt(0);
    int centerY = this.makeInt(1);
    int endX1 = this.makeInt(2);
    int endY1 = this.makeInt(3);
    int endX2 = this.makeInt(4);
    int endY2 = this.makeInt(5);
    int centerXS;
    int centerYS;
    int endXS1;
    int endYS1;
    int endXS2;
    int endYS2;

    public EllipseElement(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
    }

    public String toString() {
        return "Ellipse [" + this.centerX + "," + this.centerY + "] [" + this.endX1 + "," + this.endY1 + "] [" + this.endX2 + "," + this.endY2 + "]";
    }

    public void scale(CGMDisplay d) {
        this.centerXS = d.x(this.centerX);
        this.centerYS = d.y(this.centerY);
        this.endXS1 = d.x(this.endX1);
        this.endYS1 = d.y(this.endY1);
        this.endXS2 = d.x(this.endX2);
        this.endYS2 = d.y(this.endY2);
    }

    public void paint(CGMDisplay d) {
        int x1 = this.endXS1 - this.centerXS;
        int x2 = this.endYS1 - this.centerYS;
        int y1 = this.endXS2 - this.centerXS;
        int y2 = this.endYS2 - this.centerYS;
        double radiusX = Math.sqrt(x1 * x1 + x2 * x2);
        double radiusY = Math.sqrt(y1 * y1 + y2 * y2);
        double angle = x1 != 0 ? Math.toDegrees(Math.tan(x2 / x1)) : 1.5707963267948966;
        AffineTransform at = AffineTransform.getRotateInstance(angle, this.centerXS, this.centerYS);
        Graphics2D g2 = (Graphics2D)d.graphics().create();
        g2.setTransform(at);
        if (d.getFilled()) {
            g2.setColor(d.getFillColor());
            g2.fillOval((int)((double)this.centerXS - radiusX), (int)((double)this.centerYS - radiusY), (int)(2.0 * radiusX), (int)(2.0 * radiusY));
        } else {
            g2.setColor(d.getFillColor());
            if (!d.getEdge()) {
                d.graphics().drawOval((int)((double)this.centerXS - radiusX), (int)((double)this.centerYS - radiusY), (int)(2.0 * radiusX), (int)(2.0 * radiusY));
            }
        }
        if (d.getEdge()) {
            g2.setColor(d.getEdgeColor());
            g2.drawOval((int)((double)this.centerXS - radiusX), (int)((double)this.centerYS - radiusY), (int)(2.0 * radiusX), (int)(2.0 * radiusY));
        }
    }
}

