/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbInstanceReadReplicaRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbInstanceReadReplicaRequest.Builder, CreateDbInstanceReadReplicaRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(CreateDbInstanceReadReplicaRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceDBInstanceIdentifier")
            .getter(getter(CreateDbInstanceReadReplicaRequest::sourceDBInstanceIdentifier))
            .setter(setter(Builder::sourceDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(CreateDbInstanceReadReplicaRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateDbInstanceReadReplicaRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateDbInstanceReadReplicaRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(CreateDbInstanceReadReplicaRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateDbInstanceReadReplicaRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(CreateDbInstanceReadReplicaRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(CreateDbInstanceReadReplicaRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(CreateDbInstanceReadReplicaRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateDbInstanceReadReplicaRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbInstanceReadReplicaRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(CreateDbInstanceReadReplicaRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbInstanceReadReplicaRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateDbInstanceReadReplicaRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(CreateDbInstanceReadReplicaRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(CreateDbInstanceReadReplicaRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(CreateDbInstanceReadReplicaRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateDbInstanceReadReplicaRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignedUrl").getter(getter(CreateDbInstanceReadReplicaRequest::preSignedUrl))
            .setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(CreateDbInstanceReadReplicaRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInsightsMode").getter(getter(CreateDbInstanceReadReplicaRequest::databaseInsightsModeAsString))
            .setter(setter(Builder::databaseInsightsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build())
            .build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(CreateDbInstanceReadReplicaRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(CreateDbInstanceReadReplicaRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(CreateDbInstanceReadReplicaRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(CreateDbInstanceReadReplicaRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<ProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(CreateDbInstanceReadReplicaRequest::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<ProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessorFeature").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaultProcessorFeatures")
            .getter(getter(CreateDbInstanceReadReplicaRequest::useDefaultProcessorFeatures))
            .setter(setter(Builder::useDefaultProcessorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateDbInstanceReadReplicaRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateDbInstanceReadReplicaRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(CreateDbInstanceReadReplicaRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<String> DOMAIN_FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainFqdn").getter(getter(CreateDbInstanceReadReplicaRequest::domainFqdn))
            .setter(setter(Builder::domainFqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainFqdn").build()).build();

    private static final SdkField<String> DOMAIN_OU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainOu").getter(getter(CreateDbInstanceReadReplicaRequest::domainOu))
            .setter(setter(Builder::domainOu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainOu").build()).build();

    private static final SdkField<String> DOMAIN_AUTH_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainAuthSecretArn").getter(getter(CreateDbInstanceReadReplicaRequest::domainAuthSecretArn))
            .setter(setter(Builder::domainAuthSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainAuthSecretArn").build())
            .build();

    private static final SdkField<List<String>> DOMAIN_DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainDnsIps")
            .getter(getter(CreateDbInstanceReadReplicaRequest::domainDnsIps))
            .setter(setter(Builder::domainDnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaMode").getter(getter(CreateDbInstanceReadReplicaRequest::replicaModeAsString))
            .setter(setter(Builder::replicaMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()).build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(CreateDbInstanceReadReplicaRequest::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final SdkField<String> CUSTOM_IAM_INSTANCE_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomIamInstanceProfile").getter(getter(CreateDbInstanceReadReplicaRequest::customIamInstanceProfile))
            .setter(setter(Builder::customIamInstanceProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIamInstanceProfile").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CreateDbInstanceReadReplicaRequest::networkType))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageThroughput").getter(getter(CreateDbInstanceReadReplicaRequest::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()).build();

    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCustomerOwnedIp").getter(getter(CreateDbInstanceReadReplicaRequest::enableCustomerOwnedIp))
            .setter(setter(Builder::enableCustomerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build())
            .build();

    private static final SdkField<String> BACKUP_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupTarget").getter(getter(CreateDbInstanceReadReplicaRequest::backupTarget))
            .setter(setter(Builder::backupTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupTarget").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(CreateDbInstanceReadReplicaRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier")
            .getter(getter(CreateDbInstanceReadReplicaRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedLogVolume").getter(getter(CreateDbInstanceReadReplicaRequest::dedicatedLogVolume))
            .setter(setter(Builder::dedicatedLogVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build())
            .build();

    private static final SdkField<Boolean> UPGRADE_STORAGE_CONFIG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpgradeStorageConfig").getter(getter(CreateDbInstanceReadReplicaRequest::upgradeStorageConfig))
            .setter(setter(Builder::upgradeStorageConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStorageConfig").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(CreateDbInstanceReadReplicaRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(CreateDbInstanceReadReplicaRequest::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, AVAILABILITY_ZONE_FIELD, PORT_FIELD, MULTI_AZ_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, STORAGE_TYPE_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD,
            PRE_SIGNED_URL_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, DATABASE_INSIGHTS_MODE_FIELD,
            ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD,
            USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD,
            DOMAIN_FQDN_FIELD, DOMAIN_OU_FIELD, DOMAIN_AUTH_SECRET_ARN_FIELD, DOMAIN_DNS_IPS_FIELD, REPLICA_MODE_FIELD,
            MAX_ALLOCATED_STORAGE_FIELD, CUSTOM_IAM_INSTANCE_PROFILE_FIELD, NETWORK_TYPE_FIELD, STORAGE_THROUGHPUT_FIELD,
            ENABLE_CUSTOMER_OWNED_IP_FIELD, BACKUP_TARGET_FIELD, ALLOCATED_STORAGE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD,
            DEDICATED_LOG_VOLUME_FIELD, UPGRADE_STORAGE_CONFIG_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, SOURCE_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbInstanceIdentifier;

    private final String sourceDBInstanceIdentifier;

    private final String dbInstanceClass;

    private final String availabilityZone;

    private final Integer port;

    private final Boolean multiAZ;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer iops;

    private final String optionGroupName;

    private final String dbParameterGroupName;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private final String dbSubnetGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final String storageType;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final String kmsKeyId;

    private final String preSignedUrl;

    private final Boolean enableIAMDatabaseAuthentication;

    private final String databaseInsightsMode;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final List<String> enableCloudwatchLogsExports;

    private final List<ProcessorFeature> processorFeatures;

    private final Boolean useDefaultProcessorFeatures;

    private final Boolean deletionProtection;

    private final String domain;

    private final String domainIAMRoleName;

    private final String domainFqdn;

    private final String domainOu;

    private final String domainAuthSecretArn;

    private final List<String> domainDnsIps;

    private final String replicaMode;

    private final Integer maxAllocatedStorage;

    private final String customIamInstanceProfile;

    private final String networkType;

    private final Integer storageThroughput;

    private final Boolean enableCustomerOwnedIp;

    private final String backupTarget;

    private final Integer allocatedStorage;

    private final String sourceDBClusterIdentifier;

    private final Boolean dedicatedLogVolume;

    private final Boolean upgradeStorageConfig;

    private final String caCertificateIdentifier;

    private final String sourceRegion;

    private CreateDbInstanceReadReplicaRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.sourceDBInstanceIdentifier = builder.sourceDBInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.availabilityZone = builder.availabilityZone;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.storageType = builder.storageType;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.domainFqdn = builder.domainFqdn;
        this.domainOu = builder.domainOu;
        this.domainAuthSecretArn = builder.domainAuthSecretArn;
        this.domainDnsIps = builder.domainDnsIps;
        this.replicaMode = builder.replicaMode;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.customIamInstanceProfile = builder.customIamInstanceProfile;
        this.networkType = builder.networkType;
        this.storageThroughput = builder.storageThroughput;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
        this.backupTarget = builder.backupTarget;
        this.allocatedStorage = builder.allocatedStorage;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.upgradeStorageConfig = builder.upgradeStorageConfig;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * <p>
     * The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance.
     * This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB
     *         instance. This parameter is stored as a lowercase string.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up
     * to 15 read replicas, except for the following engines:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Db2 - Can have up to three replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Oracle - Can have up to five read replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * SQL Server - Can have up to five read replicas.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if the <code>SourceDBClusterIdentifier</code> parameter is also specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the limitations of Oracle read replicas, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses"
     * >Version and licensing considerations for RDS for Oracle replicas</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the limitations of SQL Server read replicas, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations"
     * >Read replica limitations with SQL Server</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The specified DB instance must have automatic backups enabled, that is, its backup retention period must be
     * greater than 0.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB
     * instance identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB
     * instance ARN. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
     * >Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or
     * RDS Custom, which don't support cross-Region replicas.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the DB instance that will act as the source for the read replica. Each DB instance can
     *         have up to 15 read replicas, except for the following engines:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Db2 - Can have up to three replicas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Oracle - Can have up to five read replicas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SQL Server - Can have up to five read replicas.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if the <code>SourceDBClusterIdentifier</code> parameter is also specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the limitations of Oracle read replicas, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses"
     *         >Version and licensing considerations for RDS for Oracle replicas</a> in the <i>Amazon RDS User
     *         Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the limitations of SQL Server read replicas, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations"
     *         >Read replica limitations with SQL Server</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The specified DB instance must have automatic backups enabled, that is, its backup retention period must
     *         be greater than 0.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid
     *         DB instance identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a
     *         valid DB instance ARN. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
     *         >Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL
     *         Server or RDS Custom, which don't support cross-Region replicas.
     *         </p>
     *         </li>
     */
    public final String sourceDBInstanceIdentifier() {
        return sourceDBInstanceIdentifier;
    }

    /**
     * <p>
     * The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are
     * available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance
     * classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a>
     * in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Default: Inherits the value from the source DB instance.
     * </p>
     * 
     * @return The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes
     *         are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB
     *         instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         Default: Inherits the value from the source DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The Availability Zone (AZ) where the read replica will be created.
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     * </p>
     * <p>
     * Example: <code>us-east-1d</code>
     * </p>
     * 
     * @return The Availability Zone (AZ) where the read replica will be created.</p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Example: <code>us-east-1d</code>
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The port number that the DB instance uses for connections.
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * <p>
     * Default: Inherits the value from the source DB instance.
     * </p>
     * 
     * @return The port number that the DB instance uses for connections.</p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: Inherits the value from the source DB instance.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies whether the read replica is in a Multi-AZ deployment.
     * </p>
     * <p>
     * You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another
     * Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is
     * independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return Specifies whether the read replica is in a Multi-AZ deployment.</p>
     *         <p>
     *         You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another
     *         Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB
     *         instance is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance window.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Default: Inherits the value from the source DB instance.
     * </p>
     * <p>
     * For more information about automatic minor version upgrades, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     * >Automatically upgrading the minor engine version</a>.
     * </p>
     * 
     * @return Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance
     *         window.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Default: Inherits the value from the source DB instance.
     *         </p>
     *         <p>
     *         For more information about automatic minor version upgrades, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     *         >Automatically upgrading the minor engine version</a>.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
     *         instance.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The option group to associate the DB instance with. If not specified, RDS uses the option group associated with
     * the source DB instance or cluster.
     * </p>
     * <note>
     * <p>
     * For SQL Server, you must use the option group associated with the source.
     * </p>
     * </note>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The option group to associate the DB instance with. If not specified, RDS uses the option group
     *         associated with the source DB instance or cluster.</p> <note>
     *         <p>
     *         For SQL Server, you must use the option group associated with the source.
     *         </p>
     *         </note>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The name of the DB parameter group to associate with this read replica DB instance.
     * </p>
     * <p>
     * For the Db2 DB engine, if your source DB instance uses the Bring Your Own License model, then a custom parameter
     * group must be associated with the replica. For a same Amazon Web Services Region replica, if you don't specify a
     * custom parameter group, Amazon RDS associates the custom parameter group associated with the source DB instance.
     * For a cross-Region replica, you must specify a custom parameter group. This custom parameter group must include
     * your IBM Site ID and IBM Customer ID. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html#db2-prereqs-ibm-info"> IBM IDs
     * for Bring Your Own License for Db2</a>.
     * </p>
     * <p>
     * For Single-AZ or Multi-AZ DB instance read replica instances, if you don't specify a value for
     * <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of the source DB
     * instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine
     * for a cross-Region read replica.
     * </p>
     * <p>
     * For Multi-AZ DB cluster same Region read replica instances, if you don't specify a value for
     * <code>DBParameterGroupName</code>, then Amazon RDS uses the default <code>DBParameterGroup</code>.
     * </p>
     * <p>
     * Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region read
     * replicas, for Multi-AZ DB cluster read replica instances, for Db2 DB instances, and for Oracle DB instances. It
     * isn't supported for MySQL DB instances for same Region read replicas or for RDS Custom.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group to associate with this read replica DB instance.</p>
     *         <p>
     *         For the Db2 DB engine, if your source DB instance uses the Bring Your Own License model, then a custom
     *         parameter group must be associated with the replica. For a same Amazon Web Services Region replica, if
     *         you don't specify a custom parameter group, Amazon RDS associates the custom parameter group associated
     *         with the source DB instance. For a cross-Region replica, you must specify a custom parameter group. This
     *         custom parameter group must include your IBM Site ID and IBM Customer ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html#db2-prereqs-ibm-info">
     *         IBM IDs for Bring Your Own License for Db2</a>.
     *         </p>
     *         <p>
     *         For Single-AZ or Multi-AZ DB instance read replica instances, if you don't specify a value for
     *         <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of the source
     *         DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the
     *         specified DB engine for a cross-Region read replica.
     *         </p>
     *         <p>
     *         For Multi-AZ DB cluster same Region read replica instances, if you don't specify a value for
     *         <code>DBParameterGroupName</code>, then Amazon RDS uses the default <code>DBParameterGroup</code>.
     *         </p>
     *         <p>
     *         Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region
     *         read replicas, for Multi-AZ DB cluster read replica instances, for Db2 DB instances, and for Oracle DB
     *         instances. It isn't supported for MySQL DB instances for same Region read replicas or for RDS Custom.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * Specifies whether the DB instance is publicly accessible.
     * </p>
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * </p>
     * <p>
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * For more information, see <a>CreateDBInstance</a>.
     * </p>
     * 
     * @return Specifies whether the DB instance is publicly accessible.</p>
     *         <p>
     *         When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
     *         IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address
     *         from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security
     *         group it uses. That public access isn't permitted if the security group assigned to the DB cluster
     *         doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         For more information, see <a>CreateDBInstance</a>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet
     * group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DB subnet group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * All read replicas in one Amazon Web Services Region that are created from the same source DB instance must
     * either:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not specify a DB subnet group. All these read replicas are created outside of any VPC.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * 
     * @return A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB
     *         subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DB subnet group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is
     *         running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All read replicas in one Amazon Web Services Region that are created from the same source DB instance
     *         must either:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not specify a DB subnet group. All these read replicas are created outside of any VPC.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon EC2 VPC security groups to associate with the read replica.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of Amazon EC2 VPC security groups to associate with the read replica.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The storage type to associate with the read replica.
     * </p>
     * <p>
     * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
     * <code>Iops</code> parameter.
     * </p>
     * <p>
     * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     * </p>
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
     * </p>
     * 
     * @return The storage type to associate with the read replica.</p>
     *         <p>
     *         If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for
     *         the <code>Iops</code> parameter.
     *         </p>
     *         <p>
     *         Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     *         </p>
     *         <p>
     *         Default: <code>io1</code> if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default, tags
     * aren't copied.
     * </p>
     * 
     * @return Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default,
     *         tags aren't copied.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To
     * disable collection of Enhanced Monitoring metrics, specify <code>0</code>. The default is <code>0</code>.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value
     * other than <code>0</code>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read
     *         replica. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>. The default is
     *         <code>0</code>.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a
     *         value other than <code>0</code>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go
     * to <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
     * create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     *         For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     *         monitoring role, go to <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
     *         >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     *         <code>MonitoringRoleArn</code> value.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted read replica.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance or
     * Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same Amazon Web Services
     * Region is always encrypted with the same KMS key as the source DB instance or cluster.
     * </p>
     * <p>
     * If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS
     * key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services
     * Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon
     * Web Services Region.
     * </p>
     * <p>
     * You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance
     *         or Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same Amazon Web
     *         Services Region is always encrypted with the same KMS key as the source DB instance or cluster.
     *         </p>
     *         <p>
     *         If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify
     *         a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon
     *         Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services
     *         Region in another Amazon Web Services Region.
     *         </p>
     *         <p>
     *         You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from one
     * China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed request for the
     * <code>CreateDBInstanceReadReplica</code> API operation in the source Amazon Web Services Region that contains the
     * source DB instance.
     * </p>
     * <p>
     * This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
     * It's ignored in other Amazon Web Services Regions.
     * </p>
     * <p>
     * This setting applies only when replicating from a source DB <i>instance</i>. Source DB clusters aren't supported
     * in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
     * </p>
     * <p>
     * You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region
     * by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are creating an encrypted read
     * replica in the same Amazon Web Services Region.
     * </p>
     * <p>
     * The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API operation that can
     * run in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL
     * request must contain the following parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in.
     * This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> operation is
     * called that contains this presigned URL.
     * </p>
     * <p>
     * For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB
     * instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code>
     * operation in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
     * <code>CreateDBInstanceReadReplica</code> operation in the us-west-2 Amazon Web Services Region. For this example,
     * the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the read replica in the destination
     * Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code>
     * operation that is called in the destination Amazon Web Services Region, and the operation contained in the
     * presigned URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be
     * replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services
     * Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web
     * Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example:
     * <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn how to generate a Signature Version 4 signed request, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests:
     * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
     * Process</a>.
     * </p>
     * <note>
     * <p>
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
     * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying
     * <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in
     * the source Amazon Web Services Region.
     * </p>
     * </note>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from
     *         one China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed
     *         request for the <code>CreateDBInstanceReadReplica</code> API operation in the source Amazon Web Services
     *         Region that contains the source DB instance.</p>
     *         <p>
     *         This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services
     *         Regions. It's ignored in other Amazon Web Services Regions.
     *         </p>
     *         <p>
     *         This setting applies only when replicating from a source DB <i>instance</i>. Source DB clusters aren't
     *         supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
     *         </p>
     *         <p>
     *         You must specify this parameter when you create an encrypted read replica from another Amazon Web
     *         Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are
     *         creating an encrypted read replica in the same Amazon Web Services Region.
     *         </p>
     *         <p>
     *         The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API operation
     *         that can run in the source Amazon Web Services Region that contains the encrypted source DB instance. The
     *         presigned URL request must contain the following parameter values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is
     *         created in. This Amazon Web Services Region is the same one where the
     *         <code>CreateDBInstanceReadReplica</code> operation is called that contains this presigned URL.
     *         </p>
     *         <p>
     *         For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a
     *         source DB instance in the us-east-2 Amazon Web Services Region, then you call the
     *         <code>CreateDBInstanceReadReplica</code> operation in the us-east-1 Amazon Web Services Region and
     *         provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> operation in
     *         the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the
     *         presigned URL must be set to the us-east-1 Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the read replica in the
     *         destination Amazon Web Services Region. This is the same identifier for both the
     *         <code>CreateDBInstanceReadReplica</code> operation that is called in the destination Amazon Web Services
     *         Region, and the operation contained in the presigned URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be
     *         replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web
     *         Services Region. For example, if you are creating an encrypted read replica from a DB instance in the
     *         us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the
     *         following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To learn how to generate a Signature Version 4 signed request, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating
     *         Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
     *         Process</a>.
     *         </p>
     *         <note>
     *         <p>
     *         If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
     *         (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
     *         Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the
     *         operation that can run in the source Amazon Web Services Region.
     *         </p>
     *         </note>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information about IAM database authentication, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information about IAM database authentication, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     *         Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The mode of Database Insights to enable for the read replica.
     * </p>
     * <note>
     * <p>
     * This setting isn't supported.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return The mode of Database Insights to enable for the read replica.</p> <note>
     *         <p>
     *         This setting isn't supported.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(databaseInsightsMode);
    }

    /**
     * <p>
     * The mode of Database Insights to enable for the read replica.
     * </p>
     * <note>
     * <p>
     * This setting isn't supported.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return The mode of Database Insights to enable for the read replica.</p> <note>
     *         <p>
     *         This setting isn't supported.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final String databaseInsightsModeAsString() {
        return databaseInsightsMode;
    }

    /**
     * <p>
     * Specifies whether to enable Performance Insights for the read replica.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return Specifies whether to enable Performance Insights for the read replica.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31),
     * <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>731</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * </p>
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
     *         months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>731</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>7</code> days
     *         </p>
     *         <p>
     *         If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the
     * DB engine being used. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend
     *         on the DB engine being used. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB
     *         instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final List<ProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return Specifies whether the DB instance class of the DB instance uses its default processor features.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final Boolean useDefaultProcessorFeatures() {
        return useDefaultProcessorFeatures;
    }

    /**
     * <p>
     * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     * Instance</a>.
     * </p>
     * 
     * @return Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     *         Instance</a>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server,
     * Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     * Authentication</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
     *         Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     *         Authentication</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be longer than 64 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
     * </p>
     * 
     * @return The fully qualified domain name (FQDN) of an Active Directory domain.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be longer than 64 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
     */
    public final String domainFqdn() {
        return domainFqdn;
    }

    /**
     * <p>
     * The Active Directory organizational unit for your DB instance to join.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the distinguished name format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be longer than 64 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
     * </p>
     * 
     * @return The Active Directory organizational unit for your DB instance to join.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the distinguished name format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be longer than 64 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
     */
    public final String domainOu() {
        return domainOu;
    }

    /**
     * <p>
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     * </p>
     * <p>
     * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
     * </p>
     * 
     * @return The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p>
     *         <p>
     *         Example:
     *         <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
     */
    public final String domainAuthSecretArn() {
        return domainAuthSecretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainDnsIps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainDnsIps() {
        return domainDnsIps != null && !(domainDnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
     * primary domain controller for both entries in the list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>123.124.125.126,234.235.236.237</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainDnsIps} method.
     * </p>
     * 
     * @return The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
     *         the primary domain controller for both entries in the list.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>123.124.125.126,234.235.236.237</code>
     */
    public final List<String> domainDnsIps() {
        return domainDnsIps;
    }

    /**
     * <p>
     * The open mode of the replica database.
     * </p>
     * <note>
     * <p>
     * This parameter is only supported for Db2 DB instances and Oracle DB instances.
     * </p>
     * </note>
     * <dl>
     * <dt>Db2</dt>
     * <dd>
     * <p>
     * Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use case
     * for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections, a standby
     * replica can't serve a read-only workload.
     * </p>
     * <p>
     * You can create a combination of standby and read-only DB replicas for the same primary DB instance. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working
     * with read replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
     * </p>
     * </dd>
     * <dt>Oracle</dt>
     * <dd>
     * <p>
     * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is
     * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the
     * mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
     * </p>
     * <p>
     * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
     * replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by
     * default. After replica creation, you can manage the open mode manually.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return The open mode of the replica database.</p> <note>
     *         <p>
     *         This parameter is only supported for Db2 DB instances and Oracle DB instances.
     *         </p>
     *         </note>
     *         <dl>
     *         <dt>Db2</dt>
     *         <dd>
     *         <p>
     *         Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use
     *         case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections,
     *         a standby replica can't serve a read-only workload.
     *         </p>
     *         <p>
     *         You can create a combination of standby and read-only DB replicas for the same primary DB instance. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read
     *         replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
     *         </p>
     *         </dd>
     *         <dt>Oracle</dt>
     *         <dd>
     *         <p>
     *         Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
     *         replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to
     *         transmit information to the mounted replica. Because it doesn't accept user connections, a mounted
     *         replica can't serve a read-only workload.
     *         </p>
     *         <p>
     *         You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
     *         replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be
     *         set by default. After replica creation, you can manage the open mode manually.
     *         </p>
     *         </dd>
     * @see ReplicaMode
     */
    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(replicaMode);
    }

    /**
     * <p>
     * The open mode of the replica database.
     * </p>
     * <note>
     * <p>
     * This parameter is only supported for Db2 DB instances and Oracle DB instances.
     * </p>
     * </note>
     * <dl>
     * <dt>Db2</dt>
     * <dd>
     * <p>
     * Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use case
     * for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections, a standby
     * replica can't serve a read-only workload.
     * </p>
     * <p>
     * You can create a combination of standby and read-only DB replicas for the same primary DB instance. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working
     * with read replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
     * </p>
     * </dd>
     * <dt>Oracle</dt>
     * <dd>
     * <p>
     * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is
     * cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the
     * mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.
     * </p>
     * <p>
     * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
     * replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by
     * default. After replica creation, you can manage the open mode manually.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return The open mode of the replica database.</p> <note>
     *         <p>
     *         This parameter is only supported for Db2 DB instances and Oracle DB instances.
     *         </p>
     *         </note>
     *         <dl>
     *         <dt>Db2</dt>
     *         <dd>
     *         <p>
     *         Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use
     *         case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections,
     *         a standby replica can't serve a read-only workload.
     *         </p>
     *         <p>
     *         You can create a combination of standby and read-only DB replicas for the same primary DB instance. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read
     *         replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
     *         </p>
     *         </dd>
     *         <dt>Oracle</dt>
     *         <dd>
     *         <p>
     *         Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
     *         replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to
     *         transmit information to the mounted replica. Because it doesn't accept user connections, a mounted
     *         replica can't serve a read-only workload.
     *         </p>
     *         <p>
     *         You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
     *         replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be
     *         set by default. After replica creation, you can manage the open mode manually.
     *         </p>
     *         </dd>
     * @see ReplicaMode
     */
    public final String replicaModeAsString() {
        return replicaMode;
    }

    /**
     * <p>
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
     *         instance.</p>
     *         <p>
     *         For more information about this setting, including limitations that apply to it, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
     *         > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
     *         Guide</i>.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The
     * instance profile must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The profile must exist in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * The profile must have an IAM role that Amazon EC2 has permissions to assume.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the list of permissions required for the IAM role, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
     * Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting is required for RDS Custom DB instances.
     * </p>
     * 
     * @return The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The
     *         instance profile must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The profile must exist in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The profile must have an IAM role that Amazon EC2 has permissions to assume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The instance profile name and the associated IAM role name must start with the prefix
     *         <code>AWSRDSCustom</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For the list of permissions required for the IAM role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"
     *         > Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting is required for RDS Custom DB instances.
     */
    public final String customIamInstanceProfile() {
        return customIamInstanceProfile;
    }

    /**
     * <p>
     * The network type of the DB instance.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working
     * with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The network type of the DB instance.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     *         Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * Specifies the storage throughput value for the read replica.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
     * </p>
     * 
     * @return Specifies the storage throughput value for the read replica.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
     */
    public final Integer storageThroughput() {
        return storageThroughput;
    }

    /**
     * <p>
     * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.
     * </p>
     * <p>
     * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read replica
     * from outside of its virtual private cloud (VPC) on your local network.
     * </p>
     * <p>
     * For more information about RDS on Outposts, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
     * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about CoIPs, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
     * addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.</p>
     *         <p>
     *         A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     *         on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read
     *         replica from outside of its virtual private cloud (VPC) on your local network.
     *         </p>
     *         <p>
     *         For more information about RDS on Outposts, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
     *         RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about CoIPs, see <a
     *         href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
     *         addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     */
    public final Boolean enableCustomerOwnedIp() {
        return enableCustomerOwnedIp;
    }

    /**
     * <p>
     * The location where RDS stores automated backups and manual snapshots.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>local</code> for Dedicated Local Zones
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region</code> for Amazon Web Services Region
     * </p>
     * </li>
     * </ul>
     * 
     * @return The location where RDS stores automated backups and manual snapshots.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>local</code> for Dedicated Local Zones
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region</code> for Amazon Web Services Region
     *         </p>
     *         </li>
     */
    public final String backupTarget() {
        return backupTarget;
    }

    /**
     * <p>
     * The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation rules
     * specified in <code>CreateDBInstance</code>.
     * </p>
     * <p>
     * This setting isn't valid for RDS for SQL Server.
     * </p>
     * <note>
     * <p>
     * Be sure to allocate enough storage for your read replica so that the create operation can succeed. You can also
     * allocate additional storage for future growth.
     * </p>
     * </note>
     * 
     * @return The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation
     *         rules specified in <code>CreateDBInstance</code>.</p>
     *         <p>
     *         This setting isn't valid for RDS for SQL Server.
     *         </p>
     *         <note>
     *         <p>
     *         Be sure to allocate enough storage for your read replica so that the create operation can succeed. You
     *         can also allocate additional storage for future growth.
     *         </p>
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can
     * have up to 15 read replicas.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be the identifier of an existing Multi-AZ DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be
     * greater than 0.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region
     * replication isn't supported.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB
     *         cluster can have up to 15 read replicas.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be the identifier of an existing Multi-AZ DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The specified DB cluster must have automatic backups enabled, that is, its backup retention period must
     *         be greater than 0.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region
     *         replication isn't supported.
     *         </p>
     *         </li>
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     * </p>
     * 
     * @return Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    public final Boolean dedicatedLogVolume() {
        return dedicatedLogVolume;
    }

    /**
     * <p>
     * Whether to upgrade the storage file system configuration on the read replica. This option migrates the read
     * replica from the old storage file system layout to the preferred layout.
     * </p>
     * 
     * @return Whether to upgrade the storage file system configuration on the read replica. This option migrates the
     *         read replica from the old storage file system layout to the preferred layout.
     */
    public final Boolean upgradeStorageConfig() {
        return upgradeStorageConfig;
    }

    /**
     * <p>
     * The CA certificate identifier to use for the read replica's server certificate.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The CA certificate identifier to use for the read replica's server certificate.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
     *         encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS
     *         to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl will be
     * generated automatically by the SDK.
     * 
     * @return If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
     *         will be generated automatically by the SDK.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(domainFqdn());
        hashCode = 31 * hashCode + Objects.hashCode(domainOu());
        hashCode = 31 * hashCode + Objects.hashCode(domainAuthSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainDnsIps() ? domainDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(customIamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(enableCustomerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(backupTarget());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(upgradeStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceReadReplicaRequest)) {
            return false;
        }
        CreateDbInstanceReadReplicaRequest other = (CreateDbInstanceReadReplicaRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(sourceDBInstanceIdentifier(), other.sourceDBInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(port(), other.port())
                && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(iops(), other.iops()) && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(databaseInsightsModeAsString(), other.databaseInsightsModeAsString())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures())
                && Objects.equals(deletionProtection(), other.deletionProtection()) && Objects.equals(domain(), other.domain())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(domainFqdn(), other.domainFqdn()) && Objects.equals(domainOu(), other.domainOu())
                && Objects.equals(domainAuthSecretArn(), other.domainAuthSecretArn())
                && hasDomainDnsIps() == other.hasDomainDnsIps() && Objects.equals(domainDnsIps(), other.domainDnsIps())
                && Objects.equals(replicaModeAsString(), other.replicaModeAsString())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(customIamInstanceProfile(), other.customIamInstanceProfile())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(storageThroughput(), other.storageThroughput())
                && Objects.equals(enableCustomerOwnedIp(), other.enableCustomerOwnedIp())
                && Objects.equals(backupTarget(), other.backupTarget())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(dedicatedLogVolume(), other.dedicatedLogVolume())
                && Objects.equals(upgradeStorageConfig(), other.upgradeStorageConfig())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(sourceRegion(), other.sourceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbInstanceReadReplicaRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("SourceDBInstanceIdentifier", sourceDBInstanceIdentifier()).add("DBInstanceClass", dbInstanceClass())
                .add("AvailabilityZone", availabilityZone()).add("Port", port()).add("MultiAZ", multiAZ())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("Iops", iops())
                .add("OptionGroupName", optionGroupName()).add("DBParameterGroupName", dbParameterGroupName())
                .add("PubliclyAccessible", publiclyAccessible()).add("Tags", hasTags() ? tags() : null)
                .add("DBSubnetGroupName", dbSubnetGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("StorageType", storageType()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("MonitoringInterval", monitoringInterval()).add("MonitoringRoleArn", monitoringRoleArn())
                .add("KmsKeyId", kmsKeyId()).add("PreSignedUrl", preSignedUrl())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("DatabaseInsightsMode", databaseInsightsModeAsString())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("UseDefaultProcessorFeatures", useDefaultProcessorFeatures())
                .add("DeletionProtection", deletionProtection()).add("Domain", domain())
                .add("DomainIAMRoleName", domainIAMRoleName()).add("DomainFqdn", domainFqdn()).add("DomainOu", domainOu())
                .add("DomainAuthSecretArn", domainAuthSecretArn()).add("DomainDnsIps", hasDomainDnsIps() ? domainDnsIps() : null)
                .add("ReplicaMode", replicaModeAsString()).add("MaxAllocatedStorage", maxAllocatedStorage())
                .add("CustomIamInstanceProfile", customIamInstanceProfile()).add("NetworkType", networkType())
                .add("StorageThroughput", storageThroughput()).add("EnableCustomerOwnedIp", enableCustomerOwnedIp())
                .add("BackupTarget", backupTarget()).add("AllocatedStorage", allocatedStorage())
                .add("SourceDBClusterIdentifier", sourceDBClusterIdentifier()).add("DedicatedLogVolume", dedicatedLogVolume())
                .add("UpgradeStorageConfig", upgradeStorageConfig()).add("CACertificateIdentifier", caCertificateIdentifier())
                .add("SourceRegion", sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "SourceDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "DatabaseInsightsMode":
            return Optional.ofNullable(clazz.cast(databaseInsightsModeAsString()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "UseDefaultProcessorFeatures":
            return Optional.ofNullable(clazz.cast(useDefaultProcessorFeatures()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "DomainFqdn":
            return Optional.ofNullable(clazz.cast(domainFqdn()));
        case "DomainOu":
            return Optional.ofNullable(clazz.cast(domainOu()));
        case "DomainAuthSecretArn":
            return Optional.ofNullable(clazz.cast(domainAuthSecretArn()));
        case "DomainDnsIps":
            return Optional.ofNullable(clazz.cast(domainDnsIps()));
        case "ReplicaMode":
            return Optional.ofNullable(clazz.cast(replicaModeAsString()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "CustomIamInstanceProfile":
            return Optional.ofNullable(clazz.cast(customIamInstanceProfile()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "StorageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        case "EnableCustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(enableCustomerOwnedIp()));
        case "BackupTarget":
            return Optional.ofNullable(clazz.cast(backupTarget()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "DedicatedLogVolume":
            return Optional.ofNullable(clazz.cast(dedicatedLogVolume()));
        case "UpgradeStorageConfig":
            return Optional.ofNullable(clazz.cast(upgradeStorageConfig()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("SourceDBInstanceIdentifier", SOURCE_DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("ProcessorFeatures", PROCESSOR_FEATURES_FIELD);
        map.put("UseDefaultProcessorFeatures", USE_DEFAULT_PROCESSOR_FEATURES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainIAMRoleName", DOMAIN_IAM_ROLE_NAME_FIELD);
        map.put("DomainFqdn", DOMAIN_FQDN_FIELD);
        map.put("DomainOu", DOMAIN_OU_FIELD);
        map.put("DomainAuthSecretArn", DOMAIN_AUTH_SECRET_ARN_FIELD);
        map.put("DomainDnsIps", DOMAIN_DNS_IPS_FIELD);
        map.put("ReplicaMode", REPLICA_MODE_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("CustomIamInstanceProfile", CUSTOM_IAM_INSTANCE_PROFILE_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("EnableCustomerOwnedIp", ENABLE_CUSTOMER_OWNED_IP_FIELD);
        map.put("BackupTarget", BACKUP_TARGET_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("SourceDBClusterIdentifier", SOURCE_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("UpgradeStorageConfig", UPGRADE_STORAGE_CONFIG_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceReadReplicaRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceReadReplicaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbInstanceReadReplicaRequest> {
        /**
         * <p>
         * The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB
         * instance. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB
         *        instance. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have
         * up to 15 read replicas, except for the following engines:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Db2 - Can have up to three replicas.
         * </p>
         * </li>
         * <li>
         * <p>
         * Oracle - Can have up to five read replicas.
         * </p>
         * </li>
         * <li>
         * <p>
         * SQL Server - Can have up to five read replicas.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if the <code>SourceDBClusterIdentifier</code> parameter is also specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the limitations of Oracle read replicas, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses"
         * >Version and licensing considerations for RDS for Oracle replicas</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the limitations of SQL Server read replicas, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations"
         * >Read replica limitations with SQL Server</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The specified DB instance must have automatic backups enabled, that is, its backup retention period must be
         * greater than 0.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB
         * instance identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid
         * DB instance ARN. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
         * >Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server
         * or RDS Custom, which don't support cross-Region replicas.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBInstanceIdentifier
         *        The identifier of the DB instance that will act as the source for the read replica. Each DB instance
         *        can have up to 15 read replicas, except for the following engines:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Db2 - Can have up to three replicas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Oracle - Can have up to five read replicas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SQL Server - Can have up to five read replicas.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB
         *        instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if the <code>SourceDBClusterIdentifier</code> parameter is also specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the limitations of Oracle read replicas, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses"
         *        >Version and licensing considerations for RDS for Oracle replicas</a> in the <i>Amazon RDS User
         *        Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the limitations of SQL Server read replicas, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations"
         *        >Read replica limitations with SQL Server</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The specified DB instance must have automatic backups enabled, that is, its backup retention period
         *        must be greater than 0.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a
         *        valid DB instance identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source DB instance is in a different Amazon Web Services Region from the read replica, specify
         *        a valid DB instance ARN. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"
         *        >Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL
         *        Server or RDS Custom, which don't support cross-Region replicas.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier);

        /**
         * <p>
         * The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are
         * available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance
         * classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Default: Inherits the value from the source DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance
         *        classes are available in all Amazon Web Services Regions, or for all database engines. For the full
         *        list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        Default: Inherits the value from the source DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The Availability Zone (AZ) where the read replica will be created.
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         * </p>
         * <p>
         * Example: <code>us-east-1d</code>
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone (AZ) where the read replica will be created.</p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Example: <code>us-east-1d</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The port number that the DB instance uses for connections.
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * <p>
         * Default: Inherits the value from the source DB instance.
         * </p>
         * 
         * @param port
         *        The port number that the DB instance uses for connections.</p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: Inherits the value from the source DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies whether the read replica is in a Multi-AZ deployment.
         * </p>
         * <p>
         * You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another
         * Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance
         * is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the read replica is in a Multi-AZ deployment.</p>
         *        <p>
         *        You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in
         *        another Availability Zone for failover support for the replica. Creating your read replica as a
         *        Multi-AZ DB instance is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB
         *        cluster.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance
         * window.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Default: Inherits the value from the source DB instance.
         * </p>
         * <p>
         * For more information about automatic minor version upgrades, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         * >Automatically upgrading the minor engine version</a>.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Specifies whether to automatically apply minor engine upgrades to the read replica during the
         *        maintenance window.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Default: Inherits the value from the source DB instance.
         *        </p>
         *        <p>
         *        For more information about automatic minor version upgrades, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         *        >Automatically upgrading the minor engine version</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
         * instance.
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The option group to associate the DB instance with. If not specified, RDS uses the option group associated
         * with the source DB instance or cluster.
         * </p>
         * <note>
         * <p>
         * For SQL Server, you must use the option group associated with the source.
         * </p>
         * </note>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param optionGroupName
         *        The option group to associate the DB instance with. If not specified, RDS uses the option group
         *        associated with the source DB instance or cluster.</p> <note>
         *        <p>
         *        For SQL Server, you must use the option group associated with the source.
         *        </p>
         *        </note>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The name of the DB parameter group to associate with this read replica DB instance.
         * </p>
         * <p>
         * For the Db2 DB engine, if your source DB instance uses the Bring Your Own License model, then a custom
         * parameter group must be associated with the replica. For a same Amazon Web Services Region replica, if you
         * don't specify a custom parameter group, Amazon RDS associates the custom parameter group associated with the
         * source DB instance. For a cross-Region replica, you must specify a custom parameter group. This custom
         * parameter group must include your IBM Site ID and IBM Customer ID. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html#db2-prereqs-ibm-info"> IBM
         * IDs for Bring Your Own License for Db2</a>.
         * </p>
         * <p>
         * For Single-AZ or Multi-AZ DB instance read replica instances, if you don't specify a value for
         * <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of the source DB
         * instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB
         * engine for a cross-Region read replica.
         * </p>
         * <p>
         * For Multi-AZ DB cluster same Region read replica instances, if you don't specify a value for
         * <code>DBParameterGroupName</code>, then Amazon RDS uses the default <code>DBParameterGroup</code>.
         * </p>
         * <p>
         * Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region
         * read replicas, for Multi-AZ DB cluster read replica instances, for Db2 DB instances, and for Oracle DB
         * instances. It isn't supported for MySQL DB instances for same Region read replicas or for RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to associate with this read replica DB instance.</p>
         *        <p>
         *        For the Db2 DB engine, if your source DB instance uses the Bring Your Own License model, then a custom
         *        parameter group must be associated with the replica. For a same Amazon Web Services Region replica, if
         *        you don't specify a custom parameter group, Amazon RDS associates the custom parameter group
         *        associated with the source DB instance. For a cross-Region replica, you must specify a custom
         *        parameter group. This custom parameter group must include your IBM Site ID and IBM Customer ID. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html#db2-prereqs-ibm-info"> IBM
         *        IDs for Bring Your Own License for Db2</a>.
         *        </p>
         *        <p>
         *        For Single-AZ or Multi-AZ DB instance read replica instances, if you don't specify a value for
         *        <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of the
         *        source DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for
         *        the specified DB engine for a cross-Region read replica.
         *        </p>
         *        <p>
         *        For Multi-AZ DB cluster same Region read replica instances, if you don't specify a value for
         *        <code>DBParameterGroupName</code>, then Amazon RDS uses the default <code>DBParameterGroup</code>.
         *        </p>
         *        <p>
         *        Specifying a parameter group for this operation is only supported for MySQL DB instances for
         *        cross-Region read replicas, for Multi-AZ DB cluster read replica instances, for Db2 DB instances, and
         *        for Oracle DB instances. It isn't supported for MySQL DB instances for same Region read replicas or
         *        for RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * Specifies whether the DB instance is publicly accessible.
         * </p>
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it
         * uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         * </p>
         * <p>
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves
         * to a private IP address.
         * </p>
         * <p>
         * For more information, see <a>CreateDBInstance</a>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB instance is publicly accessible.</p>
         *        <p>
         *        When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public
         *        IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by
         *        the security group it uses. That public access isn't permitted if the security group assigned to the
         *        DB cluster doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        For more information, see <a>CreateDBInstance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB
         * subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DB subnet group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is
         * running.
         * </p>
         * </li>
         * <li>
         * <p>
         * All read replicas in one Amazon Web Services Region that are created from the same source DB instance must
         * either:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not specify a DB subnet group. All these read replicas are created outside of any VPC.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the
         *        DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a
         *        VPC.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DB subnet group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is
         *        running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All read replicas in one Amazon Web Services Region that are created from the same source DB instance
         *        must either:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not specify a DB subnet group. All these read replicas are created outside of any VPC.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with the read replica.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with the read replica.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with the read replica.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with the read replica.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The storage type to associate with the read replica.
         * </p>
         * <p>
         * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
         * <code>Iops</code> parameter.
         * </p>
         * <p>
         * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         * </p>
         * <p>
         * Default: <code>io1</code> if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
         * </p>
         * 
         * @param storageType
         *        The storage type to associate with the read replica.</p>
         *        <p>
         *        If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value
         *        for the <code>Iops</code> parameter.
         *        </p>
         *        <p>
         *        Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         *        </p>
         *        <p>
         *        Default: <code>io1</code> if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default, tags
         * aren't copied.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default,
         *        tags aren't copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica.
         * To disable collection of Enhanced Monitoring metrics, specify <code>0</code>. The default is <code>0</code>.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value
         * other than <code>0</code>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read
         *        replica. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>. The default is
         *        <code>0</code>.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a
         *        value other than <code>0</code>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
         * go to <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
         * create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
         *        monitoring role, go to <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
         *        >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         *        <code>MonitoringRoleArn</code> value.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted read replica.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance or
         * Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same Amazon Web Services
         * Region is always encrypted with the same KMS key as the source DB instance or cluster.
         * </p>
         * <p>
         * If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a
         * KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web
         * Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in
         * another Amazon Web Services Region.
         * </p>
         * <p>
         * You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you create an encrypted read replica in the same Amazon Web Services Region as the source DB
         *        instance or Multi-AZ DB cluster, don't specify a value for this parameter. A read replica in the same
         *        Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance or
         *        cluster.
         *        </p>
         *        <p>
         *        If you create an encrypted read replica in a different Amazon Web Services Region, then you must
         *        specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to
         *        the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon
         *        Web Services Region in another Amazon Web Services Region.
         *        </p>
         *        <p>
         *        You can't create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from one
         * China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed request for
         * the <code>CreateDBInstanceReadReplica</code> API operation in the source Amazon Web Services Region that
         * contains the source DB instance.
         * </p>
         * <p>
         * This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
         * It's ignored in other Amazon Web Services Regions.
         * </p>
         * <p>
         * This setting applies only when replicating from a source DB <i>instance</i>. Source DB clusters aren't
         * supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
         * </p>
         * <p>
         * You must specify this parameter when you create an encrypted read replica from another Amazon Web Services
         * Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are creating an
         * encrypted read replica in the same Amazon Web Services Region.
         * </p>
         * <p>
         * The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API operation that
         * can run in the source Amazon Web Services Region that contains the encrypted source DB instance. The
         * presigned URL request must contain the following parameter values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created
         * in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code>
         * operation is called that contains this presigned URL.
         * </p>
         * <p>
         * For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a
         * source DB instance in the us-east-2 Amazon Web Services Region, then you call the
         * <code>CreateDBInstanceReadReplica</code> operation in the us-east-1 Amazon Web Services Region and provide a
         * presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> operation in the us-west-2
         * Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be
         * set to the us-east-1 Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the read replica in the
         * destination Amazon Web Services Region. This is the same identifier for both the
         * <code>CreateDBInstanceReadReplica</code> operation that is called in the destination Amazon Web Services
         * Region, and the operation contained in the presigned URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be
         * replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web
         * Services Region. For example, if you are creating an encrypted read replica from a DB instance in the
         * us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the
         * following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn how to generate a Signature Version 4 signed request, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests:
         * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
         * Process</a>.
         * </p>
         * <note>
         * <p>
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
         * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
         * Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation
         * that can run in the source Amazon Web Services Region.
         * </p>
         * </note>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param preSignedUrl
         *        When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or
         *        from one China Amazon Web Services Region to another, the URL that contains a Signature Version 4
         *        signed request for the <code>CreateDBInstanceReadReplica</code> API operation in the source Amazon Web
         *        Services Region that contains the source DB instance.</p>
         *        <p>
         *        This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services
         *        Regions. It's ignored in other Amazon Web Services Regions.
         *        </p>
         *        <p>
         *        This setting applies only when replicating from a source DB <i>instance</i>. Source DB clusters aren't
         *        supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.
         *        </p>
         *        <p>
         *        You must specify this parameter when you create an encrypted read replica from another Amazon Web
         *        Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are
         *        creating an encrypted read replica in the same Amazon Web Services Region.
         *        </p>
         *        <p>
         *        The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API
         *        operation that can run in the source Amazon Web Services Region that contains the encrypted source DB
         *        instance. The presigned URL request must contain the following parameter values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is
         *        created in. This Amazon Web Services Region is the same one where the
         *        <code>CreateDBInstanceReadReplica</code> operation is called that contains this presigned URL.
         *        </p>
         *        <p>
         *        For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from
         *        a source DB instance in the us-east-2 Amazon Web Services Region, then you call the
         *        <code>CreateDBInstanceReadReplica</code> operation in the us-east-1 Amazon Web Services Region and
         *        provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> operation
         *        in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in
         *        the presigned URL must be set to the us-east-1 Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the read replica in the
         *        destination Amazon Web Services Region. This is the same identifier for both the
         *        <code>CreateDBInstanceReadReplica</code> operation that is called in the destination Amazon Web
         *        Services Region, and the operation contained in the presigned URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to
         *        be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon
         *        Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in
         *        the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like
         *        the following example:
         *        <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To learn how to generate a Signature Version 4 signed request, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating
         *        Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
         *        Signing Process</a>.
         *        </p>
         *        <note>
         *        <p>
         *        If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
         *        (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code>
         *        manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request
         *        for the operation that can run in the source Amazon Web Services Region.
         *        </p>
         *        </note>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information about IAM database authentication, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information about IAM database authentication, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The mode of Database Insights to enable for the read replica.
         * </p>
         * <note>
         * <p>
         * This setting isn't supported.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        The mode of Database Insights to enable for the read replica.</p> <note>
         *        <p>
         *        This setting isn't supported.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(String databaseInsightsMode);

        /**
         * <p>
         * The mode of Database Insights to enable for the read replica.
         * </p>
         * <note>
         * <p>
         * This setting isn't supported.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        The mode of Database Insights to enable for the read replica.</p> <note>
         *        <p>
         *        This setting isn't supported.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode);

        /**
         * <p>
         * Specifies whether to enable Performance Insights for the read replica.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
         * Insights</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to enable Performance Insights for the read replica.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months *
         * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>731</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * </p>
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
         *        months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>731</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>7</code> days
         *        </p>
         *        <p>
         *        If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on
         * the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on
         * the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<ProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(ProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.ProcessorFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder#build()} is called immediately and
         * its result is passed to {@link #processorFeatures(List<ProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(java.util.Collection<ProcessorFeature>)
         */
        Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param useDefaultProcessorFeatures
         *        Specifies whether the DB instance class of the DB instance uses its default processor features.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures);

        /**
         * <p>
         * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when
         * deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         * Instance</a>.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether to enable deletion protection for the DB instance. The database can't be deleted
         *        when deletion protection is enabled. By default, deletion protection isn't enabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         *        Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server,
         * Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         * Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
         *        Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         *        Authentication</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be longer than 64 characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * </p>
         * 
         * @param domainFqdn
         *        The fully qualified domain name (FQDN) of an Active Directory domain.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be longer than 64 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainFqdn(String domainFqdn);

        /**
         * <p>
         * The Active Directory organizational unit for your DB instance to join.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the distinguished name format.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be longer than 64 characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * </p>
         * 
         * @param domainOu
         *        The Active Directory organizational unit for your DB instance to join.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the distinguished name format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be longer than 64 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOu(String domainOu);

        /**
         * <p>
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         * </p>
         * <p>
         * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * </p>
         * 
         * @param domainAuthSecretArn
         *        The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p>
         *        <p>
         *        Example:
         *        <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAuthSecretArn(String domainAuthSecretArn);

        /**
         * <p>
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
         * primary domain controller for both entries in the list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>123.124.125.126,234.235.236.237</code>
         * </p>
         * 
         * @param domainDnsIps
         *        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
         *        the primary domain controller for both entries in the list.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>123.124.125.126,234.235.236.237</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDnsIps(Collection<String> domainDnsIps);

        /**
         * <p>
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
         * primary domain controller for both entries in the list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>123.124.125.126,234.235.236.237</code>
         * </p>
         * 
         * @param domainDnsIps
         *        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
         *        the primary domain controller for both entries in the list.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>123.124.125.126,234.235.236.237</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDnsIps(String... domainDnsIps);

        /**
         * <p>
         * The open mode of the replica database.
         * </p>
         * <note>
         * <p>
         * This parameter is only supported for Db2 DB instances and Oracle DB instances.
         * </p>
         * </note>
         * <dl>
         * <dt>Db2</dt>
         * <dd>
         * <p>
         * Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use
         * case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections, a
         * standby replica can't serve a read-only workload.
         * </p>
         * <p>
         * You can create a combination of standby and read-only DB replicas for the same primary DB instance. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read replicas
         * for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
         * </p>
         * </dd>
         * <dt>Oracle</dt>
         * <dd>
         * <p>
         * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
         * replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
         * information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve
         * a read-only workload.
         * </p>
         * <p>
         * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
         * replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by
         * default. After replica creation, you can manage the open mode manually.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param replicaMode
         *        The open mode of the replica database.</p> <note>
         *        <p>
         *        This parameter is only supported for Db2 DB instances and Oracle DB instances.
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>Db2</dt>
         *        <dd>
         *        <p>
         *        Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main
         *        use case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user
         *        connections, a standby replica can't serve a read-only workload.
         *        </p>
         *        <p>
         *        You can create a combination of standby and read-only DB replicas for the same primary DB instance.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read
         *        replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
         *        </p>
         *        </dd>
         *        <dt>Oracle</dt>
         *        <dd>
         *        <p>
         *        Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
         *        replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to
         *        transmit information to the mounted replica. Because it doesn't accept user connections, a mounted
         *        replica can't serve a read-only workload.
         *        </p>
         *        <p>
         *        You can create a combination of mounted and read-only DB replicas for the same primary DB instance.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
         *        read replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be
         *        set by default. After replica creation, you can manage the open mode manually.
         *        </p>
         *        </dd>
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(String replicaMode);

        /**
         * <p>
         * The open mode of the replica database.
         * </p>
         * <note>
         * <p>
         * This parameter is only supported for Db2 DB instances and Oracle DB instances.
         * </p>
         * </note>
         * <dl>
         * <dt>Db2</dt>
         * <dd>
         * <p>
         * Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main use
         * case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user connections, a
         * standby replica can't serve a read-only workload.
         * </p>
         * <p>
         * You can create a combination of standby and read-only DB replicas for the same primary DB instance. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read replicas
         * for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
         * </p>
         * </dd>
         * <dt>Oracle</dt>
         * <dd>
         * <p>
         * Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
         * replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit
         * information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve
         * a read-only workload.
         * </p>
         * <p>
         * You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with read
         * replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by
         * default. After replica creation, you can manage the open mode manually.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param replicaMode
         *        The open mode of the replica database.</p> <note>
         *        <p>
         *        This parameter is only supported for Db2 DB instances and Oracle DB instances.
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>Db2</dt>
         *        <dd>
         *        <p>
         *        Standby DB replicas are included in Db2 Advanced Edition (AE) and Db2 Standard Edition (SE). The main
         *        use case for standby replicas is cross-Region disaster recovery. Because it doesn't accept user
         *        connections, a standby replica can't serve a read-only workload.
         *        </p>
         *        <p>
         *        You can create a combination of standby and read-only DB replicas for the same primary DB instance.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-replication.html">Working with read
         *        replicas for Amazon RDS for Db2</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        To create standby DB replicas for RDS for Db2, set this parameter to <code>mounted</code>.
         *        </p>
         *        </dd>
         *        <dt>Oracle</dt>
         *        <dd>
         *        <p>
         *        Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted
         *        replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to
         *        transmit information to the mounted replica. Because it doesn't accept user connections, a mounted
         *        replica can't serve a read-only workload.
         *        </p>
         *        <p>
         *        You can create a combination of mounted and read-only DB replicas for the same primary DB instance.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with
         *        read replicas for Amazon RDS for Oracle</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be
         *        set by default. After replica creation, you can manage the open mode manually.
         *        </p>
         *        </dd>
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(ReplicaMode replicaMode);

        /**
         * <p>
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         * instance.
         * </p>
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         *        instance.</p>
         *        <p>
         *        For more information about this setting, including limitations that apply to it, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
         *        > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The
         * instance profile must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The profile must exist in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The profile must have an IAM role that Amazon EC2 has permissions to assume.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance profile name and the associated IAM role name must start with the prefix
         * <code>AWSRDSCustom</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the list of permissions required for the IAM role, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
         * Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting is required for RDS Custom DB instances.
         * </p>
         * 
         * @param customIamInstanceProfile
         *        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         *        The instance profile must meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The profile must exist in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The profile must have an IAM role that Amazon EC2 has permissions to assume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The instance profile name and the associated IAM role name must start with the prefix
         *        <code>AWSRDSCustom</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For the list of permissions required for the IAM role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"
         *        > Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting is required for RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customIamInstanceProfile(String customIamInstanceProfile);

        /**
         * <p>
         * The network type of the DB instance.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB instance.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         *        Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Specifies the storage throughput value for the read replica.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
         * </p>
         * 
         * @param storageThroughput
         *        Specifies the storage throughput value for the read replica.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Integer storageThroughput);

        /**
         * <p>
         * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.
         * </p>
         * <p>
         * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
         * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read replica
         * from outside of its virtual private cloud (VPC) on your local network.
         * </p>
         * <p>
         * For more information about RDS on Outposts, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
         * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about CoIPs, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
         * addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * </p>
         * 
         * @param enableCustomerOwnedIp
         *        Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read
         *        replica.</p>
         *        <p>
         *        A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through
         *        your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the
         *        read replica from outside of its virtual private cloud (VPC) on your local network.
         *        </p>
         *        <p>
         *        For more information about RDS on Outposts, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
         *        RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about CoIPs, see <a
         *        href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned
         *        IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp);

        /**
         * <p>
         * The location where RDS stores automated backups and manual snapshots.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>local</code> for Dedicated Local Zones
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region</code> for Amazon Web Services Region
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupTarget
         *        The location where RDS stores automated backups and manual snapshots.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>local</code> for Dedicated Local Zones
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region</code> for Amazon Web Services Region
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupTarget(String backupTarget);

        /**
         * <p>
         * The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation rules
         * specified in <code>CreateDBInstance</code>.
         * </p>
         * <p>
         * This setting isn't valid for RDS for SQL Server.
         * </p>
         * <note>
         * <p>
         * Be sure to allocate enough storage for your read replica so that the create operation can succeed. You can
         * also allocate additional storage for future growth.
         * </p>
         * </note>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation
         *        rules specified in <code>CreateDBInstance</code>.</p>
         *        <p>
         *        This setting isn't valid for RDS for SQL Server.
         *        </p>
         *        <note>
         *        <p>
         *        Be sure to allocate enough storage for your read replica so that the create operation can succeed. You
         *        can also allocate additional storage for future growth.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster
         * can have up to 15 read replicas.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be the identifier of an existing Multi-AZ DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be
         * greater than 0.
         * </p>
         * </li>
         * <li>
         * <p>
         * The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region
         * replication isn't supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBClusterIdentifier
         *        The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB
         *        cluster can have up to 15 read replicas.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be the identifier of an existing Multi-AZ DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The specified DB cluster must have automatic backups enabled, that is, its backup retention period
         *        must be greater than 0.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region
         *        replication isn't supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * </p>
         * 
         * @param dedicatedLogVolume
         *        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedLogVolume(Boolean dedicatedLogVolume);

        /**
         * <p>
         * Whether to upgrade the storage file system configuration on the read replica. This option migrates the read
         * replica from the old storage file system layout to the preferred layout.
         * </p>
         * 
         * @param upgradeStorageConfig
         *        Whether to upgrade the storage file system configuration on the read replica. This option migrates the
         *        read replica from the old storage file system layout to the preferred layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeStorageConfig(Boolean upgradeStorageConfig);

        /**
         * <p>
         * The CA certificate identifier to use for the read replica's server certificate.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt
         * a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
         * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The CA certificate identifier to use for the read replica's server certificate.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
         *        encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using
         *        SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
         * will be generated automatically by the SDK.
         * 
         * @param sourceRegion
         *        If PreSignedUrl is not specified, this is the region where the source snapshot is located. A
         *        PreSignedUrl will be generated automatically by the SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String sourceDBInstanceIdentifier;

        private String dbInstanceClass;

        private String availabilityZone;

        private Integer port;

        private Boolean multiAZ;

        private Boolean autoMinorVersionUpgrade;

        private Integer iops;

        private String optionGroupName;

        private String dbParameterGroupName;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String dbSubnetGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private String kmsKeyId;

        private String preSignedUrl;

        private Boolean enableIAMDatabaseAuthentication;

        private String databaseInsightsMode;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultProcessorFeatures;

        private Boolean deletionProtection;

        private String domain;

        private String domainIAMRoleName;

        private String domainFqdn;

        private String domainOu;

        private String domainAuthSecretArn;

        private List<String> domainDnsIps = DefaultSdkAutoConstructList.getInstance();

        private String replicaMode;

        private Integer maxAllocatedStorage;

        private String customIamInstanceProfile;

        private String networkType;

        private Integer storageThroughput;

        private Boolean enableCustomerOwnedIp;

        private String backupTarget;

        private Integer allocatedStorage;

        private String sourceDBClusterIdentifier;

        private Boolean dedicatedLogVolume;

        private Boolean upgradeStorageConfig;

        private String caCertificateIdentifier;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceReadReplicaRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            sourceDBInstanceIdentifier(model.sourceDBInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            availabilityZone(model.availabilityZone);
            port(model.port);
            multiAZ(model.multiAZ);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            dbParameterGroupName(model.dbParameterGroupName);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
            dbSubnetGroupName(model.dbSubnetGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            storageType(model.storageType);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            kmsKeyId(model.kmsKeyId);
            preSignedUrl(model.preSignedUrl);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            databaseInsightsMode(model.databaseInsightsMode);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            processorFeatures(model.processorFeatures);
            useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            deletionProtection(model.deletionProtection);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            domainFqdn(model.domainFqdn);
            domainOu(model.domainOu);
            domainAuthSecretArn(model.domainAuthSecretArn);
            domainDnsIps(model.domainDnsIps);
            replicaMode(model.replicaMode);
            maxAllocatedStorage(model.maxAllocatedStorage);
            customIamInstanceProfile(model.customIamInstanceProfile);
            networkType(model.networkType);
            storageThroughput(model.storageThroughput);
            enableCustomerOwnedIp(model.enableCustomerOwnedIp);
            backupTarget(model.backupTarget);
            allocatedStorage(model.allocatedStorage);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            dedicatedLogVolume(model.dedicatedLogVolume);
            upgradeStorageConfig(model.upgradeStorageConfig);
            caCertificateIdentifier(model.caCertificateIdentifier);
            sourceRegion(model.sourceRegion);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getSourceDBInstanceIdentifier() {
            return sourceDBInstanceIdentifier;
        }

        public final void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        }

        @Override
        public final Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> ProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final String getDomainFqdn() {
            return domainFqdn;
        }

        public final void setDomainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
        }

        @Override
        public final Builder domainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
            return this;
        }

        public final String getDomainOu() {
            return domainOu;
        }

        public final void setDomainOu(String domainOu) {
            this.domainOu = domainOu;
        }

        @Override
        public final Builder domainOu(String domainOu) {
            this.domainOu = domainOu;
            return this;
        }

        public final String getDomainAuthSecretArn() {
            return domainAuthSecretArn;
        }

        public final void setDomainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
        }

        @Override
        public final Builder domainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
            return this;
        }

        public final Collection<String> getDomainDnsIps() {
            if (domainDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return domainDnsIps;
        }

        public final void setDomainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
        }

        @Override
        public final Builder domainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDnsIps(String... domainDnsIps) {
            domainDnsIps(Arrays.asList(domainDnsIps));
            return this;
        }

        public final String getReplicaMode() {
            return replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final String getCustomIamInstanceProfile() {
            return customIamInstanceProfile;
        }

        public final void setCustomIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
        }

        @Override
        public final Builder customIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Integer getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return enableCustomerOwnedIp;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final String getBackupTarget() {
            return backupTarget;
        }

        public final void setBackupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
        }

        @Override
        public final Builder backupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final Boolean getUpgradeStorageConfig() {
            return upgradeStorageConfig;
        }

        public final void setUpgradeStorageConfig(Boolean upgradeStorageConfig) {
            this.upgradeStorageConfig = upgradeStorageConfig;
        }

        @Override
        public final Builder upgradeStorageConfig(Boolean upgradeStorageConfig) {
            this.upgradeStorageConfig = upgradeStorageConfig;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceReadReplicaRequest build() {
            return new CreateDbInstanceReadReplicaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
