/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.Initiator;
import com.amazonaws.s3.model.Owner;
import com.amazonaws.s3.model.StorageClass;
import java.time.Instant;
import java.util.Objects;

public class MultipartUpload {
    String uploadId;
    String key;
    Instant initiated;
    StorageClass storageClass;
    Owner owner;
    Initiator initiator;

    MultipartUpload() {
        this.uploadId = "";
        this.key = "";
        this.initiated = null;
        this.storageClass = null;
        this.owner = null;
        this.initiator = null;
    }

    protected MultipartUpload(BuilderImpl builder) {
        this.uploadId = builder.uploadId;
        this.key = builder.key;
        this.initiated = builder.initiated;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
        this.initiator = builder.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(MultipartUpload.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof MultipartUpload;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String key() {
        return this.key;
    }

    public Instant initiated() {
        return this.initiated;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Initiator initiator() {
        return this.initiator;
    }

    protected static class BuilderImpl
    implements Builder {
        String uploadId;
        String key;
        Instant initiated;
        StorageClass storageClass;
        Owner owner;
        Initiator initiator;

        protected BuilderImpl() {
        }

        private BuilderImpl(MultipartUpload model) {
            this.uploadId(model.uploadId);
            this.key(model.key);
            this.initiated(model.initiated);
            this.storageClass(model.storageClass);
            this.owner(model.owner);
            this.initiator(model.initiator);
        }

        @Override
        public MultipartUpload build() {
            return new MultipartUpload(this);
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder initiated(Instant initiated) {
            this.initiated = initiated;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String uploadId() {
            return this.uploadId;
        }

        public String key() {
            return this.key;
        }

        public Instant initiated() {
            return this.initiated;
        }

        public StorageClass storageClass() {
            return this.storageClass;
        }

        public Owner owner() {
            return this.owner;
        }

        public Initiator initiator() {
            return this.initiator;
        }
    }

    public static interface Builder {
        public Builder uploadId(String var1);

        public Builder key(String var1);

        public Builder initiated(Instant var1);

        public Builder storageClass(StorageClass var1);

        public Builder owner(Owner var1);

        public Builder initiator(Initiator var1);

        public MultipartUpload build();
    }
}

