/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import pl.project13.maven.git.SmallFilesUtil;

public class GitCommitIdMojo
extends AbstractMojo {
    private static final int DEFAULT_COMMIT_ABBREV_LENGTH = 7;
    public final String BRANCH = "branch";
    public final String COMMIT_ID = "commit.id";
    public final String COMMIT_ID_ABBREV = "commit.id.abbrev";
    public final String BUILD_AUTHOR_NAME = "build.user.name";
    public final String BUILD_AUTHOR_EMAIL = "build.user.email";
    public final String BUILD_TIME = "build.time";
    public final String COMMIT_AUTHOR_NAME = "commit.user.name";
    public final String COMMIT_AUTHOR_EMAIL = "commit.user.email";
    public final String COMMIT_MESSAGE_FULL = "commit.message.full";
    public final String COMMIT_MESSAGE_SHORT = "commit.message.short";
    public final String COMMIT_TIME = "commit.time";
    MavenProject project;
    private boolean verbose;
    private boolean generateGitPropertiesFile;
    private String generateGitPropertiesFilename;
    private File dotGitDirectory;
    private String prefix;
    private String prefixDot;
    private String dateFormat;
    private Properties properties;
    public final String logPrefix = "[GitCommitIdMojo] ";
    boolean runningTests = false;

    public void execute() throws MojoExecutionException {
        this.dotGitDirectory = this.lookupGitDirectory();
        this.log("Running on '" + this.dotGitDirectory.getAbsolutePath() + "' repository...");
        if (this.isPomProject(this.project)) {
            this.log("Skipping the execution as it is a project with packaging type: 'pom'");
            return;
        }
        try {
            this.properties = this.initProperties();
            this.prefixDot = this.prefix + ".";
            this.loadGitData(this.properties);
            this.loadBuildTimeData(this.properties);
            if (this.generateGitPropertiesFile) {
                this.generatePropertiesFile(this.properties, this.generateGitPropertiesFilename);
            }
            this.logProperties(this.properties);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not complete Mojo execution...", (Exception)e);
        }
        this.log("Finished running.");
    }

    private File lookupGitDirectory() throws MojoExecutionException {
        if (this.dotGitDirectory == null || !this.dotGitDirectory.exists()) {
            if (this.project == null) {
                this.dotGitDirectory = new File(".git");
                if (this.dotGitDirectory.exists() && this.dotGitDirectory.isDirectory()) {
                    return this.dotGitDirectory;
                }
            }
            for (MavenProject mavenProject = this.project; mavenProject != null; mavenProject = mavenProject.getParent()) {
                this.dotGitDirectory = new File(mavenProject.getBasedir(), ".git");
                if (this.dotGitDirectory.exists() && this.dotGitDirectory.isDirectory()) {
                    return this.dotGitDirectory;
                }
                if (mavenProject.getParent() != null || mavenProject.getBasedir() == null) continue;
                this.dotGitDirectory = new File(mavenProject.getBasedir().getParentFile(), ".git");
                if (!this.dotGitDirectory.exists() || !this.dotGitDirectory.isDirectory()) continue;
                return this.dotGitDirectory;
            }
            throw new MojoExecutionException("Could not find .git directory. Please specify a valid dotGitDirectory in your pom.xml");
        }
        return this.dotGitDirectory;
    }

    private Properties initProperties() throws MojoExecutionException {
        this.log("Initializing properties...");
        if (this.generateGitPropertiesFile) {
            this.log("Using clean properties...");
            this.properties = new Properties();
            return this.properties;
        }
        if (!this.runningTests) {
            this.log("Using maven project properties...");
            this.properties = this.project.getProperties();
            return this.properties;
        }
        this.properties = new Properties();
        return this.properties;
    }

    private void logProperties(Properties properties) {
        this.log("------------------git properties loaded------------------");
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!keyString.startsWith(this.prefix)) continue;
            this.log(String.format("%s = %s", key, properties.getProperty(keyString)));
        }
        this.log("---------------------------------------------------------");
    }

    void loadBuildTimeData(Properties properties) {
        Date commitDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        this.put(properties, this.prefixDot + "build.time", smf.format(commitDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadGitData(Properties properties) throws IOException, MojoExecutionException {
        this.log("Loading data from git repository...");
        Repository git = this.getGitRepository();
        int abbrevLength = 7;
        StoredConfig config = git.getConfig();
        if (config != null) {
            abbrevLength = config.getInt("core", "abbrev", 7);
        }
        String userName = git.getConfig().getString("user", null, "name");
        this.put(properties, this.prefixDot + "build.user.name", userName);
        String userEmail = git.getConfig().getString("user", null, "email");
        this.put(properties, this.prefixDot + "build.user.email", userEmail);
        Ref HEAD = git.getRef("HEAD");
        if (HEAD == null) {
            throw new MojoExecutionException("Could not get HEAD Ref, are you sure you've set the dotGitDirectory property of this plugin to a valid path?");
        }
        RevWalk revWalk = new RevWalk(git);
        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)HEAD.getObjectId());
        revWalk.markStart(headCommit);
        try {
            String branch = git.getBranch();
            this.put(properties, this.prefixDot + "branch", branch);
            this.put(properties, this.prefixDot + "commit.id", headCommit.getName());
            this.put(properties, this.prefixDot + "commit.id.abbrev", headCommit.getName().substring(0, abbrevLength));
            String commitAuthor = headCommit.getAuthorIdent().getName();
            this.put(properties, this.prefixDot + "commit.user.name", commitAuthor);
            String commitEmail = headCommit.getAuthorIdent().getEmailAddress();
            this.put(properties, this.prefixDot + "commit.user.email", commitEmail);
            String fullMessage = headCommit.getFullMessage();
            this.put(properties, this.prefixDot + "commit.message.full", fullMessage);
            String shortMessage = headCommit.getShortMessage();
            this.put(properties, this.prefixDot + "commit.message.short", shortMessage);
            long timeSinceEpoch = headCommit.getCommitTime();
            Date commitDate = new Date(timeSinceEpoch * 1000L);
            SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
            this.put(properties, this.prefixDot + "commit.time", smf.format(commitDate));
        }
        finally {
            revWalk.dispose();
        }
    }

    void generatePropertiesFile(Properties properties, String generateGitPropertiesFilename) throws IOException {
        String filename = this.project.getBasedir().getAbsolutePath() + File.separatorChar + generateGitPropertiesFilename;
        File gitPropsFile = new File(filename);
        SmallFilesUtil.createParentDirs(gitPropsFile);
        properties.store(new FileWriter(gitPropsFile), "Generated by Git-Commit-Id-Plugin");
    }

    boolean isPomProject(MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    private Repository getGitRepository() throws MojoExecutionException {
        FileRepository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize repository...", (Exception)e);
        }
        if (repository == null) {
            throw new MojoExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    private void put(Properties properties, String key, String value) {
        if (this.verbose) {
            String s = "Storing: " + key + " = " + value;
            this.log(s);
        }
        if (this.isNotEmpty(value)) {
            properties.put(key, value);
        } else {
            properties.put(key, "Unknown");
        }
    }

    private boolean isNotEmpty(String value) {
        return null != value && !" ".equals(value.trim().replaceAll(" ", ""));
    }

    void log(String message) {
        this.getLog().info((CharSequence)("[GitCommitIdMojo] " + message));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

