/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.comet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zkmax.ui.comet.CometAuWriter;
import org.zkoss.zkmax.ui.comet.CometServerPush;

class CometProcessor
implements AuProcessor {
    private CometProcessor() {
    }

    static void init(WebApp wapp) {
        if (DHtmlUpdateServlet.getAuProcessor((WebApp)wapp, (String)"/comet") == null) {
            DHtmlUpdateServlet.addAuProcessor((WebApp)wapp, (String)"/comet", (AuProcessor)new CometProcessor());
        }
    }

    public void process(Session sess, ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        SessionCtrl sessCtrl = (SessionCtrl)sess;
        sessCtrl.notifyClientRequest(false);
        this.process0(sess, request, response);
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    private void process0(Session sess, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dtid = request.getParameter("dtid");
        if (dtid == null || dtid.length() == 0) {
            response.setHeader("ZK-Comet-Error", "dtid is required");
            return;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            response.setHeader("ZK-Comet-Error", "Desktop not found, " + dtid);
            return;
        }
        DesktopCtrl desktopCtrl = (DesktopCtrl)desktop;
        ServerPush sp = desktopCtrl.getServerPush();
        if (!(sp instanceof CometServerPush)) {
            response.setHeader("ZK-Comet-Error", "Disabled");
            return;
        }
        CometServerPush cmsp = (CometServerPush)sp;
        if (cmsp.setBusy()) {
            response.setHeader("ZK-Comet-Error", "Busy");
            return;
        }
        ExecutionImpl exec = new ExecutionImpl((ServletContext)desktop.getWebApp().getNativeContext(), request, response, desktop, null);
        String sid = request.getHeader("ZK-SID");
        if (sid != null) {
            response.setHeader("ZK-SID", sid);
            ((ExecutionCtrl)exec).setRequestId(sid);
        }
        CometAuWriter out = new CometAuWriter();
        out.open(request, response, -1);
        cmsp.process((Execution)exec, out);
        out.close(request, response);
    }
}

