/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.jackson.java8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Optional;

public class JavaOptionalDeserializer
extends StdDeserializer<Optional<?>> {
    private final JavaType _referenceType;

    public JavaOptionalDeserializer(JavaType valueType) {
        super(valueType);
        this._referenceType = valueType.containedType(0);
    }

    public Optional<?> getNullValue() {
        return Optional.empty();
    }

    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object reference = ctxt.findRootValueDeserializer(this._referenceType).deserialize(jp, ctxt);
        return Optional.of(reference);
    }
}

