/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security.authentication;

import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.jakarta.servlet.http.HttpSession;
import wiremock.org.eclipse.jetty.security.Authenticator;
import wiremock.org.eclipse.jetty.security.IdentityService;
import wiremock.org.eclipse.jetty.security.LoginService;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.UserIdentity;
import wiremock.org.eclipse.jetty.server.session.Session;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        UserIdentity user = this._loginService.login(username, password, servletRequest);
        if (user != null) {
            Request request;
            this.renewSession(request, (request = Request.getBaseRequest(servletRequest)) == null ? null : request.getResponse());
            return user;
        }
        return null;
    }

    public void logout(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("wiremock.org.eclipse.jetty.security.sessionCreatedSecure");
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("wiremock.org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session) {
                        Session s2 = (Session)httpSession;
                        String oldId = s2.getId();
                        s2.renewId(request);
                        s2.setAttribute("wiremock.org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
                        if (s2.isIdChanged() && response instanceof Response) {
                            ((Response)response).replaceCookie(s2.getSessionHandler().getSessionCookie(s2, request.getContextPath(), request.isSecure()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("renew {}->{}", (Object)oldId, (Object)s2.getId());
                        }
                    } else {
                        LOG.warn("Unable to renew session {}", (Object)httpSession);
                    }
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

