/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.List;
import wiremock.net.javacrumbs.jsonunit.core.internal.ClassUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.GsonNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Jackson2NodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.JohnzonNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonOrgNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.MoshiNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.NodeFactory;

class Converter {
    static final String LIBRARIES_PROPERTY_NAME = "json-unit.libraries";
    private final List<NodeFactory> factories;
    private static final boolean jackson2Present = ClassUtils.isClassPresent("wiremock.com.fasterxml.jackson.databind.ObjectMapper") && ClassUtils.isClassPresent("wiremock.com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean gsonPresent = ClassUtils.isClassPresent("wiremock.com.google.gson.Gson");
    private static final boolean jsonOrgPresent = ClassUtils.isClassPresent("wiremock.org.json.JSONObject");
    private static final boolean moshiPresent = ClassUtils.isClassPresent("com.squareup.moshi.Moshi");
    private static final boolean johnzonPresent = ClassUtils.isClassPresent("wiremock.org.apache.johnzon.mapper.Mapper");

    Converter(List<NodeFactory> factories) {
        if (factories.isEmpty()) {
            throw new IllegalStateException("List of factories can not be empty");
        }
        this.factories = factories;
    }

    static Converter createDefaultConverter() {
        String property = System.getProperty(LIBRARIES_PROPERTY_NAME);
        List<NodeFactory> factories = property != null && property.trim().length() > 0 ? Converter.createFactoriesSpecifiedInProperty(property) : Converter.createDefaultFactories();
        if (factories.isEmpty()) {
            throw new IllegalStateException("Please add either json.org, Jackson 1.x, Jackson 2.x, Johnzon or Gson to the classpath");
        }
        return new Converter(factories);
    }

    private static List<NodeFactory> createFactoriesSpecifiedInProperty(String property) {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        block14: for (String factoryName : property.toLowerCase().split(",")) {
            switch (factoryName = factoryName.trim()) {
                case "moshi": {
                    factories.add(new MoshiNodeFactory());
                    continue block14;
                }
                case "json.org": {
                    factories.add(new JsonOrgNodeFactory());
                    continue block14;
                }
                case "jackson2": {
                    factories.add(new Jackson2NodeFactory());
                    continue block14;
                }
                case "gson": {
                    factories.add(new GsonNodeFactory());
                    continue block14;
                }
                case "johnzon": {
                    factories.add(new JohnzonNodeFactory());
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("'" + factoryName + "' library name not recognized.");
                }
            }
        }
        return factories;
    }

    private static List<NodeFactory> createDefaultFactories() {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        if (moshiPresent) {
            factories.add(new MoshiNodeFactory());
        }
        if (johnzonPresent) {
            factories.add(new JohnzonNodeFactory());
        }
        if (jsonOrgPresent) {
            factories.add(new JsonOrgNodeFactory());
        }
        if (gsonPresent) {
            factories.add(new GsonNodeFactory());
        }
        if (jackson2Present) {
            factories.add(new Jackson2NodeFactory());
        }
        return factories;
    }

    Node convertToNode(Object source, String label, boolean lenient) {
        for (int i = 0; i < this.factories.size(); ++i) {
            NodeFactory factory = this.factories.get(i);
            if (!this.isLastFactory(i) && !factory.isPreferredFor(source)) continue;
            return factory.convertToNode(source, label, lenient);
        }
        throw new IllegalStateException("Should not happen");
    }

    Node valueToNode(Object source) {
        for (int i = 0; i < this.factories.size(); ++i) {
            NodeFactory factory = this.factories.get(i);
            if (!this.isLastFactory(i) && !factory.isPreferredFor(source)) continue;
            return factory.valueToNode(source);
        }
        throw new IllegalStateException("Should not happen");
    }

    private boolean isLastFactory(int i) {
        return this.factories.size() - 1 == i;
    }

    List<NodeFactory> getFactories() {
        return this.factories;
    }
}

