/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;
import wiremock.com.ethlo.time.Field;
import wiremock.com.ethlo.time.TimezoneOffset;
import wiremock.com.ethlo.time.internal.EthloITU;
import wiremock.com.ethlo.time.internal.LimitedCharArrayIntegerUtil;

public class DateTime {
    private final Field field;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int nano;
    private final TimezoneOffset offset;
    private final int fractionDigits;

    public DateTime(Field field, int year, int month, int day, int hour, int minute, int second, int nano, TimezoneOffset offset, int fractionDigits) {
        this.field = field;
        this.year = year;
        this.month = this.assertSize(month, 1, 12, Field.MONTH);
        this.day = this.assertSize(day, 1, 31, Field.DAY);
        this.hour = this.assertSize(hour, 0, 23, Field.HOUR);
        this.minute = this.assertSize(minute, 0, 59, Field.MINUTE);
        this.second = this.assertSize(second, 0, 60, Field.SECOND);
        this.nano = this.assertSize(nano, 0, 999999999, Field.NANO);
        this.offset = offset;
        this.fractionDigits = fractionDigits;
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, int second, TimezoneOffset offset) {
        return new DateTime(Field.SECOND, year, month, day, hour, minute, second, 0, offset, 0);
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset, int fractionDigits) {
        return new DateTime(Field.NANO, year, month, day, hour, minute, second, nanos, offset, fractionDigits);
    }

    public static DateTime ofYear(int year) {
        return new DateTime(Field.YEAR, year, 0, 0, 0, 0, 0, 0, null, 0);
    }

    public static DateTime ofYearMonth(int years, int months) {
        return new DateTime(Field.MONTH, years, months, 0, 0, 0, 0, 0, null, 0);
    }

    public static DateTime ofDate(int years, int months, int days) {
        return new DateTime(Field.DAY, years, months, days, 0, 0, 0, 0, null, 0);
    }

    public static DateTime of(int years, int months, int days, int hours, int minute, TimezoneOffset offset) {
        return new DateTime(Field.MINUTE, years, months, days, hours, minute, 0, 0, offset, 0);
    }

    public static DateTime of(OffsetDateTime dateTime) {
        return DateTime.of(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano(), TimezoneOffset.of(dateTime.getOffset()), 9);
    }

    private int assertSize(int value, int min2, int max, Field field) {
        if (value > max) {
            throw new DateTimeException("Field " + field.name() + " out of bounds. Expected " + min2 + "-" + max + ", got " + value);
        }
        return value;
    }

    public boolean includesGranularity(Field field) {
        return field.ordinal() <= this.field.ordinal();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNano() {
        return this.nano;
    }

    public Optional<TimezoneOffset> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Year toYear() {
        return Year.of(this.year);
    }

    public YearMonth toYearMonth() {
        this.assertMinGranularity(Field.MONTH);
        return YearMonth.of(this.year, this.month);
    }

    public LocalDateTime toLocalDatetime() {
        this.assertMinGranularity(Field.MINUTE);
        return LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano);
    }

    public OffsetDateTime toOffsetDatetime() {
        this.assertMinGranularity(Field.MINUTE);
        if (this.offset != null) {
            return OffsetDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano, this.offset.toZoneOffset());
        }
        throw new DateTimeException("No zone offset information found");
    }

    public LocalDate toLocalDate() {
        this.assertMinGranularity(Field.DAY);
        return LocalDate.of(this.year, this.month, this.day);
    }

    public Field getMostGranularField() {
        return this.field;
    }

    private void assertMinGranularity(Field field) {
        if (!this.includesGranularity(field)) {
            throw new DateTimeException("No " + field.name() + " field found");
        }
    }

    public String toString(Field lastIncluded) {
        return this.toString(this, lastIncluded, 0);
    }

    public String toString(int fractionDigits) {
        return this.toString(this, Field.NANO, fractionDigits);
    }

    private String toString(DateTime date, Field lastIncluded, int fractionDigits) {
        if (lastIncluded.ordinal() > date.getMostGranularField().ordinal()) {
            throw new DateTimeException("Requested granularity was " + lastIncluded.name() + ", but contains only granularity " + date.getMostGranularField().name());
        }
        TimezoneOffset tz = date.getOffset().orElse(null);
        char[] buffer = new char[35];
        LimitedCharArrayIntegerUtil.toString(date.getYear(), buffer, 0, 4);
        if (lastIncluded == Field.YEAR) {
            return EthloITU.finish(buffer, Field.YEAR.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.MONTH.ordinal()) {
            buffer[4] = 45;
            LimitedCharArrayIntegerUtil.toString(date.getMonth(), buffer, 5, 2);
        }
        if (lastIncluded == Field.MONTH) {
            return EthloITU.finish(buffer, Field.MONTH.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.DAY.ordinal()) {
            buffer[7] = 45;
            LimitedCharArrayIntegerUtil.toString(date.getDayOfMonth(), buffer, 8, 2);
        }
        if (lastIncluded == Field.DAY) {
            return EthloITU.finish(buffer, Field.DAY.getRequiredLength(), null);
        }
        if (lastIncluded.ordinal() >= Field.HOUR.ordinal()) {
            buffer[10] = 84;
            LimitedCharArrayIntegerUtil.toString(date.getHour(), buffer, 11, 2);
        }
        if (lastIncluded == Field.HOUR) {
            return EthloITU.finish(buffer, Field.HOUR.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.MINUTE.ordinal()) {
            buffer[13] = 58;
            LimitedCharArrayIntegerUtil.toString(date.getMinute(), buffer, 14, 2);
        }
        if (lastIncluded == Field.MINUTE) {
            return EthloITU.finish(buffer, Field.MINUTE.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.SECOND.ordinal()) {
            buffer[16] = 58;
            LimitedCharArrayIntegerUtil.toString(date.getSecond(), buffer, 17, 2);
        }
        if (lastIncluded == Field.SECOND) {
            return EthloITU.finish(buffer, Field.SECOND.getRequiredLength(), tz);
        }
        if (lastIncluded.ordinal() >= Field.NANO.ordinal()) {
            buffer[19] = 46;
            LimitedCharArrayIntegerUtil.toString(date.getNano(), buffer, 20, fractionDigits);
        }
        return EthloITU.finish(buffer, 20 + fractionDigits, tz);
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public String toString() {
        return this.fractionDigits > 0 ? this.toString(this.fractionDigits) : this.toString(this.field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        return this.year == dateTime.year && this.month == dateTime.month && this.day == dateTime.day && this.hour == dateTime.hour && this.minute == dateTime.minute && this.second == dateTime.second && this.nano == dateTime.nano && this.fractionDigits == dateTime.fractionDigits && this.field == dateTime.field && Objects.equals(this.offset, dateTime.offset);
    }

    public int hashCode() {
        return Objects.hash(this.field.ordinal(), this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano, this.offset, this.fractionDigits);
    }
}

