/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.protobuf;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ProtobufHttpMessageConverter
extends AbstractHttpMessageConverter<Message> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final MediaType PROTOBUF = new MediaType("application", "x-protobuf", DEFAULT_CHARSET);
    public static final MediaType PLUS_PROTOBUF = new MediaType("application", "*+x-protobuf", DEFAULT_CHARSET);
    public static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    public static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final boolean PROTOBUF_JSON_FORMAT_PRESENT = ClassUtils.isPresent((String)"com.google.protobuf.util.JsonFormat", (ClassLoader)ProtobufHttpMessageConverter.class.getClassLoader());
    private static final Map<Class<?>, Method> methodCache = new ConcurrentReferenceHashMap();
    final ExtensionRegistry extensionRegistry;
    private final @Nullable ProtobufFormatDelegate protobufFormatDelegate;

    public ProtobufHttpMessageConverter() {
        this((ProtobufFormatDelegate)null, (ExtensionRegistry)null);
    }

    public ProtobufHttpMessageConverter(ExtensionRegistry extensionRegistry) {
        this(null, extensionRegistry);
    }

    protected ProtobufHttpMessageConverter(@Nullable ProtobufFormatDelegate formatDelegate, @Nullable ExtensionRegistry extensionRegistry) {
        MediaType[] mediaTypeArray;
        this.protobufFormatDelegate = formatDelegate != null ? formatDelegate : (PROTOBUF_JSON_FORMAT_PRESENT ? new ProtobufJavaUtilDelegate(null, null) : null);
        if (this.protobufFormatDelegate != null) {
            mediaTypeArray = this.protobufFormatDelegate.supportedMediaTypes();
        } else {
            MediaType[] mediaTypeArray2 = new MediaType[3];
            mediaTypeArray2[0] = PROTOBUF;
            mediaTypeArray2[1] = PLUS_PROTOBUF;
            mediaTypeArray = mediaTypeArray2;
            mediaTypeArray2[2] = MediaType.TEXT_PLAIN;
        }
        this.setSupportedMediaTypes(Arrays.asList(mediaTypeArray));
        this.extensionRegistry = extensionRegistry == null ? ExtensionRegistry.newInstance() : extensionRegistry;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    @Override
    protected MediaType getDefaultContentType(Message message) {
        return PROTOBUF;
    }

    @Override
    protected Message readInternal(Class<? extends Message> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Charset charset;
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = PROTOBUF;
        }
        if ((charset = contentType.getCharset()) == null) {
            charset = DEFAULT_CHARSET;
        }
        Message.Builder builder = this.getMessageBuilder(clazz);
        if (PROTOBUF.isCompatibleWith(contentType) || PLUS_PROTOBUF.isCompatibleWith(contentType)) {
            builder.mergeFrom(inputMessage.getBody(), (ExtensionRegistryLite)this.extensionRegistry);
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
            TextFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
        } else if (this.protobufFormatDelegate != null) {
            this.protobufFormatDelegate.merge(inputMessage, contentType, charset, builder, this.extensionRegistry);
        }
        return builder.build();
    }

    private Message.Builder getMessageBuilder(Class<? extends Message> clazz) {
        try {
            Method method = methodCache.get(clazz);
            if (method == null) {
                method = clazz.getMethod("newBuilder", new Class[0]);
                methodCache.put(clazz, method);
            }
            return (Message.Builder)method.invoke(clazz, new Object[0]);
        }
        catch (Exception ex) {
            throw new HttpMessageConversionException("Invalid Protobuf Message type: no invocable newBuilder() method on " + String.valueOf(clazz), ex);
        }
    }

    @Override
    protected boolean canWrite(@Nullable MediaType mediaType) {
        return super.canWrite(mediaType) || this.protobufFormatDelegate != null && this.protobufFormatDelegate.supportsWriteOnly(mediaType);
    }

    @Override
    protected void writeInternal(Message message, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Charset charset;
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = this.getDefaultContentType(message);
        }
        if ((charset = contentType.getCharset()) == null) {
            charset = DEFAULT_CHARSET;
        }
        if (PROTOBUF.isCompatibleWith(contentType) || PLUS_PROTOBUF.isCompatibleWith(contentType)) {
            this.setProtoHeader(outputMessage, message);
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)outputMessage.getBody());
            message.writeTo(codedOutputStream);
            codedOutputStream.flush();
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputMessage.getBody(), charset);
            TextFormat.printer().print((MessageOrBuilder)message, (Appendable)outputStreamWriter);
            outputStreamWriter.flush();
            outputMessage.getBody().flush();
        } else if (this.protobufFormatDelegate != null) {
            this.protobufFormatDelegate.print(message, outputMessage, contentType, charset);
            outputMessage.getBody().flush();
        }
    }

    private void setProtoHeader(HttpOutputMessage response, Message message) {
        response.getHeaders().set(X_PROTOBUF_SCHEMA_HEADER, message.getDescriptorForType().getFile().getName());
        response.getHeaders().set(X_PROTOBUF_MESSAGE_HEADER, message.getDescriptorForType().getFullName());
    }

    @Override
    protected boolean supportsRepeatableWrites(Message message) {
        return true;
    }

    protected static interface ProtobufFormatDelegate {
        public MediaType[] supportedMediaTypes();

        public boolean supportsWriteOnly(@Nullable MediaType var1);

        public void merge(HttpInputMessage var1, MediaType var2, Charset var3, Message.Builder var4, ExtensionRegistry var5) throws IOException, HttpMessageConversionException;

        public void print(Message var1, HttpOutputMessage var2, MediaType var3, Charset var4) throws IOException, HttpMessageConversionException;
    }

    static class ProtobufJavaUtilDelegate
    implements ProtobufFormatDelegate {
        private final JsonFormat.Parser parser;
        private final JsonFormat.Printer printer;

        public ProtobufJavaUtilDelegate(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JsonFormat.Parser parser, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JsonFormat.Printer printer) {
            this.parser = parser != null ? parser : JsonFormat.parser();
            this.printer = printer != null ? printer : JsonFormat.printer();
        }

        @Override
        public MediaType[] supportedMediaTypes() {
            return new MediaType[]{PROTOBUF, PLUS_PROTOBUF, MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON};
        }

        @Override
        public boolean supportsWriteOnly(@Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public void merge(HttpInputMessage inputMessage, MediaType contentType, Charset charset, Message.Builder builder, ExtensionRegistry extensionRegistry) throws IOException, HttpMessageConversionException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new HttpMessageConversionException("protobuf-java-util does not support parsing " + String.valueOf(contentType));
            }
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
            this.parser.merge((Reader)reader, builder);
        }

        @Override
        public void print(Message message, HttpOutputMessage outputMessage, MediaType contentType, Charset charset) throws IOException, HttpMessageConversionException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new HttpMessageConversionException("protobuf-java-util does not support printing " + String.valueOf(contentType));
            }
            OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), charset);
            this.printer.appendTo((MessageOrBuilder)message, (Appendable)writer);
            writer.flush();
        }
    }
}

