/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.context.ApplicationEvent;

public class RequestHandledEvent
extends ApplicationEvent {
    private final String requestUrl;
    private final long processingTimeMillis;
    private final String clientAddress;
    private final String method;
    private final String servletName;
    private String sessionId;
    private String userName;
    private Throwable failureCause;

    public RequestHandledEvent(Object source, String requestUrl, long processingTimeMillis, String clientAddress, String method, String servletName) {
        super(source);
        this.requestUrl = requestUrl;
        this.processingTimeMillis = processingTimeMillis;
        this.clientAddress = clientAddress;
        this.method = method;
        this.servletName = servletName;
    }

    public RequestHandledEvent(Object source, String requestUrl, long processingTimeMillis, String clientAddress, String method, String servletName, Throwable failureCause) {
        this(source, requestUrl, processingTimeMillis, clientAddress, method, servletName);
        this.failureCause = failureCause;
    }

    public RequestHandledEvent(Object source, String requestUrl, long processingTimeMillis, String clientAddress, String method, String servletName, String sessionId, String userName) {
        this(source, requestUrl, processingTimeMillis, clientAddress, method, servletName);
        this.sessionId = sessionId;
        this.userName = userName;
    }

    public RequestHandledEvent(Object source, String requestUrl, long processingTimeMillis, String clientAddress, String method, String servletName, String sessionId, String userName, Throwable failureCause) {
        this(source, requestUrl, processingTimeMillis, clientAddress, method, servletName, sessionId, userName);
        this.failureCause = failureCause;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean wasFailure() {
        return this.failureCause != null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestHandledEvent: ");
        sb.append("url=[").append(this.requestUrl).append("]; ");
        sb.append("time=[").append(this.processingTimeMillis).append("ms]; ");
        sb.append("client=[").append(this.clientAddress).append("]; ");
        sb.append("method=[").append(this.method).append("]; ");
        sb.append("servlet=[").append(this.servletName).append("]; ");
        sb.append("session=[").append(this.sessionId).append("]; ");
        sb.append("user=[").append(this.userName).append("]; ");
        sb.append("status=[");
        if (!this.wasFailure()) {
            sb.append("OK");
        } else {
            sb.append("failed: ").append(this.failureCause);
        }
        sb.append(']');
        return sb.toString();
    }
}

