/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.object.MappingSqlQuery;

public class SqlFunction<T>
extends MappingSqlQuery<T> {
    private final SingleColumnRowMapper<T> rowMapper = new SingleColumnRowMapper();

    public SqlFunction() {
    }

    public SqlFunction(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public SqlFunction(DataSource ds, String sql, int[] types) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
    }

    public SqlFunction(DataSource ds, String sql, int[] types, Class<T> resultType) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setResultType(resultType);
    }

    public void setResultType(Class<T> resultType) {
        this.rowMapper.setRequiredType(resultType);
    }

    @Override
    protected @Nullable T mapRow(ResultSet rs, int rowNum) throws SQLException {
        return this.rowMapper.mapRow(rs, rowNum);
    }

    public int run() {
        return this.run(new Object[0]);
    }

    public int run(int parameter) {
        return this.run(new Object[]{parameter});
    }

    public int run(Object ... parameters) {
        Object obj = super.findObject(parameters);
        if (!(obj instanceof Number)) {
            throw new TypeMismatchDataAccessException("Could not convert result object [" + String.valueOf(obj) + "] to int");
        }
        Number number = (Number)obj;
        return number.intValue();
    }

    public @Nullable Object runGeneric() {
        return this.findObject((Object[])null, null);
    }

    public @Nullable Object runGeneric(int parameter) {
        return this.findObject(parameter);
    }

    public @Nullable Object runGeneric(Object[] parameters) {
        return this.findObject(parameters);
    }
}

