/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.social.facebook.api.AgeRange;
import org.springframework.social.facebook.api.EducationEntry;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.WorkEntry;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class FacebookProfileMixin
extends FacebookObjectMixin {
    @JsonProperty(value="middle_name")
    String middleName;
    @JsonProperty(value="work")
    List<WorkEntry> work;
    @JsonProperty(value="education")
    List<EducationEntry> education;
    @JsonProperty(value="email")
    String email;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="third_party_id")
    String thirdPartyId;
    @JsonProperty(value="timezone")
    Float timezone;
    @JsonProperty(value="updated_time")
    Date updatedTime;
    @JsonProperty(value="verified")
    Boolean verified;
    @JsonProperty(value="about")
    String about;
    @JsonProperty(value="bio")
    String bio;
    @JsonProperty(value="birthday")
    String birthday;
    @JsonProperty(value="location")
    Reference location;
    @JsonProperty(value="hometown")
    Reference hometown;
    @JsonProperty(value="interested_in")
    List<String> interestedIn;
    @JsonProperty(value="inspirational_people")
    List<Reference> inspirationalPeople;
    @JsonProperty(value="languages")
    List<Reference> languages;
    @JsonProperty(value="sports")
    List<Reference> sports;
    @JsonProperty(value="favorite_teams")
    List<Reference> favoriteTeams;
    @JsonProperty(value="favorite_athletes")
    List<Reference> favoriteAthletes;
    @JsonProperty(value="religion")
    String religion;
    @JsonProperty(value="political")
    String political;
    @JsonProperty(value="quotes")
    String quotes;
    @JsonProperty(value="relationship_status")
    String relationshipStatus;
    @JsonProperty(value="significant_other")
    Reference significantOther;
    @JsonProperty(value="website")
    String website;
    @JsonProperty(value="age_range")
    @JsonDeserialize(using=AgeRangeDeserializer.class)
    AgeRange ageRange;

    @JsonCreator
    FacebookProfileMixin(@JsonProperty(value="id") String id, @JsonProperty(value="username") String username, @JsonProperty(value="name") String name, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="gender") String gender, @JsonProperty(value="locale") Locale locale) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AgeRangeDeserializer
    extends JsonDeserializer<AgeRange> {
        private AgeRangeDeserializer() {
        }

        public AgeRange deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode ageRangeNode = (JsonNode)jp.readValueAs(JsonNode.class);
            JsonNode minNode = ageRangeNode.get("min");
            JsonNode maxNode = ageRangeNode.get("max");
            Integer min = minNode != null ? Integer.valueOf(minNode.asInt()) : null;
            Integer max = maxNode != null ? Integer.valueOf(maxNode.asInt()) : null;
            return AgeRange.fromMinMax(min, max);
        }
    }
}

