/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.produce.JWSSignerFactory;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.net.URL;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JWKS;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.jwt.JwtEncodingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingBiFunction;
import org.springframework.util.function.ThrowingFunction;

public final class NimbusJwtEncoder
implements JwtEncoder {
    private static final String ENCODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to encode the Jwt: %s";
    private static final JwsHeader DEFAULT_JWS_HEADER = JwsHeader.with(SignatureAlgorithm.RS256).build();
    private static final JWSSignerFactory JWS_SIGNER_FACTORY = new DefaultJWSSignerFactory();
    private final JwsHeader defaultJwsHeader;
    private final Map<JWK, JWSSigner> jwsSigners = new ConcurrentHashMap<JWK, JWSSigner>();
    private final JWKSource<SecurityContext> jwkSource;
    private Converter<List<JWK>, JWK> jwkSelector = jwks -> {
        throw new JwtEncodingException(String.format("Failed to select a key since there are multiple for the signing algorithm [%s]; please specify a selector in NimbusJwsEncoder#setJwkSelector", ((JWK)jwks.get(0)).getAlgorithm()));
    };

    public NimbusJwtEncoder(JWKSource<SecurityContext> jwkSource) {
        this.defaultJwsHeader = DEFAULT_JWS_HEADER;
        Assert.notNull(jwkSource, (String)"jwkSource cannot be null");
        this.jwkSource = jwkSource;
    }

    private NimbusJwtEncoder(JWK jwk) {
        Base64URL thumbprint;
        List certs;
        Assert.notNull((Object)jwk, (String)"jwk cannot be null");
        this.jwkSource = new ImmutableJWKSet(new JWKSet(jwk));
        Enum algorithm = SignatureAlgorithm.from(jwk.getAlgorithm().getName());
        if (algorithm == null) {
            algorithm = MacAlgorithm.from(jwk.getAlgorithm().getName());
        }
        Assert.notNull((Object)algorithm, (String)("Failed to derive supported algorithm from " + String.valueOf(jwk.getAlgorithm())));
        JwsHeader.Builder builder = (JwsHeader.Builder)((JwsHeader.Builder)JwsHeader.with(algorithm).type("JWT")).keyId(jwk.getKeyID());
        URI x509Url = jwk.getX509CertURL();
        if (x509Url != null) {
            builder.x509Url(jwk.getX509CertURL().toASCIIString());
        }
        if ((certs = jwk.getX509CertChain()) != null) {
            builder.x509CertificateChain((List)certs.stream().map(Base64::toString).toList());
        }
        if ((thumbprint = jwk.getX509CertSHA256Thumbprint()) != null) {
            builder.x509SHA256Thumbprint(thumbprint.toString());
        }
        this.defaultJwsHeader = builder.build();
    }

    public void setJwkSelector(Converter<List<JWK>, JWK> jwkSelector) {
        Assert.notNull(jwkSelector, (String)"jwkSelector cannot be null");
        this.jwkSelector = jwkSelector;
    }

    @Override
    public Jwt encode(JwtEncoderParameters parameters) throws JwtEncodingException {
        Assert.notNull((Object)parameters, (String)"parameters cannot be null");
        JwsHeader headers = parameters.getJwsHeader();
        if (headers == null) {
            headers = this.defaultJwsHeader;
        }
        JwtClaimsSet claims = parameters.getClaims();
        JWK jwk = this.selectJwk(headers);
        headers = NimbusJwtEncoder.addKeyIdentifierHeadersIfNecessary(headers, jwk);
        String jws = this.serialize(headers, claims, jwk);
        return new Jwt(jws, claims.getIssuedAt(), claims.getExpiresAt(), headers.getHeaders(), claims.getClaims());
    }

    private JWK selectJwk(JwsHeader headers) {
        List jwks;
        try {
            JWKSelector jwkSelector = new JWKSelector(NimbusJwtEncoder.createJwkMatcher(headers));
            jwks = this.jwkSource.get(jwkSelector, null);
        }
        catch (Exception ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key -> " + ex.getMessage()), ex);
        }
        if (jwks.isEmpty()) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key"));
        }
        if (jwks.size() == 1) {
            return (JWK)jwks.get(0);
        }
        return (JWK)this.jwkSelector.convert((Object)jwks);
    }

    private String serialize(JwsHeader headers, JwtClaimsSet claims, JWK jwk) {
        JWSHeader jwsHeader = NimbusJwtEncoder.convert(headers);
        JWTClaimsSet jwtClaimsSet = NimbusJwtEncoder.convert(claims);
        JWSSigner jwsSigner = this.jwsSigners.computeIfAbsent(jwk, NimbusJwtEncoder::createSigner);
        SignedJWT signedJwt = new SignedJWT(jwsHeader, jwtClaimsSet);
        try {
            signedJwt.sign(jwsSigner);
        }
        catch (JOSEException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to sign the JWT -> " + ex.getMessage()), ex);
        }
        return signedJwt.serialize();
    }

    private static JWKMatcher createJwkMatcher(JwsHeader headers) {
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)headers.getAlgorithm().getName());
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm) || JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm)) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)jwsAlgorithm)).keyID(headers.getKeyId()).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new Algorithm[]{jwsAlgorithm, null}).x509CertSHA256Thumbprint(Base64URL.from((String)headers.getX509SHA256Thumbprint())).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)jwsAlgorithm)).keyID(headers.getKeyId()).privateOnly(true).algorithms(new Algorithm[]{jwsAlgorithm, null}).build();
        }
        return null;
    }

    private static JwsHeader addKeyIdentifierHeadersIfNecessary(JwsHeader headers, JWK jwk) {
        if (StringUtils.hasText((String)headers.getKeyId()) && StringUtils.hasText((String)headers.getX509SHA256Thumbprint())) {
            return headers;
        }
        if (!StringUtils.hasText((String)jwk.getKeyID()) && jwk.getX509CertSHA256Thumbprint() == null) {
            return headers;
        }
        JwsHeader.Builder headersBuilder = JwsHeader.from(headers);
        if (!StringUtils.hasText((String)headers.getKeyId()) && StringUtils.hasText((String)jwk.getKeyID())) {
            headersBuilder.keyId(jwk.getKeyID());
        }
        if (!StringUtils.hasText((String)headers.getX509SHA256Thumbprint()) && jwk.getX509CertSHA256Thumbprint() != null) {
            headersBuilder.x509SHA256Thumbprint(jwk.getX509CertSHA256Thumbprint().toString());
        }
        return headersBuilder.build();
    }

    private static JWSSigner createSigner(JWK jwk) {
        try {
            return JWS_SIGNER_FACTORY.createJWSSigner(jwk);
        }
        catch (JOSEException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to create a JWS Signer -> " + ex.getMessage()), ex);
        }
    }

    private static JWSHeader convert(JwsHeader headers) {
        Set critical;
        String contentType;
        String type;
        String x509SHA256Thumbprint;
        String x509SHA1Thumbprint;
        List x509CertificateChain;
        String keyId;
        Map jwk;
        JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.parse((String)headers.getAlgorithm().getName()));
        if (headers.getJwkSetUrl() != null) {
            builder.jwkURL(NimbusJwtEncoder.convertAsURI("jku", headers.getJwkSetUrl()));
        }
        if (!CollectionUtils.isEmpty((Map)(jwk = headers.getJwk()))) {
            try {
                builder.jwk(JWK.parse((Map)jwk));
            }
            catch (Exception ex) {
                throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Unable to convert 'jwk' JOSE header"), ex);
            }
        }
        if (StringUtils.hasText((String)(keyId = headers.getKeyId()))) {
            builder.keyID(keyId);
        }
        if (headers.getX509Url() != null) {
            builder.x509CertURL(NimbusJwtEncoder.convertAsURI("x5u", headers.getX509Url()));
        }
        if (!CollectionUtils.isEmpty((Collection)(x509CertificateChain = headers.getX509CertificateChain()))) {
            ArrayList x5cList = new ArrayList();
            x509CertificateChain.forEach(x5c -> x5cList.add(new Base64(x5c)));
            if (!x5cList.isEmpty()) {
                builder.x509CertChain(x5cList);
            }
        }
        if (StringUtils.hasText((String)(x509SHA1Thumbprint = headers.getX509SHA1Thumbprint()))) {
            builder.x509CertThumbprint(new Base64URL(x509SHA1Thumbprint));
        }
        if (StringUtils.hasText((String)(x509SHA256Thumbprint = headers.getX509SHA256Thumbprint()))) {
            builder.x509CertSHA256Thumbprint(new Base64URL(x509SHA256Thumbprint));
        }
        if (StringUtils.hasText((String)(type = headers.getType()))) {
            builder.type(new JOSEObjectType(type));
        }
        if (StringUtils.hasText((String)(contentType = headers.getContentType()))) {
            builder.contentType(contentType);
        }
        if (!CollectionUtils.isEmpty((Collection)(critical = headers.getCritical()))) {
            builder.criticalParams(critical);
        }
        HashMap customHeaders = new HashMap();
        headers.getHeaders().forEach((name, value) -> {
            if (!JWSHeader.getRegisteredParameterNames().contains(name)) {
                customHeaders.put(name, value);
            }
        });
        if (!customHeaders.isEmpty()) {
            builder.customParams(customHeaders);
        }
        return builder.build();
    }

    private static JWTClaimsSet convert(JwtClaimsSet claims) {
        String jwtId;
        Instant issuedAt;
        Instant notBefore;
        Instant expiresAt;
        List<String> audience;
        String subject;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        Object issuer = claims.getClaim("iss");
        if (issuer != null) {
            builder.issuer(issuer.toString());
        }
        if (StringUtils.hasText((String)(subject = claims.getSubject()))) {
            builder.subject(subject);
        }
        if (!CollectionUtils.isEmpty(audience = claims.getAudience())) {
            builder.audience(audience);
        }
        if ((expiresAt = claims.getExpiresAt()) != null) {
            builder.expirationTime(Date.from(expiresAt));
        }
        if ((notBefore = claims.getNotBefore()) != null) {
            builder.notBeforeTime(Date.from(notBefore));
        }
        if ((issuedAt = claims.getIssuedAt()) != null) {
            builder.issueTime(Date.from(issuedAt));
        }
        if (StringUtils.hasText((String)(jwtId = claims.getId()))) {
            builder.jwtID(jwtId);
        }
        HashMap<String, Object> customClaims = new HashMap<String, Object>();
        claims.getClaims().forEach((name, value) -> {
            if (!JWTClaimsSet.getRegisteredNames().contains(name)) {
                customClaims.put((String)name, value);
            }
        });
        if (!customClaims.isEmpty()) {
            customClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        }
        return builder.build();
    }

    private static URI convertAsURI(String header, URL url) {
        try {
            return url.toURI();
        }
        catch (Exception ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Unable to convert '" + header + "' JOSE header to a URI"), ex);
        }
    }

    public static RsaKeyPairJwtEncoderBuilder withKeyPair(RSAPublicKey publicKey, RSAPrivateKey privateKey) {
        return new RsaKeyPairJwtEncoderBuilder(publicKey, privateKey);
    }

    public static EcKeyPairJwtEncoderBuilder withKeyPair(ECPublicKey publicKey, ECPrivateKey privateKey) {
        return new EcKeyPairJwtEncoderBuilder(publicKey, privateKey);
    }

    public static SecretKeyJwtEncoderBuilder withSecretKey(SecretKey secretKey) {
        return new SecretKeyJwtEncoderBuilder(secretKey);
    }

    public static final class RsaKeyPairJwtEncoderBuilder {
        private static final ThrowingBiFunction<RSAPublicKey, RSAPrivateKey, RSAKey.Builder> defaultKid = JWKS::signingWithRsa;
        private final RSAKey.Builder builder;

        private RsaKeyPairJwtEncoderBuilder(RSAPublicKey publicKey, RSAPrivateKey privateKey) {
            Assert.notNull((Object)publicKey, (String)"publicKey cannot be null");
            Assert.notNull((Object)privateKey, (String)"privateKey cannot be null");
            this.builder = (RSAKey.Builder)defaultKid.apply((Object)publicKey, (Object)privateKey);
        }

        public RsaKeyPairJwtEncoderBuilder algorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.builder.algorithm((Algorithm)JWSAlgorithm.parse((String)signatureAlgorithm.getName()));
            return this;
        }

        public RsaKeyPairJwtEncoderBuilder jwkPostProcessor(Consumer<RSAKey.Builder> jwkPostProcessor) {
            Assert.notNull(jwkPostProcessor, (String)"jwkPostProcessor cannot be null");
            jwkPostProcessor.accept(this.builder);
            return this;
        }

        public NimbusJwtEncoder build() {
            return new NimbusJwtEncoder((JWK)this.builder.build());
        }
    }

    public static final class EcKeyPairJwtEncoderBuilder {
        private static final ThrowingBiFunction<ECPublicKey, ECPrivateKey, ECKey.Builder> defaultKid = JWKS::signingWithEc;
        private final ECKey.Builder builder;

        private EcKeyPairJwtEncoderBuilder(ECPublicKey publicKey, ECPrivateKey privateKey) {
            Assert.notNull((Object)publicKey, (String)"publicKey cannot be null");
            Assert.notNull((Object)privateKey, (String)"privateKey cannot be null");
            Curve curve = Curve.forECParameterSpec((ECParameterSpec)publicKey.getParams());
            Assert.notNull((Object)curve, (String)"Unable to determine Curve for EC public key.");
            this.builder = (ECKey.Builder)defaultKid.apply((Object)publicKey, (Object)privateKey);
        }

        public EcKeyPairJwtEncoderBuilder jwkPostProcessor(Consumer<ECKey.Builder> jwkPostProcessor) {
            Assert.notNull(jwkPostProcessor, (String)"jwkPostProcessor cannot be null");
            jwkPostProcessor.accept(this.builder);
            return this;
        }

        public NimbusJwtEncoder build() {
            return new NimbusJwtEncoder((JWK)this.builder.build());
        }
    }

    public static final class SecretKeyJwtEncoderBuilder {
        private static final ThrowingFunction<SecretKey, OctetSequenceKey.Builder> defaultJwk = JWKS::signing;
        private final OctetSequenceKey.Builder builder;
        private final Set<JWSAlgorithm> allowedAlgorithms;

        private SecretKeyJwtEncoderBuilder(SecretKey secretKey) {
            Assert.notNull((Object)secretKey, (String)"secretKey cannot be null");
            Set<JWSAlgorithm> allowedAlgorithms = this.computeAllowedAlgorithms(secretKey);
            Assert.notEmpty(allowedAlgorithms, (String)"This key is too small for any standard JWK symmetric signing algorithm");
            this.allowedAlgorithms = allowedAlgorithms;
            this.builder = ((OctetSequenceKey.Builder)defaultJwk.apply((Object)secretKey, IllegalArgumentException::new)).algorithm((Algorithm)this.allowedAlgorithms.iterator().next());
        }

        private Set<JWSAlgorithm> computeAllowedAlgorithms(SecretKey secretKey) {
            try {
                return new MACSigner(secretKey).supportedJWSAlgorithms();
            }
            catch (JOSEException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public SecretKeyJwtEncoderBuilder algorithm(MacAlgorithm macAlgorithm) {
            Assert.notNull((Object)macAlgorithm, (String)"macAlgorithm cannot be null");
            JWSAlgorithm jws = JWSAlgorithm.parse((String)macAlgorithm.getName());
            Assert.isTrue((boolean)this.allowedAlgorithms.contains(jws), (String)String.format("This key can only support the following algorithms: [%s]", this.allowedAlgorithms));
            this.builder.algorithm((Algorithm)JWSAlgorithm.parse((String)macAlgorithm.getName()));
            return this;
        }

        public SecretKeyJwtEncoderBuilder jwkPostProcessor(Consumer<OctetSequenceKey.Builder> jwkPostProcessor) {
            Assert.notNull(jwkPostProcessor, (String)"jwkPostProcessor cannot be null");
            jwkPostProcessor.accept(this.builder);
            return this;
        }

        public NimbusJwtEncoder build() {
            return new NimbusJwtEncoder((JWK)this.builder.build());
        }
    }
}

