/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.AbstractSecurityBuilder;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.util.Assert;

public abstract class AbstractConfiguredSecurityBuilder<O, B extends SecurityBuilder<O>>
extends AbstractSecurityBuilder<O> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LinkedHashMap<Class<? extends SecurityConfigurer<O, B>>, List<SecurityConfigurer<O, B>>> configurers = new LinkedHashMap();
    private final List<SecurityConfigurer<O, B>> configurersAddedInInitializing = new ArrayList<SecurityConfigurer<O, B>>();
    private final Map<Class<?>, Object> sharedObjects = new HashMap();
    private final boolean allowConfigurersOfSameType;
    private BuildState buildState = BuildState.UNBUILT;
    private ObjectPostProcessor<Object> objectPostProcessor;

    protected AbstractConfiguredSecurityBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        this(objectPostProcessor, false);
    }

    @Deprecated(since="6.4", forRemoval=true)
    protected AbstractConfiguredSecurityBuilder(org.springframework.security.config.annotation.ObjectPostProcessor<Object> objectPostProcessor) {
        this(objectPostProcessor, false);
    }

    protected AbstractConfiguredSecurityBuilder(ObjectPostProcessor<Object> objectPostProcessor, boolean allowConfigurersOfSameType) {
        Assert.notNull(objectPostProcessor, (String)"objectPostProcessor cannot be null");
        this.objectPostProcessor = objectPostProcessor;
        this.allowConfigurersOfSameType = allowConfigurersOfSameType;
    }

    @Deprecated(since="6.4", forRemoval=true)
    protected AbstractConfiguredSecurityBuilder(org.springframework.security.config.annotation.ObjectPostProcessor<Object> objectPostProcessor, boolean allowConfigurersOfSameType) {
        Assert.notNull(objectPostProcessor, (String)"objectPostProcessor cannot be null");
        this.objectPostProcessor = objectPostProcessor;
        this.allowConfigurersOfSameType = allowConfigurersOfSameType;
    }

    public O getOrBuild() {
        if (!this.isUnbuilt()) {
            return this.getObject();
        }
        try {
            return this.build();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Failed to perform build. Returning null", (Throwable)ex);
            return null;
        }
    }

    @Deprecated(since="6.2", forRemoval=true)
    public <C extends SecurityConfigurerAdapter<O, B>> C apply(C configurer) throws Exception {
        configurer.addObjectPostProcessor(this.objectPostProcessor);
        configurer.setBuilder((AbstractConfiguredSecurityBuilder)this);
        this.add(configurer);
        return configurer;
    }

    public <C extends SecurityConfigurer<O, B>> C apply(C configurer) throws Exception {
        this.add(configurer);
        return configurer;
    }

    public <C extends SecurityConfigurerAdapter<O, B>> B with(C configurer, Customizer<C> customizer) throws Exception {
        configurer.addObjectPostProcessor(this.objectPostProcessor);
        configurer.setBuilder((AbstractConfiguredSecurityBuilder)this);
        this.add(configurer);
        customizer.customize(configurer);
        return (B)this;
    }

    public <C> void setSharedObject(Class<C> sharedType, C object) {
        this.sharedObjects.put(sharedType, object);
    }

    public <C> C getSharedObject(Class<C> sharedType) {
        return (C)this.sharedObjects.get(sharedType);
    }

    public Map<Class<?>, Object> getSharedObjects() {
        return Collections.unmodifiableMap(this.sharedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends SecurityConfigurer<O, B>> void add(C configurer) {
        Assert.notNull(configurer, (String)"configurer cannot be null");
        Class<?> clazz = configurer.getClass();
        LinkedHashMap<Class<? extends SecurityConfigurer<O, B>>, List<SecurityConfigurer<O, B>>> linkedHashMap = this.configurers;
        synchronized (linkedHashMap) {
            if (this.buildState.isConfigured()) {
                throw new IllegalStateException("Cannot apply " + String.valueOf(configurer) + " to already built object");
            }
            List<Object> configs = null;
            if (this.allowConfigurersOfSameType) {
                configs = this.configurers.get(clazz);
            }
            configs = configs != null ? configs : new ArrayList(1);
            configs.add(configurer);
            this.configurers.put(clazz, configs);
            if (this.buildState.isInitializing()) {
                this.configurersAddedInInitializing.add(configurer);
            }
        }
    }

    public <C extends SecurityConfigurer<O, B>> List<C> getConfigurers(Class<C> clazz) {
        List<SecurityConfigurer<O, B>> configs = this.configurers.get(clazz);
        if (configs == null) {
            return new ArrayList();
        }
        return new ArrayList<SecurityConfigurer<O, B>>(configs);
    }

    public <C extends SecurityConfigurer<O, B>> List<C> removeConfigurers(Class<C> clazz) {
        List configs = (List)this.configurers.remove(clazz);
        if (configs == null) {
            return new ArrayList();
        }
        this.removeFromConfigurersAddedInInitializing(clazz);
        return new ArrayList(configs);
    }

    public <C extends SecurityConfigurer<O, B>> C getConfigurer(Class<C> clazz) {
        List configs = this.configurers.get(clazz);
        if (configs == null) {
            return null;
        }
        Assert.state((configs.size() == 1 ? 1 : 0) != 0, () -> "Only one configurer expected for type " + String.valueOf(clazz) + ", but got " + String.valueOf(configs));
        return (C)configs.get(0);
    }

    public <C extends SecurityConfigurer<O, B>> C removeConfigurer(Class<C> clazz) {
        List configs = (List)this.configurers.remove(clazz);
        if (configs == null) {
            return null;
        }
        this.removeFromConfigurersAddedInInitializing(clazz);
        Assert.state((configs.size() == 1 ? 1 : 0) != 0, () -> "Only one configurer expected for type " + String.valueOf(clazz) + ", but got " + String.valueOf(configs));
        return (C)((SecurityConfigurer)configs.get(0));
    }

    private <C extends SecurityConfigurer<O, B>> void removeFromConfigurersAddedInInitializing(Class<C> clazz) {
        this.configurersAddedInInitializing.removeIf(clazz::isInstance);
    }

    public B objectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        Assert.notNull(objectPostProcessor, (String)"objectPostProcessor cannot be null");
        this.objectPostProcessor = objectPostProcessor;
        return (B)this;
    }

    protected <P> P postProcess(P object) {
        return this.objectPostProcessor.postProcess(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final O doBuild() throws Exception {
        LinkedHashMap<Class<? extends SecurityConfigurer<O, B>>, List<SecurityConfigurer<O, B>>> linkedHashMap = this.configurers;
        synchronized (linkedHashMap) {
            this.buildState = BuildState.INITIALIZING;
            this.beforeInit();
            this.init();
            this.buildState = BuildState.CONFIGURING;
            this.beforeConfigure();
            this.configure();
            this.buildState = BuildState.BUILDING;
            O result = this.performBuild();
            this.buildState = BuildState.BUILT;
            return result;
        }
    }

    protected void beforeInit() throws Exception {
    }

    protected void beforeConfigure() throws Exception {
    }

    protected abstract O performBuild() throws Exception;

    private void init() throws Exception {
        Collection<SecurityConfigurer<O, B>> configurers = this.getConfigurers();
        for (SecurityConfigurer<O, AbstractConfiguredSecurityBuilder> securityConfigurer : configurers) {
            securityConfigurer.init(this);
        }
        for (SecurityConfigurer<O, AbstractConfiguredSecurityBuilder> securityConfigurer : this.configurersAddedInInitializing) {
            securityConfigurer.init(this);
        }
    }

    private void configure() throws Exception {
        Collection<SecurityConfigurer<O, B>> configurers = this.getConfigurers();
        for (SecurityConfigurer<O, AbstractConfiguredSecurityBuilder> securityConfigurer : configurers) {
            securityConfigurer.configure(this);
        }
    }

    private Collection<SecurityConfigurer<O, B>> getConfigurers() {
        ArrayList<SecurityConfigurer<O, B>> result = new ArrayList<SecurityConfigurer<O, B>>();
        for (List<SecurityConfigurer<O, B>> configs : this.configurers.values()) {
            result.addAll(configs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnbuilt() {
        LinkedHashMap<Class<? extends SecurityConfigurer<O, B>>, List<SecurityConfigurer<O, B>>> linkedHashMap = this.configurers;
        synchronized (linkedHashMap) {
            return this.buildState == BuildState.UNBUILT;
        }
    }

    private static enum BuildState {
        UNBUILT(0),
        INITIALIZING(1),
        CONFIGURING(2),
        BUILDING(3),
        BUILT(4);

        private final int order;

        private BuildState(int order) {
            this.order = order;
        }

        public boolean isInitializing() {
            return BuildState.INITIALIZING.order == this.order;
        }

        public boolean isConfigured() {
            return this.order >= BuildState.CONFIGURING.order;
        }
    }
}

