/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.provider.token.store.jwk.EllipticCurveJwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.RsaJwkDefinition;
import org.springframework.util.StringUtils;

class JwkSetConverter
implements Converter<InputStream, Set<JwkDefinition>> {
    private final JsonFactory factory = new JsonFactory();

    JwkSetConverter() {
    }

    public Set<JwkDefinition> convert(InputStream jwkSetSource) {
        LinkedHashSet<JwkDefinition> jwkDefinitions;
        JsonParser parser = null;
        try {
            parser = this.factory.createParser(jwkSetSource);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new JwkException("Invalid JWK Set Object.");
            }
            if (parser.nextToken() != JsonToken.FIELD_NAME) {
                throw new JwkException("Invalid JWK Set Object.");
            }
            if (!parser.getCurrentName().equals("keys")) {
                throw new JwkException("Invalid JWK Set Object. The JWK Set MUST have a keys attribute.");
            }
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                throw new JwkException("Invalid JWK Set Object. The JWK Set MUST have an array of JWK(s).");
            }
            jwkDefinitions = new LinkedHashSet<JwkDefinition>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            while (parser.nextToken() == JsonToken.START_OBJECT) {
                attributes.clear();
                while (parser.nextToken() == JsonToken.FIELD_NAME) {
                    String attributeName = parser.getCurrentName();
                    if (parser.nextToken() == JsonToken.START_ARRAY) {
                        while (parser.nextToken() != JsonToken.END_ARRAY) {
                        }
                        continue;
                    }
                    attributes.put(attributeName, parser.getValueAsString());
                }
                JwkDefinition.PublicKeyUse publicKeyUse = JwkDefinition.PublicKeyUse.fromValue((String)attributes.get("use"));
                if (!JwkDefinition.PublicKeyUse.SIG.equals((Object)publicKeyUse)) continue;
                JwkDefinition jwkDefinition = null;
                JwkDefinition.KeyType keyType = JwkDefinition.KeyType.fromValue((String)attributes.get("kty"));
                if (JwkDefinition.KeyType.RSA.equals((Object)keyType)) {
                    jwkDefinition = this.createRsaJwkDefinition(attributes);
                } else if (JwkDefinition.KeyType.EC.equals((Object)keyType)) {
                    jwkDefinition = this.createEllipticCurveJwkDefinition(attributes);
                }
                if (jwkDefinition == null || jwkDefinitions.add(jwkDefinition)) continue;
                throw new JwkException("Duplicate JWK found in Set: " + jwkDefinition.getKeyId() + " (" + "kid" + ")");
            }
        }
        catch (IOException ex) {
            throw new JwkException("An I/O error occurred while reading the JWK Set: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (IOException iOException) {}
        }
        return jwkDefinitions;
    }

    private JwkDefinition createRsaJwkDefinition(Map<String, String> attributes) {
        String keyId = attributes.get("kid");
        if (!StringUtils.hasText((String)keyId)) {
            throw new JwkException("kid is a required attribute for a JWK.");
        }
        String x5t = attributes.get("x5t");
        JwkDefinition.PublicKeyUse publicKeyUse = JwkDefinition.PublicKeyUse.fromValue(attributes.get("use"));
        if (!JwkDefinition.PublicKeyUse.SIG.equals((Object)publicKeyUse)) {
            return null;
        }
        JwkDefinition.CryptoAlgorithm algorithm = JwkDefinition.CryptoAlgorithm.fromHeaderParamValue(attributes.get("alg"));
        if (!(algorithm == null || JwkDefinition.CryptoAlgorithm.RS256.equals((Object)algorithm) || JwkDefinition.CryptoAlgorithm.RS384.equals((Object)algorithm) || JwkDefinition.CryptoAlgorithm.RS512.equals((Object)algorithm))) {
            throw new JwkException(algorithm.standardName() + " (" + "alg" + ") is currently not supported.");
        }
        String modulus = attributes.get("n");
        if (!StringUtils.hasText((String)modulus)) {
            throw new JwkException("n is a required attribute for a RSA JWK.");
        }
        String exponent = attributes.get("e");
        if (!StringUtils.hasText((String)exponent)) {
            throw new JwkException("e is a required attribute for a RSA JWK.");
        }
        RsaJwkDefinition jwkDefinition = new RsaJwkDefinition(keyId, x5t, publicKeyUse, algorithm, modulus, exponent);
        return jwkDefinition;
    }

    private JwkDefinition createEllipticCurveJwkDefinition(Map<String, String> attributes) {
        String keyId = attributes.get("kid");
        if (!StringUtils.hasText((String)keyId)) {
            throw new JwkException("kid is a required attribute for an EC JWK.");
        }
        String x5t = attributes.get("x5t");
        JwkDefinition.PublicKeyUse publicKeyUse = JwkDefinition.PublicKeyUse.fromValue(attributes.get("use"));
        if (!JwkDefinition.PublicKeyUse.SIG.equals((Object)publicKeyUse)) {
            return null;
        }
        JwkDefinition.CryptoAlgorithm algorithm = JwkDefinition.CryptoAlgorithm.fromHeaderParamValue(attributes.get("alg"));
        if (!(algorithm == null || JwkDefinition.CryptoAlgorithm.ES256.equals((Object)algorithm) || JwkDefinition.CryptoAlgorithm.ES384.equals((Object)algorithm) || JwkDefinition.CryptoAlgorithm.ES512.equals((Object)algorithm))) {
            throw new JwkException(algorithm.standardName() + " (" + "alg" + ") is currently not supported.");
        }
        String x = attributes.get("x");
        if (!StringUtils.hasText((String)x)) {
            throw new JwkException("x is a required attribute for an EC JWK.");
        }
        String y = attributes.get("y");
        if (!StringUtils.hasText((String)y)) {
            throw new JwkException("y is a required attribute for an EC JWK.");
        }
        String curve = attributes.get("crv");
        if (!StringUtils.hasText((String)curve)) {
            throw new JwkException("crv is a required attribute for an EC JWK.");
        }
        EllipticCurveJwkDefinition jwkDefinition = new EllipticCurveJwkDefinition(keyId, x5t, publicKeyUse, algorithm, x, y, curve);
        return jwkDefinition;
    }
}

