/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;
import org.springframework.util.Assert;

class CopyOperation
extends PatchOperation {
    private final SpelPath.UntypedSpelPath from;

    public CopyOperation(SpelPath.UntypedSpelPath path, SpelPath.UntypedSpelPath from) {
        super("copy", path);
        this.from = from;
    }

    public static CopyOperationBuilder from(String from) {
        return new CopyOperationBuilder(from);
    }

    @Override
    void perform(Object target, Class<?> type, BindContext context) {
        this.path.bindForWrite(type, context).copyFrom(this.from, target, context);
    }

    static class CopyOperationBuilder {
        private final String from;

        public CopyOperationBuilder(String from) {
            Assert.hasText((String)from, (String)"From must not be null");
            this.from = from;
        }

        CopyOperation to(String to) {
            return new CopyOperation(SpelPath.untyped(to), SpelPath.untyped(this.from));
        }
    }
}

