/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.repository.cdi.CdiBean;
import org.springframework.util.Assert;

public class RedisKeyValueAdapterBean
extends CdiBean<RedisKeyValueAdapter> {
    private final Bean<RedisOperations<?, ?>> redisOperations;

    public RedisKeyValueAdapterBean(Bean<RedisOperations<?, ?>> redisOperations, Set<Annotation> qualifiers, BeanManager beanManager) {
        super(qualifiers, RedisKeyValueAdapter.class, beanManager);
        Assert.notNull(redisOperations);
        this.redisOperations = redisOperations;
    }

    public RedisKeyValueAdapter create(CreationalContext<RedisKeyValueAdapter> creationalContext) {
        Type beanType = this.getBeanType();
        RedisOperations<?, ?> redisOperations = this.getDependencyInstance(this.redisOperations, beanType);
        RedisKeyValueAdapter redisKeyValueAdapter = new RedisKeyValueAdapter(redisOperations);
        return redisKeyValueAdapter;
    }

    private Type getBeanType() {
        for (Type type : this.redisOperations.getTypes()) {
            ParameterizedType parameterizedType;
            if (type instanceof Class && RedisOperations.class.isAssignableFrom((Class)type)) {
                return type;
            }
            if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !RedisOperations.class.isAssignableFrom((Class)parameterizedType.getRawType())) continue;
            return type;
        }
        throw new IllegalStateException("Cannot resolve bean type for class " + RedisOperations.class.getName());
    }

    @Override
    public void destroy(RedisKeyValueAdapter instance, CreationalContext<RedisKeyValueAdapter> creationalContext) {
        if (instance instanceof DisposableBean) {
            try {
                instance.destroy();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        super.destroy(instance, creationalContext);
    }
}

