/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.convert;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.LongToBooleanConverter;
import org.springframework.data.redis.connection.convert.MapToPropertiesConverter;
import org.springframework.data.redis.connection.convert.StringToDataTypeConverter;
import org.springframework.data.redis.connection.convert.StringToPropertiesConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Converters {
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] ZERO = new byte[]{48};
    private static final String CLUSTER_NODES_LINE_SEPARATOR = "\n";
    private static final Converter<String, Properties> STRING_TO_PROPS = new StringToPropertiesConverter();
    private static final Converter<Long, Boolean> LONG_TO_BOOLEAN = new LongToBooleanConverter();
    private static final Converter<String, DataType> STRING_TO_DATA_TYPE = new StringToDataTypeConverter();
    private static final Converter<Map<?, ?>, Properties> MAP_TO_PROPERTIES = MapToPropertiesConverter.INSTANCE;
    private static final Converter<String, RedisClusterNode> STRING_TO_CLUSTER_NODE_CONVERTER;
    private static final Map<String, RedisClusterNode.Flag> flagLookupMap;

    public static Converter<String, Properties> stringToProps() {
        return STRING_TO_PROPS;
    }

    public static Converter<Long, Boolean> longToBoolean() {
        return LONG_TO_BOOLEAN;
    }

    public static Converter<String, DataType> stringToDataType() {
        return STRING_TO_DATA_TYPE;
    }

    public static Properties toProperties(String source) {
        return (Properties)STRING_TO_PROPS.convert((Object)source);
    }

    public static Properties toProperties(Map<?, ?> source) {
        return (Properties)MAP_TO_PROPERTIES.convert(source);
    }

    public static Boolean toBoolean(Long source) {
        return (Boolean)LONG_TO_BOOLEAN.convert((Object)source);
    }

    public static DataType toDataType(String source) {
        return (DataType)((Object)STRING_TO_DATA_TYPE.convert((Object)source));
    }

    public static byte[] toBit(Boolean source) {
        return source != false ? ONE : ZERO;
    }

    protected static RedisClusterNode toClusterNode(String clusterNodesLine) {
        return (RedisClusterNode)STRING_TO_CLUSTER_NODE_CONVERTER.convert((Object)clusterNodesLine);
    }

    public static Set<RedisClusterNode> toSetOfRedisClusterNodes(Collection<String> lines) {
        if (CollectionUtils.isEmpty(lines)) {
            return Collections.emptySet();
        }
        LinkedHashSet<RedisClusterNode> nodes = new LinkedHashSet<RedisClusterNode>(lines.size());
        for (String line : lines) {
            nodes.add(Converters.toClusterNode(line));
        }
        return nodes;
    }

    public static Set<RedisClusterNode> toSetOfRedisClusterNodes(String clusterNodes) {
        if (StringUtils.isEmpty((Object)clusterNodes)) {
            return Collections.emptySet();
        }
        String[] lines = clusterNodes.split(CLUSTER_NODES_LINE_SEPARATOR);
        return Converters.toSetOfRedisClusterNodes(Arrays.asList(lines));
    }

    public static List<Object> toObjects(Set<RedisZSetCommands.Tuple> tuples) {
        ArrayList<Object> tupleArgs = new ArrayList<Object>(tuples.size() * 2);
        for (RedisZSetCommands.Tuple tuple : tuples) {
            tupleArgs.add(tuple.getScore());
            tupleArgs.add(tuple.getValue());
        }
        return tupleArgs;
    }

    public static Long toTimeMillis(String seconds, String microseconds) {
        return (Long)NumberUtils.parseNumber((String)seconds, Long.class) * 1000L + (Long)NumberUtils.parseNumber((String)microseconds, Long.class) / 1000L;
    }

    public static long secondsToTimeUnit(long seconds, TimeUnit targetUnit) {
        Assert.notNull((Object)((Object)targetUnit), (String)"TimeUnit must not be null!");
        if (seconds > 0L) {
            return targetUnit.convert(seconds, TimeUnit.SECONDS);
        }
        return seconds;
    }

    public static Converter<Long, Long> secondsToTimeUnit(final TimeUnit timeUnit) {
        return new Converter<Long, Long>(){

            public Long convert(Long seconds) {
                return Converters.secondsToTimeUnit(seconds, timeUnit);
            }
        };
    }

    public static long millisecondsToTimeUnit(long milliseconds, TimeUnit targetUnit) {
        Assert.notNull((Object)((Object)targetUnit), (String)"TimeUnit must not be null!");
        if (milliseconds > 0L) {
            return targetUnit.convert(milliseconds, TimeUnit.MILLISECONDS);
        }
        return milliseconds;
    }

    public static Converter<Long, Long> millisecondsToTimeUnit(final TimeUnit timeUnit) {
        return new Converter<Long, Long>(){

            public Long convert(Long seconds) {
                return Converters.millisecondsToTimeUnit(seconds, timeUnit);
            }
        };
    }

    public static <V> Converter<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<V>>> deserializingGeoResultsConverter(RedisSerializer<V> serializer) {
        return new DeserializingGeoResultsConverter<V>(serializer);
    }

    public static Converter<Double, Distance> distanceConverterForMetric(Metric metric) {
        return DistanceConverterFactory.INSTANCE.forMetric(metric);
    }

    static {
        flagLookupMap = new LinkedHashMap<String, RedisClusterNode.Flag>(RedisClusterNode.Flag.values().length, 1.0f);
        for (RedisClusterNode.Flag flag : RedisClusterNode.Flag.values()) {
            flagLookupMap.put(flag.getRaw(), flag);
        }
        STRING_TO_CLUSTER_NODE_CONVERTER = new Converter<String, RedisClusterNode>(){
            static final int ID_INDEX = 0;
            static final int HOST_PORT_INDEX = 1;
            static final int FLAGS_INDEX = 2;
            static final int MASTER_ID_INDEX = 3;
            static final int LINK_STATE_INDEX = 7;
            static final int SLOTS_INDEX = 8;

            public RedisClusterNode convert(String source) {
                String[] args = source.split(" ");
                String[] hostAndPort = StringUtils.split((String)args[1], (String)":");
                RedisClusterNode.SlotRange range = this.parseSlotRange(args);
                Set<RedisClusterNode.Flag> flags = this.parseFlags(args);
                String portPart = hostAndPort[1];
                if (portPart.contains("@")) {
                    portPart = portPart.substring(0, portPart.indexOf(64));
                }
                RedisClusterNode.RedisClusterNodeBuilder nodeBuilder = RedisClusterNode.newRedisClusterNode().listeningAt(hostAndPort[0], Integer.valueOf(portPart)).withId(args[0]).promotedAs(flags.contains((Object)RedisClusterNode.Flag.MASTER) ? RedisNode.NodeType.MASTER : RedisNode.NodeType.SLAVE).serving(range).withFlags(flags).linkState(this.parseLinkState(args));
                if (!args[3].isEmpty() && !args[3].startsWith("-")) {
                    nodeBuilder.slaveOf(args[3]);
                }
                return nodeBuilder.build();
            }

            private Set<RedisClusterNode.Flag> parseFlags(String[] args) {
                String raw = args[2];
                LinkedHashSet<RedisClusterNode.Flag> flags = new LinkedHashSet<RedisClusterNode.Flag>(8, 1.0f);
                if (StringUtils.hasText((String)raw)) {
                    for (String flag : raw.split(",")) {
                        flags.add((RedisClusterNode.Flag)((Object)flagLookupMap.get(flag)));
                    }
                }
                return flags;
            }

            private RedisClusterNode.LinkState parseLinkState(String[] args) {
                String raw = args[7];
                if (StringUtils.hasText((String)raw)) {
                    return RedisClusterNode.LinkState.valueOf(raw.toUpperCase());
                }
                return RedisClusterNode.LinkState.DISCONNECTED;
            }

            private RedisClusterNode.SlotRange parseSlotRange(String[] args) {
                LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
                for (int i = 8; i < args.length; ++i) {
                    String raw = args[i];
                    if (raw.startsWith("[")) continue;
                    if (raw.contains("-")) {
                        String[] slotRange = StringUtils.split((String)raw, (String)"-");
                        if (slotRange == null) continue;
                        int from = Integer.valueOf(slotRange[0]);
                        int to = Integer.valueOf(slotRange[1]);
                        for (int slot = from; slot <= to; ++slot) {
                            slots.add(slot);
                        }
                        continue;
                    }
                    slots.add(Integer.valueOf(raw));
                }
                RedisClusterNode.SlotRange range = new RedisClusterNode.SlotRange(slots);
                return range;
            }
        };
    }

    static class DeserializingGeoResultsConverter<V>
    implements Converter<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<V>>> {
        final RedisSerializer<V> serializer;

        public GeoResults<RedisGeoCommands.GeoLocation<V>> convert(GeoResults<RedisGeoCommands.GeoLocation<byte[]>> source) {
            if (source == null) {
                return new GeoResults(Collections.emptyList());
            }
            ArrayList<GeoResult> values = new ArrayList<GeoResult>(source.getContent().size());
            for (GeoResult value : source.getContent()) {
                values.add(new GeoResult(new RedisGeoCommands.GeoLocation<V>(this.serializer.deserialize((byte[])((RedisGeoCommands.GeoLocation)value.getContent()).getName()), ((RedisGeoCommands.GeoLocation)value.getContent()).getPoint()), value.getDistance()));
            }
            return new GeoResults(values, source.getAverageDistance().getMetric());
        }

        @ConstructorProperties(value={"serializer"})
        public DeserializingGeoResultsConverter(RedisSerializer<V> serializer) {
            this.serializer = serializer;
        }
    }

    static enum DistanceConverterFactory {
        INSTANCE;


        DistanceConverter forMetric(Metric metric) {
            return new DistanceConverter(metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric);
        }

        static class DistanceConverter
        implements Converter<Double, Distance> {
            private Metric metric;

            public DistanceConverter(Metric metric) {
                this.metric = metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric;
            }

            public Distance convert(Double source) {
                return source == null ? null : new Distance(source.doubleValue(), this.metric);
            }
        }
    }
}

