/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.BooleanOutput;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.output.DateOutput;
import com.lambdaworks.redis.output.DoubleOutput;
import com.lambdaworks.redis.output.IntegerOutput;
import com.lambdaworks.redis.output.KeyListOutput;
import com.lambdaworks.redis.output.KeyValueOutput;
import com.lambdaworks.redis.output.MapOutput;
import com.lambdaworks.redis.output.MultiOutput;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.output.ValueListOutput;
import com.lambdaworks.redis.output.ValueOutput;
import com.lambdaworks.redis.output.ValueSetOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.lettuce.BytesRedisCodec;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.connection.lettuce.LettuceSubscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.RedisCommand;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class LettuceConnection
extends AbstractRedisConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    static final RedisCodec<byte[], byte[]> CODEC = new BytesRedisCodec();
    private static final TypeHints typeHints = new TypeHints();
    private final RedisAsyncConnection<byte[], byte[]> asyncSharedConn;
    private final RedisConnection<byte[], byte[]> sharedConn;
    private RedisAsyncConnection<byte[], byte[]> asyncDedicatedConn;
    private RedisConnection<byte[], byte[]> dedicatedConn;
    private final long timeout;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean isPipelined = false;
    private List<LettuceResult> ppline;
    private Queue<FutureResult<?>> txResults = new LinkedList();
    private RedisClient client;
    private volatile LettuceSubscription subscription;
    private LettucePool pool;
    private boolean broken = false;
    private boolean convertPipelineAndTxResults = true;

    public LettuceConnection(long timeout, RedisClient client) {
        this(null, timeout, client, null);
    }

    public LettuceConnection(long timeout, RedisClient client, LettucePool pool) {
        this(null, timeout, client, pool);
    }

    public LettuceConnection(RedisAsyncConnection<byte[], byte[]> sharedConnection, long timeout, RedisClient client) {
        this(sharedConnection, timeout, client, null);
    }

    public LettuceConnection(RedisAsyncConnection<byte[], byte[]> sharedConnection, long timeout, RedisClient client, LettucePool pool) {
        this.asyncSharedConn = sharedConnection;
        this.timeout = timeout;
        this.sharedConn = sharedConnection != null ? new RedisConnection(this.asyncSharedConn) : null;
        this.client = client;
        this.pool = pool;
    }

    protected DataAccessException convertLettuceAccessException(Exception ex) {
        DataAccessException exception = EXCEPTION_TRANSLATION.translate(ex);
        if (exception instanceof RedisConnectionFailureException) {
            this.broken = true;
        }
        return exception;
    }

    private Object await(Command cmd) {
        if (this.isMulti && cmd.type != CommandType.MULTI) {
            return null;
        }
        return this.getAsyncConnection().await(cmd, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        return this.execute(command, (CommandOutput)null, args);
    }

    public Object execute(String command, CommandOutput commandOutputTypeHint, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            CommandOutput expectedOutput;
            String name = command.trim().toUpperCase();
            CommandType cmd = CommandType.valueOf((String)name);
            this.validateCommandIfRunningInTransactionMode(cmd, args);
            CommandArgs cmdArg = new CommandArgs(CODEC);
            if (!ObjectUtils.isEmpty((Object[])args)) {
                cmdArg.addKeys((Object[])args);
            }
            CommandOutput commandOutput = expectedOutput = commandOutputTypeHint != null ? commandOutputTypeHint : typeHints.getTypeHint(cmd);
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult((Future)this.getAsyncConnection().dispatch(cmd, expectedOutput, cmdArg)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getAsyncConnection().dispatch(cmd, expectedOutput, cmdArg)));
                return null;
            }
            return this.await(this.getAsyncConnection().dispatch(cmd, expectedOutput, cmdArg));
        }
        catch (RedisException ex) {
            throw this.convertLettuceAccessException((Exception)((Object)ex));
        }
    }

    private void returnDedicatedAsyncConnection() {
        if (this.pool != null) {
            if (!this.broken) {
                this.pool.returnResource(this.asyncDedicatedConn);
            } else {
                this.pool.returnBrokenResource(this.asyncDedicatedConn);
            }
            this.asyncDedicatedConn = null;
        } else {
            try {
                this.asyncDedicatedConn.close();
            }
            catch (RuntimeException ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        this.isClosed = true;
        if (this.asyncDedicatedConn != null) {
            this.returnDedicatedAsyncConnection();
        }
        if (this.subscription != null) {
            if (this.subscription.isAlive()) {
                this.subscription.doClose();
            }
            this.subscription = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed && !this.isSubscribed();
    }

    public RedisAsyncConnection<byte[], byte[]> getNativeConnection() {
        return this.subscription != null ? this.subscription.pubsub : this.getAsyncConnection();
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.isPipelined;
    }

    @Override
    public void openPipeline() {
        if (!this.isPipelined) {
            this.isPipelined = true;
            this.ppline = new ArrayList<LettuceResult>();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.isPipelined) {
            this.isPipelined = false;
            ArrayList futures = new ArrayList();
            for (LettuceResult result : this.ppline) {
                futures.add(result.getResultHolder());
            }
            boolean done = this.getAsyncConnection().awaitAll((Future[])futures.toArray(new Command[futures.size()]));
            ArrayList<Object> results = new ArrayList<Object>(futures.size());
            DataAccessException problem = null;
            if (done) {
                for (LettuceResult result : this.ppline) {
                    if (((Command)result.getResultHolder()).getOutput().hasError()) {
                        InvalidDataAccessApiUsageException err = new InvalidDataAccessApiUsageException(((Command)result.getResultHolder()).getOutput().getError());
                        if (problem == null) {
                            problem = err;
                        }
                        results.add(err);
                        continue;
                    }
                    if (this.convertPipelineAndTxResults && result.isStatus()) continue;
                    try {
                        results.add(result.get());
                    }
                    catch (DataAccessException e) {
                        if (problem == null) {
                            problem = e;
                        }
                        results.add((Object)e);
                    }
                }
            }
            this.ppline.clear();
            if (problem != null) {
                throw new RedisPipelineException((Exception)((Object)problem), (List<Object>)results);
            }
            if (done) {
                return results;
            }
            throw new RedisPipelineException((Exception)new QueryTimeoutException("Redis command timed out"));
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sort((Object)key, args)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sort((Object)key, args)));
                return null;
            }
            return this.getConnection().sort((Object)key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            return this.getConnection().sortStore((Object)key, args, (Object)sortKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().dbsize()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().dbsize()));
                return null;
            }
            return this.getConnection().dbsize();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().flushdb()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().flushdb()));
                return;
            }
            this.getConnection().flushdb();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().flushall()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().flushall()));
                return;
            }
            this.getConnection().flushall();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().bgsave()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().bgsave()));
                return;
            }
            this.getConnection().bgsave();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().bgrewriteaof()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().bgrewriteaof()));
                return;
            }
            this.getConnection().bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    @Deprecated
    public void bgWriteAof() {
        this.bgReWriteAof();
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().save()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().save()));
                return;
            }
            this.getConnection().save();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().configGet(param)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().configGet(param)));
                return null;
            }
            return this.getConnection().configGet(param);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().info(), LettuceConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().info(), LettuceConverters.stringToProps()));
                return null;
            }
            return LettuceConverters.toProperties(this.getConnection().info());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().info(section), LettuceConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().info(section), LettuceConverters.stringToProps()));
                return null;
            }
            return LettuceConverters.toProperties(this.getConnection().info(section));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lastsave(), LettuceConverters.dateToLong()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lastsave(), LettuceConverters.dateToLong()));
                return null;
            }
            return LettuceConverters.toLong(this.getConnection().lastsave());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().configSet(param, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().configSet(param, value)));
                return;
            }
            this.getConnection().configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().configResetstat()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().configResetstat()));
                return;
            }
            this.getConnection().configResetstat();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.getAsyncConnection().shutdown(true);
                return;
            }
            this.getConnection().shutdown(true);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        boolean save = RedisServerCommands.ShutdownOption.SAVE.equals((Object)option);
        try {
            if (this.isPipelined()) {
                this.getAsyncConnection().shutdown(save);
                return;
            }
            this.getConnection().shutdown(save);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().echo((Object)message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().echo((Object)message)));
                return null;
            }
            return (byte[])this.getConnection().echo((Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().ping()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().ping()));
                return null;
            }
            return this.getConnection().ping();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().del((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().del((Object[])keys)));
                return null;
            }
            return this.getConnection().del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncDedicatedConnection().discard()));
                return;
            }
            this.getDedicatedConnection().discard();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncDedicatedConnection().exec(), new LettuceTransactionResultConverter(new LinkedList(this.txResults), LettuceConverters.exceptionConverter())));
                List<Object> list = null;
                return list;
            }
            List<Object> results = this.getDedicatedConnection().exec();
            List<Object> list = this.convertPipelineAndTxResults ? new LettuceTransactionResultConverter(this.txResults, LettuceConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().exists((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().exists((Object)key)));
                return null;
            }
            return this.getConnection().exists((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().expire((Object)key, seconds)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().expire((Object)key, seconds)));
                return null;
            }
            return this.getConnection().expire((Object)key, seconds);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().expireat((Object)key, unixTime)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().expireat((Object)key, unixTime)));
                return null;
            }
            return this.getConnection().expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().pexpire((Object)key, millis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().pexpire((Object)key, millis)));
                return null;
            }
            return this.getConnection().pexpire((Object)key, millis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            return this.getConnection().pexpireat((Object)key, unixTimeInMillis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().pttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().pttl((Object)key)));
                return null;
            }
            return this.getConnection().pttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().dump((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().dump((Object)key)));
                return null;
            }
            return this.getConnection().dump((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().restore((Object)key, ttlInMillis, serializedValue)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().restore((Object)key, ttlInMillis, serializedValue)));
                return;
            }
            this.getConnection().restore((Object)key, ttlInMillis, serializedValue);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().keys((Object)pattern));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        try {
            if (this.isPipelined()) {
                this.getAsyncDedicatedConnection().multi();
                return;
            }
            this.getDedicatedConnection().multi();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().persist((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().persist((Object)key)));
                return null;
            }
            return this.getConnection().persist((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().move((Object)key, dbIndex)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().move((Object)key, dbIndex)));
                return null;
            }
            return this.getConnection().move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().randomkey()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().randomkey()));
                return null;
            }
            return (byte[])this.getConnection().randomkey();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().rename((Object)oldName, (Object)newName)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().rename((Object)oldName, (Object)newName)));
                return;
            }
            this.getConnection().rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().renamenx((Object)oldName, (Object)newName)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().renamenx((Object)oldName, (Object)newName)));
                return null;
            }
            return this.getConnection().renamenx((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        if (this.asyncSharedConn != null) {
            throw new UnsupportedOperationException("Selecting a new database not supported due to shared connection. Use separate ConnectionFactorys to work with multiple databases");
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Lettuce blocks for #select");
        }
        try {
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().select(dbIndex)));
                return;
            }
            this.getConnection().select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().ttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().ttl((Object)key)));
                return null;
            }
            return this.getConnection().ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            return LettuceConverters.toDataType(this.getConnection().type((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncDedicatedConnection().unwatch()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getDedicatedConnection().unwatch()));
                return;
            }
            this.getDedicatedConnection().unwatch();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncDedicatedConnection().watch((Object[])keys)));
                return;
            }
            this.getDedicatedConnection().watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().get((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().get((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().set((Object)key, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().set((Object)key, (Object)value)));
                return;
            }
            this.getConnection().set((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().getset((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().getset((Object)key, (Object)value)));
                return null;
            }
            return (byte[])this.getConnection().getset((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().append((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().append((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().append((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().mget((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().mget((Object[])keys)));
                return null;
            }
            return this.getConnection().mget((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().mset(tuples)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().mset(tuples)));
                return;
            }
            this.getConnection().mset(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().msetnx(tuples)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().msetnx(tuples)));
                return null;
            }
            return this.getConnection().msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().setex((Object)key, time, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().setex((Object)key, time, (Object)value)));
                return;
            }
            this.getConnection().setex((Object)key, time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        byte[] script = this.createRedisScriptForPSetEx(key, milliseconds, value);
        byte[][] emptyArgs = new byte[0][0];
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().eval((Object)script, ScriptOutputType.STATUS, (Object[])emptyArgs, (Object[])emptyArgs)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().eval((Object)script, ScriptOutputType.STATUS, (Object[])emptyArgs, (Object[])emptyArgs)));
                return;
            }
            this.eval(script, ReturnType.STATUS, 0, new byte[0][]);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private byte[] createRedisScriptForPSetEx(byte[] key, long milliseconds, byte[] value) {
        StringBuilder sb = new StringBuilder("return redis.call('PSETEX'");
        sb.append(",'");
        sb.append(new String(key));
        sb.append("',");
        sb.append(milliseconds);
        sb.append(",'");
        sb.append(new String(value));
        sb.append("')");
        return sb.toString().getBytes();
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().setnx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().getrange((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().getrange((Object)key, start, end)));
                return null;
            }
            return (byte[])this.getConnection().getrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().decr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().decr((Object)key)));
                return null;
            }
            return this.getConnection().decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().decrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().decrby((Object)key, value)));
                return null;
            }
            return this.getConnection().decrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().incr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().incr((Object)key)));
                return null;
            }
            return this.getConnection().incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().incrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().incrby((Object)key, value)));
                return null;
            }
            return this.getConnection().incrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            return this.getConnection().incrbyfloat((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().getbit((Object)key, offset));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return (Boolean)LettuceConverters.longToBooleanConverter().convert((Object)this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().setrange((Object)key, start, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().setrange((Object)key, start, (Object)value)));
                return;
            }
            this.getConnection().setrange((Object)key, start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().strlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().strlen((Object)key)));
                return null;
            }
            return this.getConnection().strlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().bitcount((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().bitcount((Object)key)));
                return null;
            }
            return this.getConnection().bitcount((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().bitcount((Object)key, begin, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().bitcount((Object)key, begin, end)));
                return null;
            }
            return this.getConnection().bitcount((Object)key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.asyncBitOp(op, destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.syncBitOp(op, destination, keys)));
                return null;
            }
            return this.syncBitOp(op, destination, keys);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lpush((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lpush((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().lpush((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().rpush((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().rpush((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().rpush((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncDedicatedConnection().blpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getDedicatedConnection().blpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)this.getDedicatedConnection().blpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncDedicatedConnection().brpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getDedicatedConnection().brpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)this.getDedicatedConnection().brpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lindex((Object)key, index)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lindex((Object)key, index)));
                return null;
            }
            return (byte[])this.getConnection().lindex((Object)key, index);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value)));
                return null;
            }
            return this.getConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().llen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().llen((Object)key)));
                return null;
            }
            return this.getConnection().llen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lpop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lpop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().lpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lrange((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lrange((Object)key, start, end)));
                return null;
            }
            return this.getConnection().lrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lrem((Object)key, count, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lrem((Object)key, count, (Object)value)));
                return null;
            }
            return this.getConnection().lrem((Object)key, count, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().lset((Object)key, index, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().lset((Object)key, index, (Object)value)));
                return;
            }
            this.getConnection().lset((Object)key, index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().ltrim((Object)key, start, end)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().ltrim((Object)key, start, end)));
                return;
            }
            this.getConnection().ltrim((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().rpop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().rpop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().rpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().rpoplpush((Object)srcKey, (Object)dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().rpoplpush((Object)srcKey, (Object)dstKey)));
                return null;
            }
            return (byte[])this.getConnection().rpoplpush((Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey)));
                return null;
            }
            return (byte[])this.getDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().lpushx((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().lpushx((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().lpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().rpushx((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().rpushx((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().rpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sadd((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sadd((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().sadd((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().scard((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().scard((Object)key)));
                return null;
            }
            return this.getConnection().scard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sdiff((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sdiff((Object[])keys)));
                return null;
            }
            return this.getConnection().sdiff((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sdiffstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sdiffstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sdiffstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sinter((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sinter((Object[])keys)));
                return null;
            }
            return this.getConnection().sinter((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sinterstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sinterstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sinterstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sismember((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sismember((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().sismember((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().smembers((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().smembers((Object)key)));
                return null;
            }
            return this.getConnection().smembers((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().smove((Object)srcKey, (Object)destKey, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().smove((Object)srcKey, (Object)destKey, (Object)value)));
                return null;
            }
            return this.getConnection().smove((Object)srcKey, (Object)destKey, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().spop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().spop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().spop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().srandmember((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().srandmember((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().srandmember((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        if (count < 0L) {
            throw new UnsupportedOperationException("sRandMember with a negative count is not supported");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().srandmember((Object)key, count), LettuceConverters.bytesSetToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().srandmember((Object)key, count), LettuceConverters.bytesSetToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList(this.getConnection().srandmember((Object)key, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().srem((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().srem((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().srem((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sunion((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sunion((Object[])keys)));
                return null;
            }
            return this.getConnection().sunion((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().sunionstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().sunionstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sunionstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zadd((Object)key, score, (Object)value), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zadd((Object)key, score, (Object)value), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().zadd((Object)key, score, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            return this.getConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zcard((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zcard((Object)key)));
                return null;
            }
            return this.getConnection().zcard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zcount((Object)key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zcount((Object)key, min, max)));
                return null;
            }
            return this.getConnection().zcount((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zincrby((Object)key, increment, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zincrby((Object)key, increment, (Object)value)));
                return null;
            }
            return this.getConnection().zincrby((Object)key, increment, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = this.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zinterstore((Object)destKey, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zinterstore((Object)destKey, (Object[])sets)));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrangebyscore((Object)key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, min, max), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrangebyscoreWithScores((Object)key, min, max), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrangebyscore((Object)key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, min, max, offset, count), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrangebyscoreWithScores((Object)key, min, max, offset, count), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, max, min, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrangebyscore((Object)key, max, min, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore((Object)key, max, min, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, max, min), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrangebyscore((Object)key, max, min), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore((Object)key, max, min));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, max, min, offset, count), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min, offset, count), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, max, min), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrank((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrank((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrem((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrem((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().zrem((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zremrangebyrank((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zremrangebyrank((Object)key, start, end)));
                return null;
            }
            return this.getConnection().zremrangebyrank((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zremrangebyscore((Object)key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zremrangebyscore((Object)key, min, max)));
                return null;
            }
            return this.getConnection().zremrangebyscore((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zrevrank((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zrevrank((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zrevrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zscore((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zscore((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zscore((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = this.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().zunionstore((Object)destKey, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().zunionstore((Object)destKey, (Object[])sets)));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hset((Object)key, (Object)field, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hset((Object)key, (Object)field, (Object)value)));
                return null;
            }
            return this.getConnection().hset((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hsetnx((Object)key, (Object)field, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hsetnx((Object)key, (Object)field, (Object)value)));
                return null;
            }
            return this.getConnection().hsetnx((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hdel((Object)key, (Object[])fields)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hdel((Object)key, (Object[])fields)));
                return null;
            }
            return this.getConnection().hdel((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hexists((Object)key, (Object)field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hexists((Object)key, (Object)field)));
                return null;
            }
            return this.getConnection().hexists((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hget((Object)key, (Object)field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hget((Object)key, (Object)field)));
                return null;
            }
            return (byte[])this.getConnection().hget((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hgetall((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hgetall((Object)key)));
                return null;
            }
            return this.getConnection().hgetall((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hincrby((Object)key, (Object)field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hincrby((Object)key, (Object)field, delta)));
                return null;
            }
            return this.getConnection().hincrby((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hincrbyfloat((Object)key, (Object)field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hincrbyfloat((Object)key, (Object)field, delta)));
                return null;
            }
            return this.getConnection().hincrbyfloat((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hkeys((Object)key), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hkeys((Object)key), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().hkeys((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hlen((Object)key)));
                return null;
            }
            return this.getConnection().hlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hmget((Object)key, (Object[])fields)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hmget((Object)key, (Object[])fields)));
                return null;
            }
            return this.getConnection().hmget((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().hmset((Object)key, tuple)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().hmset((Object)key, tuple)));
                return;
            }
            this.getConnection().hmset((Object)key, tuple);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().hvals((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().hvals((Object)key)));
                return null;
            }
            return this.getConnection().hvals((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void scriptFlush() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().scriptFlush()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().scriptFlush()));
                return;
            }
            this.getConnection().scriptFlush();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Script kill not permitted in a transaction");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().scriptKill()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxStatusResult(this.getConnection().scriptKill()));
                return;
            }
            this.getConnection().scriptKill();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().scriptLoad((Object)script)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().scriptLoad((Object)script)));
                return null;
            }
            return this.getConnection().scriptLoad((Object)script);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().scriptExists(scriptSha1)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().scriptExists(scriptSha1)));
                return null;
            }
            return this.getConnection().scriptExists(scriptSha1);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        try {
            byte[][] keys = this.extractScriptKeys(numKeys, keysAndArgs);
            byte[][] args = this.extractScriptArgs(numKeys, keysAndArgs);
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().eval((Object)script, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().eval((Object)script, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            return new LettuceEvalResultsConverter(returnType).convert(this.getConnection().eval((Object)script, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        try {
            byte[][] keys = this.extractScriptKeys(numKeys, keysAndArgs);
            byte[][] args = this.extractScriptArgs(numKeys, keysAndArgs);
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            return new LettuceEvalResultsConverter(returnType).convert(this.getConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().publish((Object)channel, (Object)message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().publish((Object)channel, (Object)message)));
                return null;
            }
            return this.getConnection().publish((Object)channel, (Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long time() {
        List result = (List)this.eval("return redis.call('TIME')".getBytes(), ReturnType.MULTI, 0, new byte[0][]);
        Assert.notEmpty((Collection)result, (String)"Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue((result.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + result.size()));
        return Converters.toTimeMillis(new String((byte[])result.get(0)), new String((byte[])result.get(1)));
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        String client = String.format("%s:%s", host, port);
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().clientKill(client)));
                return;
            }
            this.getConnection().clientKill(client);
        }
        catch (Exception e) {
            this.convertLettuceAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        if (this.isQueueing()) {
            this.pipeline(new LettuceStatusResult(this.getAsyncConnection().clientSetname((Object)name)));
            return;
        }
        if (this.isQueueing()) {
            this.transaction(new LettuceTxResult(this.getConnection().clientSetname((Object)name)));
            return;
        }
        this.getAsyncConnection().clientSetname((Object)name);
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().slaveof(host, port)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().slaveof(host, port)));
                return;
            }
            this.getConnection().slaveof(host, port);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String getClientName() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult(this.getAsyncConnection().clientGetname(), LettuceConverters.bytesToString()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().clientGetname(), LettuceConverters.bytesToString()));
                return null;
            }
            return LettuceConverters.toString((byte[])this.getConnection().clientGetname());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Cannot be called in pipeline mode.");
        }
        if (this.isQueueing()) {
            this.transaction(new LettuceTxResult(this.getAsyncConnection().clientList(), LettuceConverters.stringToRedisClientListConverter()));
            return null;
        }
        return LettuceConverters.toListOfRedisClientInformation(this.getConnection().clientList());
    }

    @Override
    public void slaveOfNoOne() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new LettuceStatusResult(this.getAsyncConnection().slaveofNoOne()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceTxResult(this.getConnection().slaveofNoOne()));
                return;
            }
            this.getConnection().slaveofNoOne();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    public Cursor<byte[]> scan() {
        return this.scan(0L, ScanOptions.NONE);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (LettuceConnection.this.isQueueing() || LettuceConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                String params = " ," + cursorId + options.toOptionString();
                String script = "return redis.call('SCAN'" + params + ")";
                List result = (List)LettuceConnection.this.eval(script.getBytes(), ReturnType.MULTI, 0, new byte[0][]);
                String nextCursorId = (String)LettuceConverters.bytesToString().convert((Object)((byte[])result.get(0)));
                return new ScanIteration<byte[]>(Long.valueOf(nextCursorId), (List)result.get(1));
            }
        }.open();
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, 0L, options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceConnection.this.isQueueing() || LettuceConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                byte[] script = LettuceConnection.this.createBinaryLuaScriptForScan("HSCAN", key, cursorId, options);
                List result = (List)LettuceConnection.this.eval(script, ReturnType.MULTI, 0, new byte[0][]);
                String nextCursorId = (String)LettuceConverters.bytesToString().convert((Object)((byte[])result.get(0)));
                Map values = (Map)LettuceConnection.this.failsafeReadScanValues(result, LettuceConverters.bytesListToMapConverter());
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(nextCursorId), values.entrySet());
            }
        }.open();
    }

    private byte[] createBinaryLuaScriptForScan(String command, byte[] key, long cursorId, ScanOptions options) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(("return redis.call('" + command + "'").getBytes("UTF-8"));
            outputStream.write(", '".getBytes("UTF-8"));
            this.writeFilteredKey(key, outputStream);
            outputStream.write("', ".getBytes("UTF-8"));
            outputStream.write(Long.toString(cursorId).getBytes("UTF-8"));
            outputStream.write(options.toOptionString().getBytes("UTF-8"));
            outputStream.write(")".getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    private void writeFilteredKey(byte[] key, OutputStream stream) {
        byte toBeFiltered = 13;
        for (byte b : key) {
            try {
                if (toBeFiltered == b) {
                    stream.write("\\r".getBytes());
                    continue;
                }
                stream.write(b);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot convert key to suitable redis key for lua", e);
            }
        }
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceConnection.this.isQueueing() || LettuceConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                byte[] script = LettuceConnection.this.createBinaryLuaScriptForScan("SSCAN", key, cursorId, options);
                List result = (List)LettuceConnection.this.eval(script, ReturnType.MULTI, 0, new byte[0][]);
                String nextCursorId = (String)LettuceConverters.bytesToString().convert((Object)((byte[])result.get(0)));
                List values = (List)LettuceConnection.this.failsafeReadScanValues(result, null);
                return new ScanIteration<byte[]>(Long.valueOf(nextCursorId), values);
            }
        }.open();
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceConnection.this.isQueueing() || LettuceConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                byte[] script = LettuceConnection.this.createBinaryLuaScriptForScan("ZSCAN", key, cursorId, options);
                List result = (List)LettuceConnection.this.eval(script, ReturnType.MULTI, 0, new byte[0][]);
                String nextCursorId = (String)LettuceConverters.bytesToString().convert((Object)((byte[])result.get(0)));
                List values = (List)LettuceConnection.this.failsafeReadScanValues(result, LettuceConverters.bytesListToTupleListConverter());
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(nextCursorId), values);
            }
        }.open();
    }

    private <T> T failsafeReadScanValues(List<?> source, Converter converter) {
        try {
            return (T)(converter != null ? converter.convert(source.get(1)) : source.get(1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    private RedisPubSubConnection<byte[], byte[]> switchToPubSub() {
        this.close();
        return this.client.connectPubSub(CODEC);
    }

    private void pipeline(LettuceResult result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.ppline.add(result);
        }
    }

    private void transaction(FutureResult<?> result) {
        this.txResults.add(result);
    }

    private RedisAsyncConnection<byte[], byte[]> getAsyncConnection() {
        if (this.isQueueing()) {
            return this.getAsyncDedicatedConnection();
        }
        if (this.asyncSharedConn != null) {
            return this.asyncSharedConn;
        }
        return this.getAsyncDedicatedConnection();
    }

    private RedisConnection<byte[], byte[]> getConnection() {
        if (this.isQueueing()) {
            return this.getDedicatedConnection();
        }
        if (this.sharedConn != null) {
            return this.sharedConn;
        }
        return this.getDedicatedConnection();
    }

    private RedisAsyncConnection<byte[], byte[]> getAsyncDedicatedConnection() {
        if (this.asyncDedicatedConn == null) {
            this.asyncDedicatedConn = this.pool != null ? (RedisAsyncConnection)this.pool.getResource() : this.client.connectAsync(CODEC);
        }
        return this.asyncDedicatedConn;
    }

    private RedisConnection<byte[], byte[]> getDedicatedConnection() {
        if (this.dedicatedConn == null) {
            this.dedicatedConn = new RedisConnection(this.getAsyncDedicatedConnection());
        }
        return this.dedicatedConn;
    }

    private Future<Long> asyncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getAsyncConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getAsyncConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getAsyncConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getAsyncConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private Long syncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private byte[][] extractScriptKeys(int numKeys, byte[] ... keysAndArgs) {
        if (numKeys > 0) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, 0, numKeys);
        }
        return new byte[0][0];
    }

    private byte[][] extractScriptArgs(int numKeys, byte[] ... keysAndArgs) {
        if (keysAndArgs.length > numKeys) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, numKeys, keysAndArgs.length);
        }
        return new byte[0][0];
    }

    private ZStoreArgs zStoreArgs(RedisZSetCommands.Aggregate aggregate, int[] weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        long[] lg = new long[weights.length];
        for (int i = 0; i < lg.length; ++i) {
            lg[i] = weights[i];
        }
        args.weights(lg);
        return args;
    }

    private void validateCommandIfRunningInTransactionMode(CommandType cmd, byte[] ... args) {
        if (this.isQueueing()) {
            this.validateCommand(cmd, args);
        }
    }

    private void validateCommand(CommandType cmd, byte[] ... args) {
        RedisCommand redisCommand = RedisCommand.failsafeCommandLookup(cmd.name());
        if (!RedisCommand.UNKNOWN.equals((Object)redisCommand) && redisCommand.requiresArguments()) {
            try {
                redisCommand.validateArgumentCount(args != null ? args.length : 0);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataAccessApiUsageException(String.format("Validation failed for %s command.", cmd), (Throwable)e);
            }
        }
    }

    static class TypeHints {
        private static final Map<CommandType, Class<? extends CommandOutput>> COMMAND_OUTPUT_TYPE_MAPPING = new HashMap<CommandType, Class<? extends CommandOutput>>();
        private static final Map<Class<?>, Constructor<CommandOutput>> CONSTRUCTORS = new ConcurrentHashMap();

        TypeHints() {
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITCOUNT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITOP, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DBSIZE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECR, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETBIT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HDEL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCR, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINSERT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSHX, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PTTL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PUBLISH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSHX, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SADD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SCARD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFFSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETBIT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETRANGE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTERSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNIONSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.STRLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TTL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZADD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZCOUNT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINTERSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYSCORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZUNIONSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBYFLOAT, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBYFLOAT, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINCRBY, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZSCORE, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGETALL, MapOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HKEYS, KeyListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.KEYS, KeyListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOP, KeyValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOPLPUSH, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ECHO, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETRANGE, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETSET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINDEX, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RANDOMKEY, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAME, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOPLPUSH, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SRANDMEMBER, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGREWRITEAOF, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGSAVE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.CLIENT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEBUG, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DISCARD, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHALL, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHDB, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INFO, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LTRIM, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MIGRATE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.QUIT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RESTORE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SAVE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SELECT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETEX, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SHUTDOWN, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SLAVEOF, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SYNC, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TYPE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.WATCH, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.UNWATCH, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HVALS, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SORT, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGEBYSCORE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGEBYSCORE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXISTS, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIRE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIREAT, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HEXISTS, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSET, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MOVE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PERSIST, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIRE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIREAT, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAMENX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SISMEMBER, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMOVE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXEC, MultiOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MULTI, MultiOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LASTSAVE, DateOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFF, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTER, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMEMBERS, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNION, ValueSetOutput.class);
        }

        public CommandOutput getTypeHint(CommandType type) {
            return this.getTypeHint(type, (CommandOutput)new ByteArrayOutput(CODEC));
        }

        public CommandOutput getTypeHint(CommandType type, CommandOutput defaultType) {
            if (type == null || !COMMAND_OUTPUT_TYPE_MAPPING.containsKey(type)) {
                return defaultType;
            }
            CommandOutput outputType = this.instanciateCommandOutput(COMMAND_OUTPUT_TYPE_MAPPING.get(type));
            return outputType != null ? outputType : defaultType;
        }

        private CommandOutput<?, ?, ?> instanciateCommandOutput(Class<? extends CommandOutput> type) {
            Assert.notNull(type, (String)"Cannot create instance for 'null' type.");
            Constructor constructor = CONSTRUCTORS.get(type);
            if (constructor == null) {
                constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{RedisCodec.class});
                CONSTRUCTORS.put(type, constructor);
            }
            return (CommandOutput)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{CODEC});
        }
    }

    private class LettuceEvalResultsConverter<T>
    implements Converter<Object, T> {
        private ReturnType returnType;

        public LettuceEvalResultsConverter(ReturnType returnType) {
            this.returnType = returnType;
        }

        public T convert(Object source) {
            if (this.returnType == ReturnType.MULTI) {
                List resultList = (List)source;
                for (Object obj : resultList) {
                    if (!(obj instanceof Exception)) continue;
                    throw LettuceConnection.this.convertLettuceAccessException((Exception)obj);
                }
            }
            return (T)source;
        }
    }

    private class LettuceTransactionResultConverter<T>
    extends TransactionResultConverter<T> {
        public LettuceTransactionResultConverter(Queue<FutureResult<T>> txResults, Converter<Exception, DataAccessException> exceptionConverter) {
            super(txResults, exceptionConverter);
        }

        @Override
        public List<Object> convert(List<Object> execResults) {
            if (execResults.isEmpty()) {
                return null;
            }
            return super.convert(execResults);
        }
    }

    private class LettuceTxStatusResult
    extends LettuceTxResult {
        public LettuceTxStatusResult(Object resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }
    }

    private class LettuceTxResult
    extends FutureResult<Object> {
        public LettuceTxResult(Object resultHolder, Converter<?, ?> converter) {
            super(resultHolder, converter);
        }

        public LettuceTxResult(Object resultHolder) {
            super(resultHolder);
        }

        @Override
        public Object get() {
            if (LettuceConnection.this.convertPipelineAndTxResults && this.converter != null) {
                return this.converter.convert(this.resultHolder);
            }
            return this.resultHolder;
        }
    }

    private class LettuceStatusResult
    extends LettuceResult {
        public LettuceStatusResult(Future resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }
    }

    private class LettuceResult
    extends FutureResult<Command<?, ?, ?>> {
        public <T> LettuceResult(Future<T> resultHolder, Converter<T, ?> converter) {
            super((Command)resultHolder, converter);
        }

        public LettuceResult(Future resultHolder) {
            super((Command)resultHolder);
        }

        @Override
        public Object get() {
            if (LettuceConnection.this.convertPipelineAndTxResults && this.converter != null) {
                return this.converter.convert(((Command)this.resultHolder).get());
            }
            return ((Command)this.resultHolder).get();
        }
    }
}

