/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.neo4j.fieldaccess.PropertyConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class WhereClause {
    protected static final Map<Part.Type, String> SYMBOLS;
    protected final PartInfo partInfo;
    private final Part.Type type;
    private PropertyConverter propertyConverter;

    public WhereClause(PartInfo partInfo, Neo4jTemplate template) {
        Assert.notNull((Object)partInfo.getType());
        this.partInfo = partInfo;
        this.type = this.partInfo.getType();
        Neo4jPersistentProperty property = partInfo.getLeafProperty();
        if (!property.isNeo4jPropertyType()) {
            this.propertyConverter = new PropertyConverter(template.getConversionService(), property);
        }
    }

    public String toString() {
        String propertyName = this.partInfo.getNeo4jPropertyName();
        String operator = SYMBOLS.get(this.type);
        String variable = this.partInfo.getIdentifier();
        String result = this.type.getNumberOfArguments() == 0 ? String.format("`%1$s`.`%2$s`! %3$s ", variable, propertyName, operator) : String.format("`%1$s`.`%2$s`! %3$s {%4$d}", variable, propertyName, operator, this.partInfo.getParameterIndex());
        if (this.type == Part.Type.EXISTS) {
            result = "has(" + result + ")";
        }
        if (EnumSet.of(Part.Type.NOT_IN, Part.Type.NOT_LIKE).contains(this.type)) {
            result = "not( " + result + " )";
        }
        return result;
    }

    public PartInfo getPartInfo() {
        return this.partInfo;
    }

    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        for (Map.Entry<Parameter, Object> entry : parameters.entrySet()) {
            if (this.partInfo.getParameterIndex() != entry.getKey().getIndex()) continue;
            Object value = entry.getValue();
            if (EnumSet.of(Part.Type.CONTAINING, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH).contains(this.type)) {
                value = QueryTemplates.formatExpression(this.partInfo, value);
            } else if (this.propertyConverter != null) {
                value = this.propertyConverter.serializePropertyValue(value);
            }
            entry.setValue(value);
        }
        return parameters;
    }

    static {
        HashMap<Part.Type, String> symbols = new HashMap<Part.Type, String>();
        symbols.put(Part.Type.GREATER_THAN, ">");
        symbols.put(Part.Type.AFTER, ">");
        symbols.put(Part.Type.GREATER_THAN_EQUAL, ">=");
        symbols.put(Part.Type.LESS_THAN, "<");
        symbols.put(Part.Type.BEFORE, "<");
        symbols.put(Part.Type.LESS_THAN_EQUAL, "<=");
        symbols.put(Part.Type.NEGATING_SIMPLE_PROPERTY, "<>");
        symbols.put(Part.Type.SIMPLE_PROPERTY, "=");
        symbols.put(Part.Type.REGEX, "=~");
        symbols.put(Part.Type.STARTING_WITH, "=~");
        symbols.put(Part.Type.CONTAINING, "=~");
        symbols.put(Part.Type.ENDING_WITH, "=~");
        symbols.put(Part.Type.LIKE, "=~");
        symbols.put(Part.Type.NOT_LIKE, "=~");
        symbols.put(Part.Type.EXISTS, "");
        symbols.put(Part.Type.IS_NULL, "is null");
        symbols.put(Part.Type.IN, "in");
        symbols.put(Part.Type.NOT_IN, "in");
        symbols.put(Part.Type.TRUE, "= true");
        symbols.put(Part.Type.FALSE, "= false");
        SYMBOLS = Collections.unmodifiableMap(symbols);
    }
}

