/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.EvaluationOperators;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

public class AggregationExpressionCriteria
implements CriteriaDefinition {
    private final AggregationExpression expression;

    AggregationExpressionCriteria(AggregationExpression expression) {
        this.expression = expression;
    }

    public static AggregationExpressionCriteria whereExpr(AggregationExpression expression) {
        return new AggregationExpressionCriteria(expression);
    }

    @Override
    public Document getCriteriaObject() {
        AggregationExpression aggregationExpression = this.expression;
        if (aggregationExpression instanceof EvaluationOperators.Expr) {
            EvaluationOperators.Expr expr = (EvaluationOperators.Expr)aggregationExpression;
            return new Document(this.getKey(), expr.get(0));
        }
        return new Document(this.getKey(), (Object)this.expression);
    }

    @Override
    public String getKey() {
        return "$expr";
    }
}

