/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TextCriteria
implements CriteriaDefinition {
    private final List<Term> terms;
    private String language;

    public TextCriteria() {
        this(null);
    }

    private TextCriteria(String language) {
        this.language = language;
        this.terms = new ArrayList<Term>();
    }

    public static TextCriteria forDefaultLanguage() {
        return new TextCriteria();
    }

    public static TextCriteria forLanguage(String language) {
        Assert.hasText((String)language, (String)"Language must not be null or empty!");
        return new TextCriteria(language);
    }

    public TextCriteria matchingAny(String ... words) {
        for (String word : words) {
            this.matching(word);
        }
        return this;
    }

    public TextCriteria matching(Term term) {
        Assert.notNull((Object)term, (String)"Term to add must not be null.");
        this.terms.add(term);
        return this;
    }

    public TextCriteria matching(String term) {
        if (StringUtils.hasText((String)term)) {
            this.matching(new Term(term));
        }
        return this;
    }

    public TextCriteria notMatching(String term) {
        if (StringUtils.hasText((String)term)) {
            this.matching(new Term(term, Term.Type.WORD).negate());
        }
        return this;
    }

    public TextCriteria notMatchingAny(String ... words) {
        for (String word : words) {
            this.notMatching(word);
        }
        return this;
    }

    public TextCriteria notMatchingPhrase(String phrase) {
        if (StringUtils.hasText((String)phrase)) {
            this.matching(new Term(phrase, Term.Type.PHRASE).negate());
        }
        return this;
    }

    public TextCriteria matchingPhrase(String phrase) {
        if (StringUtils.hasText((String)phrase)) {
            this.matching(new Term(phrase, Term.Type.PHRASE));
        }
        return this;
    }

    @Override
    public String getKey() {
        return "$text";
    }

    @Override
    public DBObject getCriteriaObject() {
        BasicDBObjectBuilder builder = new BasicDBObjectBuilder();
        if (StringUtils.hasText((String)this.language)) {
            builder.add("$language", (Object)this.language);
        }
        if (!this.terms.isEmpty()) {
            builder.add("$search", (Object)this.join(this.terms));
        }
        return new BasicDBObject("$text", (Object)builder.get());
    }

    private String join(Iterable<Term> terms) {
        ArrayList<String> result = new ArrayList<String>();
        for (Term term : terms) {
            if (term == null) continue;
            result.add(term.getFormatted());
        }
        return StringUtils.collectionToDelimitedString(result, (String)" ");
    }
}

