/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.MongoCollectionUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T>,
ApplicationContextAware {
    private static final String AMBIGUOUS_FIELD_MAPPING = "Ambiguous field mapping detected! Both %s and %s map to the same field name %s! Disambiguate using @DocumentField annotation!";
    private final String collection;
    private final String language;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext context = new StandardEvaluationContext();

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation, (Comparator)MongoPersistentPropertyComparator.INSTANCE);
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        if (rawType.isAnnotationPresent(Document.class)) {
            Document d = rawType.getAnnotation(Document.class);
            this.collection = StringUtils.hasText((String)d.collection()) ? d.collection() : fallback;
            this.language = StringUtils.hasText((String)d.language()) ? d.language() : "";
        } else {
            this.collection = fallback;
            this.language = "";
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @Override
    public String getCollection() {
        Expression expression = this.parser.parseExpression(this.collection, ParserContext.TEMPLATE_EXPRESSION);
        return (String)expression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public MongoPersistentProperty getTextScoreProperty() {
        return (MongoPersistentProperty)this.getPersistentProperty(TextScore.class);
    }

    @Override
    public boolean hasTextScoreProperty() {
        return this.getTextScoreProperty() != null;
    }

    public void verify() {
        this.verifyFieldUniqueness();
        this.verifyFieldTypes();
    }

    private void verifyFieldUniqueness() {
        AssertFieldNameUniquenessHandler handler = new AssertFieldNameUniquenessHandler();
        this.doWithProperties(handler);
        this.doWithAssociations(handler);
    }

    private void verifyFieldTypes() {
        this.doWithProperties(new PropertyTypeAssertionHandler());
    }

    protected MongoPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(MongoPersistentProperty property) {
        Assert.notNull((Object)property);
        if (!property.isIdProperty()) {
            return null;
        }
        MongoPersistentProperty currentIdProperty = (MongoPersistentProperty)this.getIdProperty();
        boolean currentIdPropertyIsSet = currentIdProperty != null;
        boolean currentIdPropertyIsExplicit = currentIdPropertyIsSet ? currentIdProperty.isExplicitIdProperty() : false;
        boolean newIdPropertyIsExplicit = property.isExplicitIdProperty();
        if (!currentIdPropertyIsSet) {
            return property;
        }
        Field currentIdPropertyField = currentIdProperty.getField();
        if (newIdPropertyIsExplicit && currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add explicit id property %s but already have an property %s registered as explicit id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        if (newIdPropertyIsExplicit && !currentIdPropertyIsExplicit) {
            return property;
        }
        if (newIdPropertyIsExplicit || !currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add id property %s but already have an property %s registered as id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        return null;
    }

    private static class PropertyTypeAssertionHandler
    implements PropertyHandler<MongoPersistentProperty> {
        private PropertyTypeAssertionHandler() {
        }

        public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
            this.potentiallyAssertTextScoreType(persistentProperty);
            this.potentiallyAssertLanguageType(persistentProperty);
        }

        private void potentiallyAssertLanguageType(MongoPersistentProperty persistentProperty) {
            if (persistentProperty.isExplicitLanguageProperty()) {
                this.assertPropertyType(persistentProperty, String.class);
            }
        }

        private void potentiallyAssertTextScoreType(MongoPersistentProperty persistentProperty) {
            if (persistentProperty.isTextScoreProperty()) {
                this.assertPropertyType(persistentProperty, Float.class, Double.class);
            }
        }

        private void assertPropertyType(MongoPersistentProperty persistentProperty, Class<?> ... validMatches) {
            for (Class<?> potentialMatch : validMatches) {
                if (!ClassUtils.isAssignable(potentialMatch, (Class)persistentProperty.getActualType())) continue;
                return;
            }
            throw new MappingException(String.format("Missmatching types for %s. Found %s expected one of %s.", persistentProperty.getField(), persistentProperty.getActualType(), StringUtils.arrayToCommaDelimitedString((Object[])validMatches)));
        }
    }

    private static class AssertFieldNameUniquenessHandler
    implements PropertyHandler<MongoPersistentProperty>,
    AssociationHandler<MongoPersistentProperty> {
        private final Map<String, MongoPersistentProperty> properties = new HashMap<String, MongoPersistentProperty>();

        private AssertFieldNameUniquenessHandler() {
        }

        public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
            this.assertUniqueness(persistentProperty);
        }

        public void doWithAssociation(Association<MongoPersistentProperty> association) {
            this.assertUniqueness((MongoPersistentProperty)association.getInverse());
        }

        private void assertUniqueness(MongoPersistentProperty property) {
            String fieldName = property.getFieldName();
            MongoPersistentProperty existingProperty = this.properties.get(fieldName);
            if (existingProperty != null) {
                throw new MappingException(String.format(BasicMongoPersistentEntity.AMBIGUOUS_FIELD_MAPPING, property.toString(), existingProperty.toString(), fieldName));
            }
            this.properties.put(fieldName, property);
        }
    }

    static enum MongoPersistentPropertyComparator implements Comparator<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(MongoPersistentProperty o1, MongoPersistentProperty o2) {
            if (o1.getFieldOrder() == Integer.MAX_VALUE) {
                return 1;
            }
            if (o2.getFieldOrder() == Integer.MAX_VALUE) {
                return -1;
            }
            return o1.getFieldOrder() - o2.getFieldOrder();
        }
    }
}

