/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.util.Assert;

abstract class GeoConverters {
    private GeoConverters() {
    }

    public static Collection<? extends Object> getConvertersToRegister() {
        return Arrays.asList(new Enum[]{BoxToDbObjectConverter.INSTANCE, PolygonToDbObjectConverter.INSTANCE, CircleToDbObjectConverter.INSTANCE, SphereToDbObjectConverter.INSTANCE, DbObjectToBoxConverter.INSTANCE, DbObjectToPolygonConverter.INSTANCE, DbObjectToCircleConverter.INSTANCE, DbObjectToSphereConverter.INSTANCE, DbObjectToPointConverter.INSTANCE, PointToDbObjectConverter.INSTANCE, GeoCommandToDbObjectConverter.INSTANCE});
    }

    static List<Double> toList(Point point) {
        return Arrays.asList(point.getX(), point.getY());
    }

    public static enum GeoCommandToDbObjectConverter implements Converter<GeoCommand, DBObject>
    {
        INSTANCE;


        public DBObject convert(GeoCommand source) {
            if (source == null) {
                return null;
            }
            BasicDBList argument = new BasicDBList();
            Shape shape = source.getShape();
            if (shape instanceof Box) {
                argument.add(GeoConverters.toList(((Box)shape).getFirst()));
                argument.add(GeoConverters.toList(((Box)shape).getSecond()));
            } else if (shape instanceof Circle) {
                argument.add(GeoConverters.toList(((Circle)shape).getCenter()));
                argument.add((Object)((Circle)shape).getRadius().getNormalizedValue());
            } else if (shape instanceof Circle) {
                argument.add(GeoConverters.toList(((Circle)shape).getCenter()));
                argument.add((Object)((Circle)shape).getRadius());
            } else if (shape instanceof Polygon) {
                for (Point point : ((Polygon)shape).getPoints()) {
                    argument.add(GeoConverters.toList(point));
                }
            } else if (shape instanceof Sphere) {
                argument.add(GeoConverters.toList(((Sphere)shape).getCenter()));
                argument.add((Object)((Sphere)shape).getRadius().getNormalizedValue());
            }
            return new BasicDBObject(source.getCommand(), (Object)argument);
        }
    }

    @ReadingConverter
    public static enum DbObjectToPolygonConverter implements Converter<DBObject, Polygon>
    {
        INSTANCE;


        public Polygon convert(DBObject source) {
            if (source == null) {
                return null;
            }
            List points = (List)source.get("points");
            ArrayList<Point> newPoints = new ArrayList<Point>(points.size());
            for (DBObject element : points) {
                Assert.notNull((Object)element, (String)"Point elements of polygon must not be null!");
                newPoints.add(DbObjectToPointConverter.INSTANCE.convert(element));
            }
            return new Polygon(newPoints);
        }
    }

    public static enum PolygonToDbObjectConverter implements Converter<Polygon, DBObject>
    {
        INSTANCE;


        public DBObject convert(Polygon source) {
            if (source == null) {
                return null;
            }
            List points = source.getPoints();
            ArrayList<DBObject> pointTuples = new ArrayList<DBObject>(points.size());
            for (Point point : points) {
                pointTuples.add(PointToDbObjectConverter.INSTANCE.convert(point));
            }
            BasicDBObject result = new BasicDBObject();
            result.put("points", pointTuples);
            return result;
        }
    }

    @ReadingConverter
    public static enum DbObjectToSphereConverter implements Converter<DBObject, Sphere>
    {
        INSTANCE;


        public Sphere convert(DBObject source) {
            if (source == null) {
                return null;
            }
            DBObject center = (DBObject)source.get("center");
            Double radius = (Double)source.get("radius");
            Distance distance = new Distance(radius.doubleValue());
            if (source.containsField("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null!");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            Assert.notNull((Object)center, (String)"Center must not be null!");
            Assert.notNull((Object)radius, (String)"Radius must not be null!");
            return new Sphere(DbObjectToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    public static enum SphereToDbObjectConverter implements Converter<Sphere, DBObject>
    {
        INSTANCE;


        public DBObject convert(Sphere source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("center", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    public static enum DbObjectToCircleConverter implements Converter<DBObject, Circle>
    {
        INSTANCE;


        public Circle convert(DBObject source) {
            if (source == null) {
                return null;
            }
            DBObject center = (DBObject)source.get("center");
            Double radius = (Double)source.get("radius");
            Distance distance = new Distance(radius.doubleValue());
            if (source.containsField("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null!");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            Assert.notNull((Object)center, (String)"Center must not be null!");
            Assert.notNull((Object)radius, (String)"Radius must not be null!");
            return new Circle(DbObjectToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    public static enum CircleToDbObjectConverter implements Converter<Circle, DBObject>
    {
        INSTANCE;


        public DBObject convert(Circle source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("center", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    public static enum DbObjectToBoxConverter implements Converter<DBObject, Box>
    {
        INSTANCE;


        public Box convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Point first = DbObjectToPointConverter.INSTANCE.convert((DBObject)source.get("first"));
            Point second = DbObjectToPointConverter.INSTANCE.convert((DBObject)source.get("second"));
            return new Box(first, second);
        }
    }

    @WritingConverter
    public static enum BoxToDbObjectConverter implements Converter<Box, DBObject>
    {
        INSTANCE;


        public DBObject convert(Box source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("first", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getFirst()));
            result.put("second", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getSecond()));
            return result;
        }
    }

    public static enum PointToDbObjectConverter implements Converter<Point, DBObject>
    {
        INSTANCE;


        public DBObject convert(Point source) {
            return source == null ? null : new BasicDBObject("x", (Object)source.getX()).append("y", (Object)source.getY());
        }
    }

    @ReadingConverter
    public static enum DbObjectToPointConverter implements Converter<DBObject, Point>
    {
        INSTANCE;


        public Point convert(DBObject source) {
            Assert.isTrue((source.keySet().size() == 2 ? 1 : 0) != 0, (String)"Source must contain 2 elements");
            return source == null ? null : new Point(((Double)source.get("x")).doubleValue(), ((Double)source.get("y")).doubleValue());
        }
    }
}

