/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

class DefaultDbRefProxyHandler
implements DbRefProxyHandler {
    private final SpELContext spELContext;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final ValueResolver resolver;

    public DefaultDbRefProxyHandler(SpELContext spELContext, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, ValueResolver resolver) {
        this.spELContext = spELContext;
        this.mappingContext = mappingContext;
        this.resolver = resolver;
    }

    @Override
    public Object populateId(MongoPersistentProperty property, DBRef source, Object proxy) {
        if (source == null) {
            return proxy;
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty.usePropertyAccess()) {
            return proxy;
        }
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator(proxy, this.spELContext);
        BeanWrapper proxyWrapper = BeanWrapper.create((Object)proxy, null);
        BasicDBObject object = new BasicDBObject(idProperty.getFieldName(), source.getId());
        ObjectPath objectPath = ObjectPath.ROOT.push(proxy, persistentEntity, null);
        proxyWrapper.setProperty((PersistentProperty)idProperty, this.resolver.getValueInternal(idProperty, (DBObject)object, (SpELExpressionEvaluator)evaluator, objectPath));
        return proxy;
    }
}

