/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoServerSelectionException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.UncategorizedMongoDbException;

public class MongoExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof MongoException.DuplicateKey || ex instanceof DuplicateKeyException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException.Network || ex instanceof MongoSocketException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException.CursorNotFound || ex instanceof MongoCursorNotFoundException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoServerSelectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoTimeoutException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoInternalException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException) {
            int code = ((MongoException)((Object)ex)).getCode();
            if (code == 11000 || code == 11001) {
                throw new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (code == 12000 || code == 13440) {
                throw new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (code == 10003 || code == 12001 || code == 12010 || code == 12011 || code == 12012) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            return new UncategorizedMongoDbException(ex.getMessage(), ex);
        }
        return null;
    }
}

