/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityMetadata;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.SimpleMongoEntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoQueryMethod
extends QueryMethod {
    private static final List<Class<? extends Serializable>> GEO_NEAR_RESULTS = Arrays.asList(GeoResult.class, GeoResults.class, GeoPage.class);
    private final Method method;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private MongoEntityMetadata<?> metadata;

    public MongoQueryMethod(Method method, RepositoryMetadata metadata, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(method, metadata);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.method = method;
        this.mappingContext = mappingContext;
    }

    protected MongoParameters createParameters(Method method) {
        return new MongoParameters(method, this.isGeoNearQuery(method));
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getFieldSpecification() {
        String value = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"fields");
        return StringUtils.hasText((String)value) ? value : null;
    }

    public MongoEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            MongoPersistentEntity returnedEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(this.getReturnedObjectType());
            MongoPersistentEntity managedEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
            returnedEntity = returnedEntity == null ? managedEntity : returnedEntity;
            MongoPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
            this.metadata = new SimpleMongoEntityMetadata(returnedEntity.getType(), collectionEntity.getCollection());
        }
        return this.metadata;
    }

    public MongoParameters getParameters() {
        return (MongoParameters)super.getParameters();
    }

    public boolean isGeoNearQuery() {
        return this.isGeoNearQuery(this.method);
    }

    private boolean isGeoNearQuery(Method method) {
        Class<?> returnType = method.getReturnType();
        for (Class<? extends Serializable> type : GEO_NEAR_RESULTS) {
            if (!type.isAssignableFrom(returnType)) continue;
            return true;
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            TypeInformation from = ClassTypeInformation.fromReturnTypeOf((Method)method);
            return GeoResult.class.equals((Object)from.getComponentType().getType());
        }
        return false;
    }

    Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }
}

