/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.CollectionUtils;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;

public class KeysetScrollDelegate {
    private static final KeysetScrollDelegate FORWARD = new KeysetScrollDelegate();
    private static final KeysetScrollDelegate REVERSE = new ReverseKeysetScrollDelegate();

    public static KeysetScrollDelegate of(ScrollPosition.Direction direction) {
        return direction == ScrollPosition.Direction.FORWARD ? FORWARD : REVERSE;
    }

    public static Collection<String> getProjectionInputProperties(JpaEntityInformation<?, ?> entity, Collection<String> projectionProperties, Sort sort) {
        LinkedHashSet<String> properties = new LinkedHashSet<String>(projectionProperties);
        sort.forEach(it -> {
            QueryUtils.checkSortExpression(it);
            properties.add(it.getProperty());
        });
        properties.addAll(entity.getIdAttributeNames());
        return properties;
    }

    public <E, P> @Nullable P createPredicate(KeysetScrollPosition keyset, Sort sort, QueryStrategy<E, P> strategy) {
        Map keysetValues = keyset.getKeys();
        if (keysetValues.isEmpty()) {
            return null;
        }
        ArrayList<P> or = new ArrayList<P>();
        int i = 0;
        for (Sort.Order order : sort) {
            if (!keysetValues.containsKey(order.getProperty())) {
                throw new IllegalStateException(String.format("KeysetScrollPosition does not contain all keyset values. Missing key: %s", order.getProperty()));
            }
            ArrayList<P> sortConstraint = new ArrayList<P>();
            int j = 0;
            for (Sort.Order inner : sort) {
                QueryUtils.checkSortExpression(order);
                E propertyExpression = strategy.createExpression(inner.getProperty());
                Object o = keysetValues.get(inner.getProperty());
                if (j >= i) {
                    sortConstraint.add(strategy.compare(inner, propertyExpression, o));
                    break;
                }
                sortConstraint.add(strategy.compare(inner.getProperty(), propertyExpression, o));
                ++j;
            }
            if (!sortConstraint.isEmpty()) {
                or.add(strategy.and(sortConstraint));
            }
            ++i;
        }
        if (or.isEmpty()) {
            return null;
        }
        return strategy.or(or);
    }

    protected Sort getSortOrders(Sort sort) {
        return sort;
    }

    protected <T> List<T> postProcessResults(List<T> result) {
        return result;
    }

    protected <T> List<T> getResultWindow(List<T> list, int limit) {
        return CollectionUtils.getFirst(limit, list);
    }

    public Sort createSort(Sort sort, JpaEntityInformation<?, ?> entity) {
        ArrayList<Object> sortById;
        if (entity.hasCompositeId()) {
            sortById = new ArrayList<String>(entity.getIdAttributeNames());
        } else {
            sortById = new ArrayList(1);
            sortById.add(entity.getRequiredIdAttribute().getName());
        }
        sort.forEach(it -> {
            boolean bl = sortById.remove(it.getProperty());
        });
        Sort sortToUse = sortById.isEmpty() ? sort : sort.and(Sort.by((String[])sortById.toArray(new String[0])));
        return this.getSortOrders(sortToUse);
    }

    public static interface QueryStrategy<E, P> {
        public E createExpression(String var1);

        public P compare(Sort.Order var1, E var2, @Nullable Object var3);

        public P compare(String var1, E var2, @Nullable Object var3);

        @Nullable
        public P and(List<P> var1);

        @Nullable
        public P or(List<P> var1);
    }

    private static class ReverseKeysetScrollDelegate
    extends KeysetScrollDelegate {
        private ReverseKeysetScrollDelegate() {
        }

        @Override
        protected Sort getSortOrders(Sort sort) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                orders.add(new Sort.Order(order.isAscending() ? Sort.Direction.DESC : Sort.Direction.ASC, order.getProperty()));
            }
            return Sort.by(orders);
        }

        @Override
        protected <T> List<T> postProcessResults(List<T> result) {
            Collections.reverse(result);
            return result;
        }

        @Override
        protected <T> List<T> getResultWindow(List<T> list, int limit) {
            return CollectionUtils.getLast(limit, list);
        }
    }
}

