/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultEntityQuery;
import org.springframework.data.jpa.repository.query.ParametrizedQuery;
import org.springframework.data.jpa.repository.query.PreprocessedQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.query.QueryProvider;

public interface EntityQuery
extends ParametrizedQuery {
    public static EntityQuery create(DeclaredQuery query, QueryEnhancerSelector selector) {
        PreprocessedQuery preparsed = PreprocessedQuery.parse(query);
        QueryEnhancerFactory enhancerFactory = selector.select(preparsed);
        return new DefaultEntityQuery(preparsed, enhancerFactory);
    }

    public <T> T doWithEnhancer(Function<QueryEnhancer, T> var1);

    public boolean hasConstructorExpression();

    public boolean isNative();

    public boolean isDefaultProjection();

    default public boolean usesPaging() {
        return false;
    }

    public ParametrizedQuery deriveCountQuery(@Nullable String var1);

    public QueryProvider rewrite(QueryEnhancer.QueryRewriteInformation var1);
}

