/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategy;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceType;
import org.springframework.core.Ordered;

public class TraceQueryExecutionListener
implements QueryExecutionListener,
MethodExecutionListener,
Ordered {
    private static final Log log = LogFactory.getLog(TraceQueryExecutionListener.class);
    private final TraceListenerStrategy<String, Statement, ResultSet> strategy;

    public TraceQueryExecutionListener(BeanFactory beanFactory, List<TraceType> traceTypes, List<TraceListenerStrategySpanCustomizer<? super CommonDataSource>> customizers) {
        this.strategy = new TraceListenerStrategy(beanFactory, traceTypes, customizers);
    }

    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        this.strategy.beforeQuery(execInfo.getConnectionId(), execInfo.getStatement());
    }

    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        if (execInfo.getMethod().getName().equals("executeUpdate") && execInfo.getThrowable() == null) {
            this.strategy.addQueryRowCount(execInfo.getConnectionId(), execInfo.getStatement(), (Integer)execInfo.getResult());
        }
        String sql = queryInfoList.stream().map(QueryInfo::getQuery).collect(Collectors.joining("\n"));
        this.strategy.afterQuery(execInfo.getConnectionId(), execInfo.getStatement(), sql, execInfo.getThrowable());
    }

    public void beforeMethod(MethodExecutionContext executionContext) {
        Object target = executionContext.getTarget();
        String methodName = executionContext.getMethod().getName();
        String dataSourceName = executionContext.getProxyConfig().getDataSourceName();
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        if (target instanceof DataSource && methodName.equals("getConnection")) {
            DataSource dataSource = (DataSource)target;
            this.strategy.beforeGetConnection(connectionId, dataSource, dataSourceName);
        } else if (target instanceof ResultSet) {
            ResultSet resultSet = (ResultSet)target;
            if (methodName.equals("next")) {
                try {
                    this.strategy.beforeResultSetNext(connectionId, resultSet.getStatement(), resultSet);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public void afterMethod(MethodExecutionContext executionContext) {
        Object target = executionContext.getTarget();
        String methodName = executionContext.getMethod().getName();
        String dataSourceName = executionContext.getProxyConfig().getDataSourceName();
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        Throwable t = executionContext.getThrown();
        if (target instanceof DataSource && methodName.equals("getConnection")) {
            Connection connection = (Connection)executionContext.getResult();
            this.strategy.afterGetConnection(connectionId, connection, dataSourceName, t);
        } else if (target instanceof Connection) {
            switch (methodName) {
                case "commit": {
                    this.strategy.afterCommit(connectionId, t);
                    break;
                }
                case "rollback": {
                    this.strategy.afterRollback(connectionId, t);
                    break;
                }
                case "close": {
                    this.strategy.afterConnectionClose(connectionId, t);
                }
            }
        } else if (target instanceof Statement && methodName.equals("close")) {
            this.strategy.afterStatementClose(connectionId, (Statement)target);
        } else if (target instanceof ResultSet && methodName.equals("close")) {
            ResultSet resultSet = (ResultSet)target;
            this.strategy.afterResultSetClose(connectionId, resultSet, -1, t);
        }
    }

    public int getOrder() {
        return -2147483638;
    }
}

