/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;

public class BraveCurrentTraceContext
implements CurrentTraceContext {
    final brave.propagation.CurrentTraceContext delegate;

    public BraveCurrentTraceContext(brave.propagation.CurrentTraceContext delegate) {
        this.delegate = delegate;
    }

    public TraceContext context() {
        brave.propagation.TraceContext context = this.delegate.get();
        if (context == null) {
            return null;
        }
        return new BraveTraceContext(context);
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        return new BraveScope(this.delegate.newScope(BraveTraceContext.toBrave(context)));
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        return new BraveScope(this.delegate.maybeScope(BraveTraceContext.toBrave(context)));
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return this.delegate.wrap(task);
    }

    public Runnable wrap(Runnable task) {
        return this.delegate.wrap(task);
    }

    public Executor wrap(Executor delegate) {
        return this.delegate.executor(delegate);
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return this.delegate.executorService(delegate);
    }

    static brave.propagation.CurrentTraceContext toBrave(CurrentTraceContext context) {
        return ((BraveCurrentTraceContext)context).delegate;
    }

    static CurrentTraceContext fromBrave(brave.propagation.CurrentTraceContext context) {
        return new BraveCurrentTraceContext(context);
    }
}

