/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.Span;
import brave.Tracer;
import brave.kafka.clients.KafkaTracing;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.MessageListener;

public class MessageListenerMethodInterceptor<T extends MessageListener>
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(MessageListenerMethodInterceptor.class);
    private final KafkaTracing kafkaTracing;
    private final Tracer tracer;

    public MessageListenerMethodInterceptor(KafkaTracing kafkaTracing, Tracer tracer) {
        this.kafkaTracing = kafkaTracing;
        this.tracer = tracer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!"onMessage".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object record = this.record(arguments);
        if (record == null) {
            return invocation.proceed();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Wrapping onMessage call");
        }
        Span span = this.kafkaTracing.nextSpan((ConsumerRecord)record).name("on-message").start();
        try {
            Object object;
            block15: {
                Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
                try {
                    object = invocation.proceed();
                    if (ws == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        String message = e.getMessage();
                        if (message == null) {
                            message = e.getClass().getSimpleName();
                        }
                        span.tag("error", message);
                        throw e;
                    }
                }
                ws.close();
            }
            return object;
        }
        finally {
            span.finish();
        }
    }

    private Object record(Object[] arguments) {
        for (Object object : arguments) {
            if (!(object instanceof ConsumerRecord)) continue;
            return object;
        }
        return null;
    }
}

