/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.kafka.clients.KafkaTracing;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.kafka.core.ProducerPostProcessor;
import org.springframework.util.ClassUtils;

class TraceProducerPostProcessor<K, V>
implements ProducerPostProcessor<K, V> {
    private final BeanFactory beanFactory;
    private KafkaTracing kafkaTracing;
    private static final Class tracingProducer = ClassUtils.resolveClassName((String)"brave.kafka.clients.TracingProducer", null);

    TraceProducerPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private KafkaTracing kafkaTracing() {
        if (this.kafkaTracing == null) {
            this.kafkaTracing = (KafkaTracing)this.beanFactory.getBean(KafkaTracing.class);
        }
        return this.kafkaTracing;
    }

    public Producer<K, V> apply(Producer<K, V> kvProducer) {
        if (tracingProducer.isAssignableFrom(ClassUtils.getUserClass(kvProducer.getClass()))) {
            return kvProducer;
        }
        return this.wrapInTracing(kvProducer);
    }

    Producer<K, V> wrapInTracing(Producer<K, V> kvProducer) {
        return this.kafkaTracing().producer(kvProducer);
    }
}

