/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceType;

@ConfigurationProperties(prefix="spring.sleuth.jdbc")
public class TraceJdbcProperties {
    private boolean enabled = true;
    private Collection<String> excludedDataSourceBeanNames = Collections.emptyList();
    private List<TraceType> includes = Arrays.asList(TraceType.CONNECTION, TraceType.QUERY, TraceType.FETCH);
    private DataSourceProxyProperties datasourceProxy = new DataSourceProxyProperties();
    private P6SpyProperties p6spy = new P6SpyProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<String> getExcludedDataSourceBeanNames() {
        return this.excludedDataSourceBeanNames;
    }

    public List<TraceType> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<TraceType> includes) {
        this.includes = includes;
    }

    public DataSourceProxyProperties getDatasourceProxy() {
        return this.datasourceProxy;
    }

    public P6SpyProperties getP6spy() {
        return this.p6spy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExcludedDataSourceBeanNames(Collection<String> excludedDataSourceBeanNames) {
        this.excludedDataSourceBeanNames = excludedDataSourceBeanNames;
    }

    public void setDatasourceProxy(DataSourceProxyProperties datasourceProxy) {
        this.datasourceProxy = datasourceProxy;
    }

    public void setP6spy(P6SpyProperties p6spy) {
        this.p6spy = p6spy;
    }

    public static class P6SpyProperties {
        private boolean enabled = true;
        private boolean enableLogging = false;
        private boolean multiline = true;
        private P6SpyLogging logging = P6SpyLogging.SLF4J;
        private String logFile = "spy.log";
        private String logFormat;
        private P6SpyTracing tracing = new P6SpyTracing();
        private String customAppenderClass;
        private P6SpyLogFilter logFilter = new P6SpyLogFilter();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnableLogging() {
            return this.enableLogging;
        }

        public void setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
        }

        public boolean isMultiline() {
            return this.multiline;
        }

        public void setMultiline(boolean multiline) {
            this.multiline = multiline;
        }

        public P6SpyLogging getLogging() {
            return this.logging;
        }

        public void setLogging(P6SpyLogging logging) {
            this.logging = logging;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public String getLogFormat() {
            return this.logFormat;
        }

        public void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        public P6SpyTracing getTracing() {
            return this.tracing;
        }

        public void setTracing(P6SpyTracing tracing) {
            this.tracing = tracing;
        }

        public String getCustomAppenderClass() {
            return this.customAppenderClass;
        }

        public void setCustomAppenderClass(String customAppenderClass) {
            this.customAppenderClass = customAppenderClass;
        }

        public P6SpyLogFilter getLogFilter() {
            return this.logFilter;
        }

        public void setLogFilter(P6SpyLogFilter logFilter) {
            this.logFilter = logFilter;
        }

        public static class P6SpyLogFilter {
            private Pattern pattern;

            public Pattern getPattern() {
                return this.pattern;
            }

            public void setPattern(Pattern pattern) {
                this.pattern = pattern;
            }
        }

        public static class P6SpyTracing {
            private boolean includeParameterValues;

            public boolean isIncludeParameterValues() {
                return this.includeParameterValues;
            }

            public void setIncludeParameterValues(boolean includeParameterValues) {
                this.includeParameterValues = includeParameterValues;
            }
        }

        public static enum P6SpyLogging {
            SYSOUT,
            SLF4J,
            FILE,
            CUSTOM;

        }
    }

    public static class DataSourceProxyProperties {
        private boolean enabled = true;
        private DataSourceProxyLogging logging = DataSourceProxyLogging.SLF4J;
        private Query query = new Query();
        private SlowQuery slowQuery = new SlowQuery();
        private boolean multiline = true;
        private boolean jsonFormat = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public DataSourceProxyLogging getLogging() {
            return this.logging;
        }

        public void setLogging(DataSourceProxyLogging logging) {
            this.logging = logging;
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public SlowQuery getSlowQuery() {
            return this.slowQuery;
        }

        public void setSlowQuery(SlowQuery slowQuery) {
            this.slowQuery = slowQuery;
        }

        public boolean isMultiline() {
            return this.multiline;
        }

        public void setMultiline(boolean multiline) {
            this.multiline = multiline;
        }

        public boolean isJsonFormat() {
            return this.jsonFormat;
        }

        public void setJsonFormat(boolean jsonFormat) {
            this.jsonFormat = jsonFormat;
        }

        public static enum DataSourceProxyLogging {
            SYSOUT,
            SLF4J,
            COMMONS,
            JUL;

        }

        public static class SlowQuery {
            private boolean enableLogging = false;
            private String loggerName;
            private String logLevel = "WARN";
            private long threshold = 300L;

            public boolean isEnableLogging() {
                return this.enableLogging;
            }

            public void setEnableLogging(boolean enableLogging) {
                this.enableLogging = enableLogging;
            }

            public String getLoggerName() {
                return this.loggerName;
            }

            public void setLoggerName(String loggerName) {
                this.loggerName = loggerName;
            }

            public String getLogLevel() {
                return this.logLevel;
            }

            public void setLogLevel(String logLevel) {
                this.logLevel = logLevel;
            }

            public long getThreshold() {
                return this.threshold;
            }

            public void setThreshold(long threshold) {
                this.threshold = threshold;
            }
        }

        public static class Query {
            private boolean enableLogging = false;
            private String loggerName;
            private String logLevel = "DEBUG";

            public boolean isEnableLogging() {
                return this.enableLogging;
            }

            public void setEnableLogging(boolean enableLogging) {
                this.enableLogging = enableLogging;
            }

            public String getLoggerName() {
                return this.loggerName;
            }

            public void setLoggerName(String loggerName) {
                this.loggerName = loggerName;
            }

            public String getLogLevel() {
                return this.logLevel;
            }

            public void setLogLevel(String logLevel) {
                this.logLevel = logLevel;
            }
        }
    }
}

