/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public class JavaLoggingSystem
extends AbstractLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public JavaLoggingSystem(ClassLoader classLoader) {
        super(classLoader, "logging.properties");
    }

    @Override
    public void initialize(String configLocation) {
        Assert.notNull((Object)configLocation, (String)"ConfigLocation must not be null");
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)configLocation);
        try {
            LogManager.getLogManager().readConfiguration(ResourceUtils.getURL((String)resolvedLocation).openStream());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize logging from " + configLocation, ex);
        }
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        Assert.notNull((Object)((Object)level), (String)"Level must not be null");
        Logger logger = Logger.getLogger(loggerName == null ? "" : loggerName);
        logger.setLevel(LEVELS.get((Object)level));
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.FINEST);
        levels.put(LogLevel.DEBUG, Level.FINE);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARNING);
        levels.put(LogLevel.ERROR, Level.SEVERE);
        levels.put(LogLevel.FATAL, Level.SEVERE);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

